# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Configures metadata that is used to generate serving time results (e.g.
        # search results or recommendation predictions).
        # The ServingConfig is passed in the search and predict request and generates
        # results.
        # @!attribute [rw] media_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig::MediaConfig]
        #     The MediaConfig of the serving configuration.
        #
        #     Note: The following fields are mutually exclusive: `media_config`, `generic_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] generic_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig::GenericConfig]
        #     The GenericConfig of the serving configuration.
        #
        #     Note: The following fields are mutually exclusive: `generic_config`, `media_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. Fully qualified name
        #     `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The human readable serving config display name. Used in Discovery
        #     UI.
        #
        #     This field must be a UTF-8 encoded string with a length limit of 128
        #     characters. Otherwise, an INVALID_ARGUMENT error is returned.
        # @!attribute [rw] solution_type
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SolutionType]
        #     Required. Immutable. Specifies the solution type that a serving config can
        #     be associated with.
        # @!attribute [rw] model_id
        #   @return [::String]
        #     The id of the model to use at serving time.
        #     Currently only RecommendationModels are supported.
        #     Can be changed but only to a compatible model (e.g.
        #     others-you-may-like CTR to others-you-may-like CVR).
        #
        #     Required when
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType SolutionType} is
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_RECOMMENDATION SOLUTION_TYPE_RECOMMENDATION}.
        # @!attribute [rw] diversity_level
        #   @return [::String]
        #     How much diversity to use in recommendation model results e.g.
        #     `medium-diversity` or `high-diversity`. Currently supported values:
        #
        #     * `no-diversity`
        #     * `low-diversity`
        #     * `medium-diversity`
        #     * `high-diversity`
        #     * `auto-diversity`
        #
        #     If not specified, we choose default based on recommendation model
        #     type. Default value: `no-diversity`.
        #
        #     Can only be set if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType SolutionType} is
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_RECOMMENDATION SOLUTION_TYPE_RECOMMENDATION}.
        # @!attribute [rw] embedding_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::EmbeddingConfig]
        #     Bring your own embedding config. The config is used for search semantic
        #     retrieval. The retrieval is based on the dot product of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec::EmbeddingVector#vector SearchRequest.EmbeddingSpec.EmbeddingVector.vector}
        #     and the document embeddings that are provided by this EmbeddingConfig. If
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec::EmbeddingVector#vector SearchRequest.EmbeddingSpec.EmbeddingVector.vector}
        #     is provided, it overrides this
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#embedding_config ServingConfig.embedding_config}.
        # @!attribute [rw] ranking_expression
        #   @return [::String]
        #     The ranking expression controls the customized ranking on retrieval
        #     documents. To leverage this, document embedding is required. The ranking
        #     expression setting in ServingConfig applies to all search requests served
        #     by the serving config. However, if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#ranking_expression SearchRequest.ranking_expression}
        #     is specified, it overrides the ServingConfig ranking expression.
        #
        #     The ranking expression is a single function or multiple functions that are
        #     joined by "+".
        #
        #       * ranking_expression = function, { " + ", function };
        #
        #     Supported functions:
        #
        #       * double * relevance_score
        #       * double * dotProduct(embedding_field_path)
        #
        #     Function variables:
        #
        #       * `relevance_score`: pre-defined keywords, used for measure relevance
        #       between query and document.
        #       * `embedding_field_path`: the document embedding field
        #       used with query embedding vector.
        #       * `dotProduct`: embedding function between embedding_field_path and query
        #       embedding vector.
        #
        #      Example ranking expression:
        #
        #        If document has an embedding field doc_embedding, the ranking expression
        #        could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. ServingConfig created timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. ServingConfig updated timestamp.
        # @!attribute [rw] filter_control_ids
        #   @return [::Array<::String>]
        #     Filter controls to use in serving path.
        #     All triggered filter controls will be applied.
        #     Filter controls must be in the same data store as the serving config.
        #     Maximum of 20 filter controls.
        # @!attribute [rw] boost_control_ids
        #   @return [::Array<::String>]
        #     Boost controls to use in serving path.
        #     All triggered boost controls will be applied.
        #     Boost controls must be in the same data store as the serving config.
        #     Maximum of 20 boost controls.
        # @!attribute [rw] redirect_control_ids
        #   @return [::Array<::String>]
        #     IDs of the redirect controls. Only the first triggered redirect
        #     action is applied, even if multiple apply. Maximum number of
        #     specifications is 100.
        #
        #     Can only be set if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType SolutionType} is
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_SEARCH SOLUTION_TYPE_SEARCH}.
        # @!attribute [rw] synonyms_control_ids
        #   @return [::Array<::String>]
        #     Condition synonyms specifications. If multiple synonyms conditions
        #     match, all matching synonyms controls in the list will execute.
        #     Maximum number of specifications is 100.
        #
        #     Can only be set if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType SolutionType} is
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_SEARCH SOLUTION_TYPE_SEARCH}.
        # @!attribute [rw] oneway_synonyms_control_ids
        #   @return [::Array<::String>]
        #     Condition oneway synonyms specifications. If multiple oneway synonyms
        #     conditions match, all matching oneway synonyms controls in the list
        #     will execute. Maximum number of specifications is 100.
        #
        #     Can only be set if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType SolutionType} is
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_SEARCH SOLUTION_TYPE_SEARCH}.
        # @!attribute [rw] dissociate_control_ids
        #   @return [::Array<::String>]
        #     Condition do not associate specifications. If multiple do not
        #     associate conditions match, all matching do not associate controls in
        #     the list will execute.
        #     Order does not matter.
        #     Maximum number of specifications is 100.
        #
        #     Can only be set if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType SolutionType} is
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_SEARCH SOLUTION_TYPE_SEARCH}.
        # @!attribute [rw] replacement_control_ids
        #   @return [::Array<::String>]
        #     Condition replacement specifications.
        #     Applied according to the order in the list.
        #     A previously replaced term can not be re-replaced.
        #     Maximum number of specifications is 100.
        #
        #     Can only be set if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType SolutionType} is
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_SEARCH SOLUTION_TYPE_SEARCH}.
        # @!attribute [rw] ignore_control_ids
        #   @return [::Array<::String>]
        #     Condition ignore specifications. If multiple ignore
        #     conditions match, all matching ignore controls in the list will
        #     execute.
        #     Order does not matter.
        #     Maximum number of specifications is 100.
        # @!attribute [rw] personalization_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::PersonalizationSpec]
        #     The specification for personalization spec.
        #
        #     Notice that if both
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#personalization_spec ServingConfig.personalization_spec}
        #     and
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#personalization_spec SearchRequest.personalization_spec}
        #     are set,
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#personalization_spec SearchRequest.personalization_spec}
        #     overrides
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#personalization_spec ServingConfig.personalization_spec}.
        class ServingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the configurations needed for Media Discovery. Currently we
          # support:
          #
          # * `demote_content_watched`: Threshold for watched content demotion.
          # Customers can specify if using watched content demotion or use viewed
          # detail page. Using the content watched demotion, customers need to specify
          # the watched minutes or percentage exceeds the threshold, the content will
          # be demoted in the recommendation result.
          # * `promote_fresh_content`: cutoff days for fresh content promotion.
          # Customers can specify if using content freshness promotion. If the content
          # was published within the cutoff days, the content will be promoted in the
          # recommendation result.
          # Can only be set if
          # {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType SolutionType} is
          # {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_RECOMMENDATION SOLUTION_TYPE_RECOMMENDATION}.
          # @!attribute [rw] content_watched_percentage_threshold
          #   @return [::Float]
          #     Specifies the content watched percentage threshold for demotion.
          #     Threshold value must be between [0, 1.0] inclusive.
          #
          #     Note: The following fields are mutually exclusive: `content_watched_percentage_threshold`, `content_watched_seconds_threshold`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] content_watched_seconds_threshold
          #   @return [::Float]
          #     Specifies the content watched minutes threshold for demotion.
          #
          #     Note: The following fields are mutually exclusive: `content_watched_seconds_threshold`, `content_watched_percentage_threshold`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] demotion_event_type
          #   @return [::String]
          #     Specifies the event type used for demoting recommendation result.
          #     Currently supported values:
          #
          #     * `view-item`: Item viewed.
          #     * `media-play`: Start/resume watching a video, playing a song, etc.
          #     * `media-complete`: Finished or stopped midway through a video, song,
          #     etc.
          #
          #     If unset, watch history demotion will not be applied. Content freshness
          #     demotion will still be applied.
          # @!attribute [rw] demote_content_watched_past_days
          #   @return [::Integer]
          #     Optional. Specifies the number of days to look back for demoting watched
          #     content. If set to zero or unset, defaults to the maximum of 365 days.
          # @!attribute [rw] content_freshness_cutoff_days
          #   @return [::Integer]
          #     Specifies the content freshness used for recommendation result.
          #     Contents will be demoted if contents were published for more than content
          #     freshness cutoff days.
          class MediaConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies the configurations needed for Generic Discovery.Currently we
          # support:
          #
          # * `content_search_spec`: configuration for generic content search.
          # @!attribute [rw] content_search_spec
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec]
          #     Specifies the expected behavior of content search.
          #     Only valid for content-search enabled data store.
          class GenericConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
