# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
        # method.
        # @!attribute [rw] serving_config
        #   @return [::String]
        #     Required. The resource name of the Search serving config, such as
        #     `projects/*/locations/global/collections/default_collection/engines/*/servingConfigs/default_serving_config`,
        #     or
        #     `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
        #     This field is used to identify the serving configuration name, set
        #     of models used to make the search.
        # @!attribute [rw] branch
        #   @return [::String]
        #     The branch resource name, such as
        #     `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
        #
        #     Use `default_branch` as the branch ID or leave this field empty, to search
        #     documents under the default branch.
        # @!attribute [rw] query
        #   @return [::String]
        #     Raw search query.
        # @!attribute [rw] image_query
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ImageQuery]
        #     Raw image query.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s
        #     to return. The maximum allowed value depends on the data type. Values above
        #     the maximum value are coerced to the maximum value.
        #
        #     * Websites with basic indexing: Default `10`, Maximum `25`.
        #     * Websites with advanced indexing: Default `25`, Maximum `50`.
        #     * Other: Default `50`, Maximum `100`.
        #
        #     If this field is negative, an  `INVALID_ARGUMENT` is returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token received from a previous
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
        #     must match the call that provided the page token. Otherwise, an
        #      `INVALID_ARGUMENT`  error is returned.
        # @!attribute [rw] offset
        #   @return [::Integer]
        #     A 0-indexed integer that specifies the current offset (that is, starting
        #     result location, amongst the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s deemed by the API
        #     as relevant) in search results. This field is only considered if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#page_token page_token}
        #     is unset.
        #
        #     If this field is negative, an  `INVALID_ARGUMENT`  is returned.
        # @!attribute [rw] one_box_page_size
        #   @return [::Integer]
        #     The maximum number of results to return for OneBox.
        #     This applies to each OneBox type individually.
        #     Default number is 10.
        # @!attribute [rw] data_store_specs
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::DataStoreSpec>]
        #     Specs defining dataStores to filter on in a search call and configurations
        #     for those dataStores. This is only considered for engines with multiple
        #     dataStores use case. For single dataStore within an engine, they should
        #     use the specs at the top level.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter syntax consists of an expression language for constructing a
        #     predicate from one or more fields of the documents being filtered. Filter
        #     expression is case-sensitive.
        #
        #     If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
        #
        #     Filtering in Vertex AI Search is done by mapping the LHS filter key to a
        #     key property defined in the Vertex AI Search backend -- this mapping is
        #     defined by the customer in their schema. For example a media customer might
        #     have a field 'name' in their schema. In this case the filter would look
        #     like this: filter --> name:'ANY("king kong")'
        #
        #     For more information about filtering including syntax and filter
        #     operators, see
        #     [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
        # @!attribute [rw] canonical_filter
        #   @return [::String]
        #     The default filter that is applied when a user performs a search without
        #     checking any filters on the search page.
        #
        #     The filter applied to every search request when quality improvement such as
        #     query expansion is needed. In the case a query does not have a sufficient
        #     amount of results this filter will be used to determine whether or not to
        #     enable the query expansion flow. The original filter will still be used for
        #     the query expanded search.
        #     This field is strongly recommended to achieve high search quality.
        #
        #     For more information about filter syntax, see
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#filter SearchRequest.filter}.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     The order in which documents are returned. Documents can be ordered by
        #     a field in an {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}
        #     object. Leave it unset if ordered by relevance. `order_by` expression is
        #     case-sensitive.
        #
        #     For more information on ordering the website search results, see
        #     [Order web search
        #     results](https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results).
        #     For more information on ordering the healthcare search results, see
        #     [Order healthcare search
        #     results](https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results).
        #     If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
        # @!attribute [rw] user_info
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::UserInfo]
        #     Information about the end user.
        #     Highly recommended for analytics.
        #     {::Google::Cloud::DiscoveryEngine::V1beta::UserInfo#user_agent UserInfo.user_agent}
        #     is used to deduce `device_type` for analytics.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     The BCP-47 language code, such as "en-US" or "sr-Latn". For more
        #     information, see [Standard
        #     fields](https://cloud.google.com/apis/design/standard_fields). This field
        #     helps to better interpret the query. If a value isn't specified, the query
        #     language code is automatically detected, which may not be accurate.
        # @!attribute [rw] region_code
        #   @return [::String]
        #     The Unicode country/region code (CLDR) of a location, such as "US" and
        #     "419". For more information, see [Standard
        #     fields](https://cloud.google.com/apis/design/standard_fields). If set,
        #     then results will be boosted based on the region_code provided.
        # @!attribute [rw] facet_specs
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::FacetSpec>]
        #     Facet specifications for faceted search. If empty, no facets are returned.
        #
        #     A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
        #     error is returned.
        # @!attribute [rw] boost_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::BoostSpec]
        #     Boost specification to boost certain documents.
        #     For more information on boosting, see
        #     [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
        # @!attribute [rw] params
        #   @return [::Google::Protobuf::Map{::String => ::Google::Protobuf::Value}]
        #     Additional search parameters.
        #
        #     For public website search only, supported values are:
        #
        #     * `user_country_code`: string. Default empty. If set to non-empty, results
        #        are restricted or boosted based on the location provided.
        #        For example, `user_country_code: "au"`
        #
        #        For available codes see [Country
        #        Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
        #
        #     * `search_type`: double. Default empty. Enables non-webpage searching
        #        depending on the value. The only valid non-default value is 1,
        #        which enables image searching.
        #        For example, `search_type: 1`
        # @!attribute [rw] query_expansion_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::QueryExpansionSpec]
        #     The query expansion specification that specifies the conditions under which
        #     query expansion occurs.
        # @!attribute [rw] spell_correction_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SpellCorrectionSpec]
        #     The spell correction specification that specifies the mode under
        #     which spell correction takes effect.
        # @!attribute [rw] user_pseudo_id
        #   @return [::String]
        #     A unique identifier for tracking visitors. For example, this could be
        #     implemented with an HTTP cookie, which should be able to uniquely identify
        #     a visitor on a single device. This unique identifier should not change if
        #     the visitor logs in or out of the website.
        #
        #     This field should NOT have a fixed value such as `unknown_visitor`.
        #
        #     This should be the same identifier as
        #     {::Google::Cloud::DiscoveryEngine::V1beta::UserEvent#user_pseudo_id UserEvent.user_pseudo_id}
        #     and
        #     {::Google::Cloud::DiscoveryEngine::V1beta::CompleteQueryRequest#user_pseudo_id CompleteQueryRequest.user_pseudo_id}
        #
        #     The field must be a UTF-8 encoded string with a length limit of 128
        #     characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
        # @!attribute [rw] content_search_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec]
        #     A specification for configuring the behavior of content search.
        # @!attribute [rw] embedding_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec]
        #     Uses the provided embedding to do additional semantic document retrieval.
        #     The retrieval is based on the dot product of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec::EmbeddingVector#vector SearchRequest.EmbeddingSpec.EmbeddingVector.vector}
        #     and the document embedding that is provided in
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec::EmbeddingVector#field_path SearchRequest.EmbeddingSpec.EmbeddingVector.field_path}.
        #
        #     If
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec::EmbeddingVector#field_path SearchRequest.EmbeddingSpec.EmbeddingVector.field_path}
        #     is not provided, it will use
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#embedding_config ServingConfig.EmbeddingConfig.field_path}.
        # @!attribute [rw] ranking_expression
        #   @return [::String]
        #     The ranking expression controls the customized ranking on retrieval
        #     documents. This overrides
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#ranking_expression ServingConfig.ranking_expression}.
        #     The syntax and supported features depend on the
        #     `ranking_expression_backend` value. If `ranking_expression_backend` is not
        #     provided, it defaults to `RANK_BY_EMBEDDING`.
        #
        #     If
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#ranking_expression_backend ranking_expression_backend}
        #     is not provided or set to `RANK_BY_EMBEDDING`, it should be a single
        #     function or multiple functions that are joined by "+".
        #
        #       * ranking_expression = function, { " + ", function };
        #
        #     Supported functions:
        #
        #       * double * relevance_score
        #       * double * dotProduct(embedding_field_path)
        #
        #     Function variables:
        #
        #       * `relevance_score`: pre-defined keywords, used for measure relevance
        #       between query and document.
        #       * `embedding_field_path`: the document embedding field
        #       used with query embedding vector.
        #       * `dotProduct`: embedding function between `embedding_field_path` and
        #       query embedding vector.
        #
        #      Example ranking expression:
        #
        #        If document has an embedding field doc_embedding, the ranking expression
        #        could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
        #
        #     If
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#ranking_expression_backend ranking_expression_backend}
        #     is set to `RANK_BY_FORMULA`, the following expression types (and
        #     combinations of those chained using + or
        #     * operators) are supported:
        #
        #       * `double`
        #       * `signal`
        #       * `log(signal)`
        #       * `exp(signal)`
        #       * `rr(signal, double > 0)`  -- reciprocal rank transformation with second
        #       argument being a denominator constant.
        #       * `is_nan(signal)` -- returns 0 if signal is NaN, 1 otherwise.
        #       * `fill_nan(signal1, signal2 | double)` -- if signal1 is NaN, returns
        #       signal2 | double, else returns signal1.
        #
        #       Here are a few examples of ranking formulas that use the supported
        #       ranking expression types:
        #
        #       - `0.2 * semantic_similarity_score + 0.8 * log(keyword_similarity_score)`
        #       -- mostly rank by the logarithm of `keyword_similarity_score` with slight
        #       `semantic_smilarity_score` adjustment.
        #       - `0.2 * exp(fill_nan(semantic_similarity_score, 0)) + 0.3 *
        #       is_nan(keyword_similarity_score)` -- rank by the exponent of
        #       `semantic_similarity_score` filling the value with 0 if it's NaN, also
        #       add constant 0.3 adjustment to the final score if
        #       `semantic_similarity_score` is NaN.
        #       - `0.2 * rr(semantic_similarity_score, 16) + 0.8 *
        #       rr(keyword_similarity_score, 16)` -- mostly rank by the reciprocal rank
        #       of `keyword_similarity_score` with slight adjustment of reciprocal rank
        #       of `semantic_smilarity_score`.
        #
        #     The following signals are supported:
        #
        #       * `semantic_similarity_score`: semantic similarity adjustment that is
        #       calculated using the embeddings generated by a proprietary Google model.
        #       This score determines how semantically similar a search query is to a
        #       document.
        #       * `keyword_similarity_score`: keyword match adjustment uses the Best
        #       Match 25 (BM25) ranking function. This score is calculated using a
        #       probabilistic model to estimate the probability that a document is
        #       relevant to a given query.
        #       * `relevance_score`: semantic relevance adjustment that uses a
        #       proprietary Google model to determine the meaning and intent behind a
        #       user's query in context with the content in the documents.
        #       * `pctr_rank`: predicted conversion rate adjustment as a rank use
        #       predicted Click-through rate (pCTR) to gauge the relevance and
        #       attractiveness of a search result from a user's perspective. A higher
        #       pCTR suggests that the result is more likely to satisfy the user's query
        #       and intent, making it a valuable signal for ranking.
        #       * `freshness_rank`: freshness adjustment as a rank
        #       * `document_age`: The time in hours elapsed since the document was last
        #       updated, a floating-point number (e.g., 0.25 means 15 minutes).
        #       * `topicality_rank`: topicality adjustment as a rank. Uses proprietary
        #       Google model to determine the keyword-based overlap between the query and
        #       the document.
        #       * `base_rank`: the default rank of the result
        # @!attribute [rw] ranking_expression_backend
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::RankingExpressionBackend]
        #     The backend to use for the ranking expression evaluation.
        # @!attribute [rw] safe_search
        #   @return [::Boolean]
        #     Whether to turn on safe search. This is only supported for
        #     website search.
        # @!attribute [rw] user_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The user labels applied to a resource must meet the following requirements:
        #
        #     * Each resource can have multiple labels, up to a maximum of 64.
        #     * Each label must be a key-value pair.
        #     * Keys have a minimum length of 1 character and a maximum length of 63
        #       characters and cannot be empty. Values can be empty and have a maximum
        #       length of 63 characters.
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #       underscores, and dashes. All characters must use UTF-8 encoding, and
        #       international characters are allowed.
        #     * The key portion of a label must be unique. However, you can use the same
        #       key with multiple resources.
        #     * Keys must start with a lowercase letter or international character.
        #
        #     See [Google Cloud
        #     Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
        #     for more details.
        # @!attribute [rw] natural_language_query_understanding_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::NaturalLanguageQueryUnderstandingSpec]
        #     If `naturalLanguageQueryUnderstandingSpec` is not specified, no additional
        #     natural language query understanding will be done.
        # @!attribute [rw] search_as_you_type_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SearchAsYouTypeSpec]
        #     Search as you type configuration. Only supported for the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::IndustryVertical::MEDIA IndustryVertical.MEDIA}
        #     vertical.
        # @!attribute [rw] session
        #   @return [::String]
        #     The session resource name. Optional.
        #
        #     Session allows users to do multi-turn /search API calls or coordination
        #     between /search API calls and /answer API calls.
        #
        #     Example #1 (multi-turn /search API calls):
        #       Call /search API with the session ID generated in the first call.
        #       Here, the previous search query gets considered in query
        #       standing. I.e., if the first query is "How did Alphabet do in 2022?"
        #       and the current query is "How about 2023?", the current query will
        #       be interpreted as "How did Alphabet do in 2023?".
        #
        #     Example #2 (coordination between /search API calls and /answer API calls):
        #       Call /answer API with the session ID generated in the first call.
        #       Here, the answer generation happens in the context of the search
        #       results from the first search call.
        #
        #     Multi-turn Search feature is currently at private GA stage. Please use
        #     v1alpha or v1beta version instead before we launch this feature to public
        #     GA. Or ask for allowlisting through Google Support team.
        # @!attribute [rw] session_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SessionSpec]
        #     Session specification.
        #
        #     Can be used only when `session` is set.
        # @!attribute [rw] relevance_threshold
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::RelevanceThreshold]
        #     The relevance threshold of the search results.
        #
        #     Default to Google defined threshold, leveraging a balance of
        #     precision and recall to deliver both highly accurate results and
        #     comprehensive coverage of relevant information.
        # @!attribute [rw] personalization_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::PersonalizationSpec]
        #     The specification for personalization.
        #
        #     Notice that if both
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#personalization_spec ServingConfig.personalization_spec}
        #     and
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#personalization_spec SearchRequest.personalization_spec}
        #     are set,
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#personalization_spec SearchRequest.personalization_spec}
        #     overrides
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#personalization_spec ServingConfig.personalization_spec}.
        class SearchRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the image query input.
          # @!attribute [rw] image_bytes
          #   @return [::String]
          #     Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
          #     BMP.
          class ImageQuery
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A struct to define data stores to filter on in a search call and
          # configurations for those data stores. Otherwise, an `INVALID_ARGUMENT`
          # error is returned.
          # @!attribute [rw] data_store
          #   @return [::String]
          #     Required. Full resource name of
          #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore DataStore}, such as
          #     `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Filter specification to filter documents in the data store
          #     specified by data_store field. For more information on filtering, see
          #     [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
          class DataStoreSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A facet specification to perform faceted search.
          # @!attribute [rw] facet_key
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::FacetSpec::FacetKey]
          #     Required. The facet key specification.
          # @!attribute [rw] limit
          #   @return [::Integer]
          #     Maximum facet values that are returned for this facet. If
          #     unspecified, defaults to 20. The maximum allowed value is 300. Values
          #     above 300 are coerced to 300.
          #     For aggregation in healthcare search, when the [FacetKey.key] is
          #     "healthcare_aggregation_key", the limit will be overridden to
          #     10,000 internally, regardless of the value set here.
          #
          #     If this field is negative, an  `INVALID_ARGUMENT`  is returned.
          # @!attribute [rw] excluded_filter_keys
          #   @return [::Array<::String>]
          #     List of keys to exclude when faceting.
          #
          #
          #     By default,
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::FacetSpec::FacetKey#key FacetKey.key}
          #     is not excluded from the filter unless it is listed in this field.
          #
          #     Listing a facet key in this field allows its values to appear as facet
          #     results, even when they are filtered out of search results. Using this
          #     field does not affect what search results are returned.
          #
          #     For example, suppose there are 100 documents with the color facet "Red"
          #     and 200 documents with the color facet "Blue". A query containing the
          #     filter "color:ANY("Red")" and having "color" as
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::FacetSpec::FacetKey#key FacetKey.key}
          #     would by default return only "Red" documents in the search results, and
          #     also return "Red" with count 100 as the only color facet. Although there
          #     are also blue documents available, "Blue" would not be shown as an
          #     available facet value.
          #
          #     If "color" is listed in "excludedFilterKeys", then the query returns the
          #     facet values "Red" with count 100 and "Blue" with count 200, because the
          #     "color" key is now excluded from the filter. Because this field doesn't
          #     affect search results, the search results are still correctly filtered to
          #     return only "Red" documents.
          #
          #     A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
          #     error is returned.
          # @!attribute [rw] enable_dynamic_position
          #   @return [::Boolean]
          #     Enables dynamic position for this facet. If set to true, the position of
          #     this facet among all facets in the response is determined automatically.
          #     If dynamic facets are enabled, it is ordered together.
          #     If set to false, the position of this facet in the
          #     response is the same as in the request, and it is ranked before
          #     the facets with dynamic position enable and all dynamic facets.
          #
          #     For example, you may always want to have rating facet returned in
          #     the response, but it's not necessarily to always display the rating facet
          #     at the top. In that case, you can set enable_dynamic_position to true so
          #     that the position of rating facet in response is determined
          #     automatically.
          #
          #     Another example, assuming you have the following facets in the request:
          #
          #     * "rating", enable_dynamic_position = true
          #
          #     * "price", enable_dynamic_position = false
          #
          #     * "brands", enable_dynamic_position = false
          #
          #     And also you have a dynamic facets enabled, which generates a facet
          #     `gender`. Then the final order of the facets in the response can be
          #     ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
          #     "rating") depends on how API orders "gender" and "rating" facets.
          #     However, notice that "price" and "brands" are always
          #     ranked at first and second position because their enable_dynamic_position
          #     is false.
          class FacetSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Specifies how a facet is computed.
            # @!attribute [rw] key
            #   @return [::String]
            #     Required. Supported textual and numerical facet keys in
            #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document} object, over
            #     which the facet values are computed. Facet key is case-sensitive.
            # @!attribute [rw] intervals
            #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::Interval>]
            #     Set only if values should be bucketed into intervals. Must be set
            #     for facets with numerical values. Must not be set for facet with text
            #     values. Maximum number of intervals is 30.
            # @!attribute [rw] restricted_values
            #   @return [::Array<::String>]
            #     Only get facet for the given restricted values. Only supported on
            #     textual fields. For example, suppose "category" has three values
            #     "Action > 2022", "Action > 2021" and "Sci-Fi > 2022". If set
            #     "restricted_values" to "Action > 2022", the "category" facet only
            #     contains "Action > 2022". Only supported on textual fields. Maximum
            #     is 10.
            # @!attribute [rw] prefixes
            #   @return [::Array<::String>]
            #     Only get facet values that start with the given string prefix. For
            #     example, suppose "category" has three values "Action > 2022",
            #     "Action > 2021" and "Sci-Fi > 2022". If set "prefixes" to "Action", the
            #     "category" facet only contains "Action > 2022" and "Action > 2021".
            #     Only supported on textual fields. Maximum is 10.
            # @!attribute [rw] contains
            #   @return [::Array<::String>]
            #     Only get facet values that contain the given strings. For example,
            #     suppose "category" has three values "Action > 2022",
            #     "Action > 2021" and "Sci-Fi > 2022". If set "contains" to "2022", the
            #     "category" facet only contains "Action > 2022" and "Sci-Fi > 2022".
            #     Only supported on textual fields. Maximum is 10.
            # @!attribute [rw] case_insensitive
            #   @return [::Boolean]
            #     True to make facet keys case insensitive when getting faceting
            #     values with prefixes or contains; false otherwise.
            # @!attribute [rw] order_by
            #   @return [::String]
            #     The order in which documents are returned.
            #
            #     Allowed values are:
            #
            #     * "count desc", which means order by
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Facet::FacetValue#count SearchResponse.Facet.values.count}
            #     descending.
            #
            #     * "value desc", which means order by
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Facet::FacetValue#value SearchResponse.Facet.values.value}
            #     descending.
            #       Only applies to textual facets.
            #
            #     If not set, textual values are sorted in [natural
            #     order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
            #     intervals are sorted in the order given by
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::FacetSpec::FacetKey#intervals FacetSpec.FacetKey.intervals}.
            class FacetKey
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Boost specification to boost certain documents.
          # @!attribute [rw] condition_boost_specs
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::BoostSpec::ConditionBoostSpec>]
          #     Condition boost specifications. If a document matches multiple conditions
          #     in the specifictions, boost scores from these specifications are all
          #     applied and combined in a non-linear way. Maximum number of
          #     specifications is 20.
          class BoostSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Boost applies to documents which match a condition.
            # @!attribute [rw] condition
            #   @return [::String]
            #     An expression which specifies a boost condition. The syntax and
            #     supported fields are the same as a filter expression. See
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#filter SearchRequest.filter}
            #     for detail syntax and limitations.
            #
            #     Examples:
            #
            #     * To boost documents with document ID "doc_1" or "doc_2", and
            #     color "Red" or "Blue":
            #     `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
            # @!attribute [rw] boost
            #   @return [::Float]
            #     Strength of the condition boost, which should be in [-1, 1]. Negative
            #     boost means demotion. Default is 0.0.
            #
            #     Setting to 1.0 gives the document a big promotion. However, it does
            #     not necessarily mean that the boosted document will be the top result
            #     at all times, nor that other documents will be excluded. Results
            #     could still be shown even when none of them matches the condition.
            #     And results that are significantly more relevant to the search query
            #     can still trump your heavily favored but irrelevant documents.
            #
            #     Setting to -1.0 gives the document a big demotion. However, results
            #     that are deeply relevant might still be shown. The document will have
            #     an upstream battle to get a fairly high ranking, but it is not
            #     blocked out completely.
            #
            #     Setting to 0.0 means no boost applied. The boosting condition is
            #     ignored. Only one of the (condition, boost) combination or the
            #     boost_control_spec below are set. If both are set then the global boost
            #     is ignored and the more fine-grained boost_control_spec is applied.
            # @!attribute [rw] boost_control_spec
            #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::BoostSpec::ConditionBoostSpec::BoostControlSpec]
            #     Complex specification for custom ranking based on customer defined
            #     attribute value.
            class ConditionBoostSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Specification for custom ranking based on customer specified attribute
              # value. It provides more controls for customized ranking than the simple
              # (condition, boost) combination above.
              # @!attribute [rw] field_name
              #   @return [::String]
              #     The name of the field whose value will be used to determine the
              #     boost amount.
              # @!attribute [rw] attribute_type
              #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::BoostSpec::ConditionBoostSpec::BoostControlSpec::AttributeType]
              #     The attribute type to be used to determine the boost amount. The
              #     attribute value can be derived from the field value of the specified
              #     field_name. In the case of numerical it is straightforward i.e.
              #     attribute_value = numerical_field_value. In the case of freshness
              #     however, attribute_value = (time.now() - datetime_field_value).
              # @!attribute [rw] interpolation_type
              #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::BoostSpec::ConditionBoostSpec::BoostControlSpec::InterpolationType]
              #     The interpolation type to be applied to connect the control points
              #     listed below.
              # @!attribute [rw] control_points
              #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::BoostSpec::ConditionBoostSpec::BoostControlSpec::ControlPoint>]
              #     The control points used to define the curve. The monotonic function
              #     (defined through the interpolation_type above) passes through the
              #     control points listed here.
              class BoostControlSpec
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # The control points used to define the curve. The curve defined
                # through these control points can only be monotonically increasing
                # or decreasing(constant values are acceptable).
                # @!attribute [rw] attribute_value
                #   @return [::String]
                #     Can be one of:
                #     1. The numerical field value.
                #     2. The duration spec for freshness:
                #     The value must be formatted as an XSD `dayTimeDuration` value (a
                #     restricted subset of an ISO 8601 duration value). The pattern for
                #     this is: `[nD][T[nH][nM][nS]]`.
                # @!attribute [rw] boost_amount
                #   @return [::Float]
                #     The value between -1 to 1 by which to boost the score if the
                #     attribute_value evaluates to the value specified above.
                class ControlPoint
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods
                end

                # The attribute(or function) for which the custom ranking is to be
                # applied.
                module AttributeType
                  # Unspecified AttributeType.
                  ATTRIBUTE_TYPE_UNSPECIFIED = 0

                  # The value of the numerical field will be used to dynamically update
                  # the boost amount. In this case, the attribute_value (the x value)
                  # of the control point will be the actual value of the numerical
                  # field for which the boost_amount is specified.
                  NUMERICAL = 1

                  # For the freshness use case the attribute value will be the duration
                  # between the current time and the date in the datetime field
                  # specified. The value must be formatted as an XSD `dayTimeDuration`
                  # value (a restricted subset of an ISO 8601 duration value). The
                  # pattern for this is: `[nD][T[nH][nM][nS]]`.
                  # For example, `5D`, `3DT12H30M`, `T24H`.
                  FRESHNESS = 2
                end

                # The interpolation type to be applied. Default will be linear
                # (Piecewise Linear).
                module InterpolationType
                  # Interpolation type is unspecified. In this case, it defaults to
                  # Linear.
                  INTERPOLATION_TYPE_UNSPECIFIED = 0

                  # Piecewise linear interpolation will be applied.
                  LINEAR = 1
                end
              end
            end
          end

          # Specification to determine under which conditions query expansion should
          # occur.
          # @!attribute [rw] condition
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::QueryExpansionSpec::Condition]
          #     The condition under which query expansion should occur. Default to
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::QueryExpansionSpec::Condition::DISABLED Condition.DISABLED}.
          # @!attribute [rw] pin_unexpanded_results
          #   @return [::Boolean]
          #     Whether to pin unexpanded results. If this field is set to true,
          #     unexpanded products are always at the top of the search results, followed
          #     by the expanded results.
          class QueryExpansionSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum describing under which condition query expansion should occur.
            module Condition
              # Unspecified query expansion condition. In this case, server behavior
              # defaults to
              # {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::QueryExpansionSpec::Condition::DISABLED Condition.DISABLED}.
              CONDITION_UNSPECIFIED = 0

              # Disabled query expansion. Only the exact search query is used, even if
              # {::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse#total_size SearchResponse.total_size}
              # is zero.
              DISABLED = 1

              # Automatic query expansion built by the Search API.
              AUTO = 2
            end
          end

          # The specification for query spell correction.
          # @!attribute [rw] mode
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SpellCorrectionSpec::Mode]
          #     The mode under which spell correction
          #     replaces the original search query. Defaults to
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SpellCorrectionSpec::Mode::AUTO Mode.AUTO}.
          class SpellCorrectionSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum describing under which mode spell correction should occur.
            module Mode
              # Unspecified spell correction mode. In this case, server behavior
              # defaults to
              # {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SpellCorrectionSpec::Mode::AUTO Mode.AUTO}.
              MODE_UNSPECIFIED = 0

              # Search API tries to find a spelling suggestion. If a suggestion is
              # found, it is put in the
              # {::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse#corrected_query SearchResponse.corrected_query}.
              # The spelling suggestion won't be used as the search query.
              SUGGESTION_ONLY = 1

              # Automatic spell correction built by the Search API. Search will
              # be based on the corrected query if found.
              AUTO = 2
            end
          end

          # A specification for configuring the behavior of content search.
          # @!attribute [rw] snippet_spec
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SnippetSpec]
          #     If `snippetSpec` is not specified, snippets are not included in the
          #     search response.
          # @!attribute [rw] summary_spec
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SummarySpec]
          #     If `summarySpec` is not specified, summaries are not included in the
          #     search response.
          # @!attribute [rw] extractive_content_spec
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::ExtractiveContentSpec]
          #     If there is no extractive_content_spec provided, there will be no
          #     extractive answer in the search response.
          # @!attribute [rw] search_result_mode
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SearchResultMode]
          #     Specifies the search result mode. If unspecified, the
          #     search result mode defaults to `DOCUMENTS`.
          # @!attribute [rw] chunk_spec
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::ChunkSpec]
          #     Specifies the chunk spec to be returned from the search response.
          #     Only available if the
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec#search_result_mode SearchRequest.ContentSearchSpec.search_result_mode}
          #     is set to
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SearchResultMode::CHUNKS CHUNKS}
          class ContentSearchSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A specification for configuring snippets in a search response.
            # @!attribute [rw] max_snippet_count
            #   @deprecated This field is deprecated and may be removed in the next major version update.
            #   @return [::Integer]
            #     [DEPRECATED] This field is deprecated. To control snippet return, use
            #     `return_snippet` field. For backwards compatibility, we will return
            #     snippet if max_snippet_count > 0.
            # @!attribute [rw] reference_only
            #   @deprecated This field is deprecated and may be removed in the next major version update.
            #   @return [::Boolean]
            #     [DEPRECATED] This field is deprecated and will have no affect on the
            #     snippet.
            # @!attribute [rw] return_snippet
            #   @return [::Boolean]
            #     If `true`, then return snippet. If no snippet can be generated, we
            #     return "No snippet is available for this page." A `snippet_status` with
            #     `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be returned.
            class SnippetSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A specification for configuring a summary returned in a search
            # response.
            # @!attribute [rw] summary_result_count
            #   @return [::Integer]
            #     The number of top results to generate the summary from. If the number
            #     of results returned is less than `summaryResultCount`, the summary is
            #     generated from all of the results.
            #
            #     At most 10 results for documents mode, or 50 for chunks mode, can be
            #     used to generate a summary. The chunks mode is used when
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec#search_result_mode SearchRequest.ContentSearchSpec.search_result_mode}
            #     is set to
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SearchResultMode::CHUNKS CHUNKS}.
            # @!attribute [rw] include_citations
            #   @return [::Boolean]
            #     Specifies whether to include citations in the summary. The default
            #     value is `false`.
            #
            #     When this field is set to `true`, summaries include in-line citation
            #     numbers.
            #
            #     Example summary including citations:
            #
            #     BigQuery is Google Cloud's fully managed and completely serverless
            #     enterprise data warehouse [1]. BigQuery supports all data types, works
            #     across clouds, and has built-in machine learning and business
            #     intelligence, all within a unified platform [2, 3].
            #
            #     The citation numbers refer to the returned search results and are
            #     1-indexed. For example, [1] means that the sentence is attributed to
            #     the first search result. [2, 3] means that the sentence is attributed
            #     to both the second and third search results.
            # @!attribute [rw] ignore_adversarial_query
            #   @return [::Boolean]
            #     Specifies whether to filter out adversarial queries. The default value
            #     is `false`.
            #
            #     Google employs search-query classification to detect adversarial
            #     queries. No summary is returned if the search query is classified as an
            #     adversarial query. For example, a user might ask a question regarding
            #     negative comments about the company or submit a query designed to
            #     generate unsafe, policy-violating output. If this field is set to
            #     `true`, we skip generating summaries for adversarial queries and return
            #     fallback messages instead.
            # @!attribute [rw] ignore_non_summary_seeking_query
            #   @return [::Boolean]
            #     Specifies whether to filter out queries that are not summary-seeking.
            #     The default value is `false`.
            #
            #     Google employs search-query classification to detect summary-seeking
            #     queries. No summary is returned if the search query is classified as a
            #     non-summary seeking query. For example, `why is the sky blue` and `Who
            #     is the best soccer player in the world?` are summary-seeking queries,
            #     but `SFO airport` and `world cup 2026` are not. They are most likely
            #     navigational queries. If this field is set to `true`, we skip
            #     generating summaries for non-summary seeking queries and return
            #     fallback messages instead.
            # @!attribute [rw] ignore_low_relevant_content
            #   @return [::Boolean]
            #     Specifies whether to filter out queries that have low relevance. The
            #     default value is `false`.
            #
            #     If this field is set to `false`, all search results are used regardless
            #     of relevance to generate answers. If set to `true`, only queries with
            #     high relevance search results will generate answers.
            # @!attribute [rw] ignore_jail_breaking_query
            #   @return [::Boolean]
            #     Optional. Specifies whether to filter out jail-breaking queries. The
            #     default value is `false`.
            #
            #     Google employs search-query classification to detect jail-breaking
            #     queries. No summary is returned if the search query is classified as a
            #     jail-breaking query. A user might add instructions to the query to
            #     change the tone, style, language, content of the answer, or ask the
            #     model to act as a different entity, e.g. "Reply in the tone of a
            #     competing company's CEO". If this field is set to `true`, we skip
            #     generating summaries for jail-breaking queries and return fallback
            #     messages instead.
            # @!attribute [rw] model_prompt_spec
            #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SummarySpec::ModelPromptSpec]
            #     If specified, the spec will be used to modify the prompt provided to
            #     the LLM.
            # @!attribute [rw] language_code
            #   @return [::String]
            #     Language code for Summary. Use language tags defined by
            #     [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
            #     Note: This is an experimental feature.
            # @!attribute [rw] model_spec
            #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SummarySpec::ModelSpec]
            #     If specified, the spec will be used to modify the model specification
            #     provided to the LLM.
            # @!attribute [rw] use_semantic_chunks
            #   @return [::Boolean]
            #     If true, answer will be generated from most relevant chunks from top
            #     search results. This feature will improve summary quality.
            #     Note that with this feature enabled, not all top search results
            #     will be referenced and included in the reference list, so the citation
            #     source index only points to the search results listed in the reference
            #     list.
            class SummarySpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Specification of the prompt to use with the model.
              # @!attribute [rw] preamble
              #   @return [::String]
              #     Text at the beginning of the prompt that instructs the assistant.
              #     Examples are available in the user guide.
              class ModelPromptSpec
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # Specification of the model.
              # @!attribute [rw] version
              #   @return [::String]
              #     The model version used to generate the summary.
              #
              #     Supported values are:
              #
              #     * `stable`: string. Default value when no value is specified. Uses a
              #        generally available, fine-tuned model. For more information, see
              #        [Answer generation model versions and
              #        lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
              #     * `preview`: string. (Public preview) Uses a preview model. For more
              #        information, see
              #        [Answer generation model versions and
              #        lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
              class ModelSpec
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # A specification for configuring the extractive content in a search
            # response.
            # @!attribute [rw] max_extractive_answer_count
            #   @return [::Integer]
            #     The maximum number of extractive answers returned in each search
            #     result.
            #
            #     An extractive answer is a verbatim answer extracted from the original
            #     document, which provides a precise and contextually relevant answer to
            #     the search query.
            #
            #     If the number of matching answers is less than the
            #     `max_extractive_answer_count`, return all of the answers. Otherwise,
            #     return the `max_extractive_answer_count`.
            #
            #     At most five answers are returned for each
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SearchResult SearchResult}.
            # @!attribute [rw] max_extractive_segment_count
            #   @return [::Integer]
            #     The max number of extractive segments returned in each search result.
            #     Only applied if the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore DataStore} is set to
            #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore::ContentConfig::CONTENT_REQUIRED DataStore.ContentConfig.CONTENT_REQUIRED}
            #     or
            #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore#solution_types DataStore.solution_types}
            #     is
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_CHAT SOLUTION_TYPE_CHAT}.
            #
            #     An extractive segment is a text segment extracted from the original
            #     document that is relevant to the search query, and, in general, more
            #     verbose than an extractive answer. The segment could then be used as
            #     input for LLMs to generate summaries and answers.
            #
            #     If the number of matching segments is less than
            #     `max_extractive_segment_count`, return all of the segments. Otherwise,
            #     return the `max_extractive_segment_count`.
            # @!attribute [rw] return_extractive_segment_score
            #   @return [::Boolean]
            #     Specifies whether to return the confidence score from the extractive
            #     segments in each search result. This feature is available only for new
            #     or allowlisted data stores. To allowlist your data store,
            #     contact your Customer Engineer. The default value is `false`.
            # @!attribute [rw] num_previous_segments
            #   @return [::Integer]
            #     Specifies whether to also include the adjacent from each selected
            #     segments.
            #     Return at most `num_previous_segments` segments before each selected
            #     segments.
            # @!attribute [rw] num_next_segments
            #   @return [::Integer]
            #     Return at most `num_next_segments` segments after each selected
            #     segments.
            class ExtractiveContentSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Specifies the chunk spec to be returned from the search response.
            # Only available if the
            # {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec#search_result_mode SearchRequest.ContentSearchSpec.search_result_mode}
            # is set to
            # {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SearchResultMode::CHUNKS CHUNKS}
            # @!attribute [rw] num_previous_chunks
            #   @return [::Integer]
            #     The number of previous chunks to be returned of the current chunk. The
            #     maximum allowed value is 3.
            #     If not specified, no previous chunks will be returned.
            # @!attribute [rw] num_next_chunks
            #   @return [::Integer]
            #     The number of next chunks to be returned of the current chunk. The
            #     maximum allowed value is 3.
            #     If not specified, no next chunks will be returned.
            class ChunkSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Specifies the search result mode. If unspecified, the
            # search result mode defaults to `DOCUMENTS`.
            module SearchResultMode
              # Default value.
              SEARCH_RESULT_MODE_UNSPECIFIED = 0

              # Returns documents in the search result.
              DOCUMENTS = 1

              # Returns chunks in the search result. Only available if the
              # [DataStore.DocumentProcessingConfig.chunking_config][] is specified.
              CHUNKS = 2
            end
          end

          # The specification that uses customized query embedding vector to do
          # semantic document retrieval.
          # @!attribute [rw] embedding_vectors
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec::EmbeddingVector>]
          #     The embedding vector used for retrieval. Limit to 1.
          class EmbeddingSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Embedding vector.
            # @!attribute [rw] field_path
            #   @return [::String]
            #     Embedding field path in schema.
            # @!attribute [rw] vector
            #   @return [::Array<::Float>]
            #     Query embedding vector.
            class EmbeddingVector
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Specification to enable natural language understanding capabilities for
          # search requests.
          # @!attribute [rw] filter_extraction_condition
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::NaturalLanguageQueryUnderstandingSpec::FilterExtractionCondition]
          #     The condition under which filter extraction should occur.
          #     Default to [Condition.DISABLED][].
          # @!attribute [rw] geo_search_query_detection_field_names
          #   @return [::Array<::String>]
          #     Field names used for location-based filtering, where geolocation filters
          #     are detected in natural language search queries.
          #     Only valid when the FilterExtractionCondition is set to `ENABLED`.
          #
          #     If this field is set, it overrides the field names set in
          #     [ServingConfig.geo_search_query_detection_field_names][google.cloud.discoveryengine.v1beta.ServingConfig.geo_search_query_detection_field_names].
          class NaturalLanguageQueryUnderstandingSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum describing under which condition filter extraction should occur.
            module FilterExtractionCondition
              # Server behavior defaults to [Condition.DISABLED][].
              CONDITION_UNSPECIFIED = 0

              # Disables NL filter extraction.
              DISABLED = 1

              # Enables NL filter extraction.
              ENABLED = 2
            end
          end

          # Specification for search as you type in search requests.
          # @!attribute [rw] condition
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SearchAsYouTypeSpec::Condition]
          #     The condition under which search as you type should occur.
          #     Default to
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SearchAsYouTypeSpec::Condition::DISABLED Condition.DISABLED}.
          class SearchAsYouTypeSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum describing under which condition search as you type should occur.
            module Condition
              # Server behavior defaults to
              # {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SearchAsYouTypeSpec::Condition::DISABLED Condition.DISABLED}.
              CONDITION_UNSPECIFIED = 0

              # Disables Search As You Type.
              DISABLED = 1

              # Enables Search As You Type.
              ENABLED = 2
            end
          end

          # Session specification.
          #
          # Multi-turn Search feature is currently at private GA stage. Please use
          # v1alpha or v1beta version instead before we launch this feature to public
          # GA. Or ask for allowlisting through Google Support team.
          # @!attribute [rw] query_id
          #   @return [::String]
          #     If set, the search result gets stored to the "turn" specified by this
          #     query ID.
          #
          #     Example: Let's say the session looks like this:
          #       session {
          #         name: ".../sessions/xxx"
          #         turns {
          #           query { text: "What is foo?" query_id: ".../questions/yyy" }
          #           answer: "Foo is ..."
          #         }
          #         turns {
          #           query { text: "How about bar then?" query_id: ".../questions/zzz" }
          #         }
          #       }
          #
          #     The user can call /search API with a request like this:
          #
          #        session: ".../sessions/xxx"
          #        session_spec { query_id: ".../questions/zzz" }
          #
          #     Then, the API stores the search result, associated with the last turn.
          #     The stored search result can be used by a subsequent /answer API call
          #     (with the session ID and the query ID specified). Also, it is possible
          #     to call /search and /answer in parallel with the same session ID & query
          #     ID.
          # @!attribute [rw] search_result_persistence_count
          #   @return [::Integer]
          #     The number of top search results to persist. The persisted search results
          #     can be used for the subsequent /answer api call.
          #
          #     This field is simliar to the `summary_result_count` field in
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SummarySpec#summary_result_count SearchRequest.ContentSearchSpec.SummarySpec.summary_result_count}.
          #
          #     At most 10 results for documents mode, or 50 for chunks mode.
          class SessionSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The specification for personalization.
          # @!attribute [rw] mode
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::PersonalizationSpec::Mode]
          #     The personalization mode of the search request.
          #     Defaults to
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::PersonalizationSpec::Mode::AUTO Mode.AUTO}.
          class PersonalizationSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The personalization mode of each search request.
            module Mode
              # Default value. In this case, server behavior defaults to
              # {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::PersonalizationSpec::Mode::AUTO Mode.AUTO}.
              MODE_UNSPECIFIED = 0

              # Personalization is enabled if data quality requirements are met.
              AUTO = 1

              # Disable personalization.
              DISABLED = 2
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Protobuf::Value]
          class ParamsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class UserLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The relevance threshold of the search results. The higher relevance
          # threshold is, the higher relevant results are shown and the less number of
          # results are returned.
          module RelevanceThreshold
            # Default value. In this case, server behavior defaults to Google defined
            # threshold.
            RELEVANCE_THRESHOLD_UNSPECIFIED = 0

            # Lowest relevance threshold.
            LOWEST = 1

            # Low relevance threshold.
            LOW = 2

            # Medium relevance threshold.
            MEDIUM = 3

            # High relevance threshold.
            HIGH = 4
          end

          # The backend to use for the ranking expression evaluation.
          module RankingExpressionBackend
            # Default option for unspecified/unknown values.
            RANKING_EXPRESSION_BACKEND_UNSPECIFIED = 0

            # Ranking by custom embedding model, the default way to evaluate the
            # ranking expression.
            RANK_BY_EMBEDDING = 3

            # Ranking by custom formula.
            RANK_BY_FORMULA = 4
          end
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
        # method.
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SearchResult>]
        #     A list of matched documents. The order represents the ranking.
        # @!attribute [rw] facets
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Facet>]
        #     Results of facets requested by user.
        # @!attribute [rw] guided_search_result
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::GuidedSearchResult]
        #     Guided search result.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The estimated total count of matched items irrespective of pagination. The
        #     count of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse#results results}
        #     returned by pagination may be less than the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse#total_size total_size}
        #     that matches.
        # @!attribute [rw] attribution_token
        #   @return [::String]
        #     A unique search token. This should be included in the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::UserEvent UserEvent} logs resulting
        #     from this search, which enables accurate attribution of search model
        #     performance. This also helps to identify a request during the customer
        #     support scenarios.
        # @!attribute [rw] redirect_uri
        #   @return [::String]
        #     The URI of a customer-defined redirect page. If redirect action is
        #     triggered, no search is performed, and only
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse#redirect_uri redirect_uri}
        #     and
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse#attribution_token attribution_token}
        #     are set in the response.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#page_token SearchRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        # @!attribute [rw] corrected_query
        #   @return [::String]
        #     Contains the spell corrected query, if found. If the spell correction type
        #     is AUTOMATIC, then the search results are based on corrected_query.
        #     Otherwise the original query is used for search.
        # @!attribute [rw] summary
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Summary]
        #     A summary as part of the search results.
        #     This field is only returned if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec#summary_spec SearchRequest.ContentSearchSpec.summary_spec}
        #     is set.
        # @!attribute [rw] applied_controls
        #   @return [::Array<::String>]
        #     Controls applied as part of the Control service.
        # @!attribute [rw] geo_search_debug_info
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::GeoSearchDebugInfo>]
        # @!attribute [rw] query_expansion_info
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::QueryExpansionInfo]
        #     Query expansion information for the returned results.
        # @!attribute [rw] natural_language_query_understanding_info
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::NaturalLanguageQueryUnderstandingInfo]
        #     Natural language query understanding information for the returned results.
        # @!attribute [rw] session_info
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SessionInfo]
        #     Session information.
        #
        #     Only set if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#session SearchRequest.session}
        #     is provided. See its description for more details.
        # @!attribute [rw] one_box_results
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::OneBoxResult>]
        #     A list of One Box results. There can be multiple One Box results of
        #     different types.
        class SearchResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents the search results.
          # @!attribute [rw] id
          #   @return [::String]
          #     {::Google::Cloud::DiscoveryEngine::V1beta::Document#id Document.id} of the
          #     searched {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}.
          # @!attribute [rw] document
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Document]
          #     The document data snippet in the search response. Only fields that are
          #     marked as `retrievable` are populated.
          # @!attribute [rw] chunk
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Chunk]
          #     The chunk data in the search response if the
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec#search_result_mode SearchRequest.ContentSearchSpec.search_result_mode}
          #     is set to
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SearchResultMode::CHUNKS CHUNKS}.
          # @!attribute [rw] model_scores
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::DiscoveryEngine::V1beta::DoubleList}]
          #     Google provided available scores.
          # @!attribute [rw] rank_signals
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SearchResult::RankSignals]
          #     A set of ranking signals associated with the result.
          class SearchResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::DiscoveryEngine::V1beta::DoubleList]
            class ModelScoresEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A set of ranking signals.
            # @!attribute [rw] keyword_similarity_score
            #   @return [::Float]
            #     Keyword matching adjustment.
            # @!attribute [rw] relevance_score
            #   @return [::Float]
            #     Semantic relevance adjustment.
            # @!attribute [rw] semantic_similarity_score
            #   @return [::Float]
            #     Semantic similarity adjustment.
            # @!attribute [rw] pctr_rank
            #   @return [::Float]
            #     Predicted conversion rate adjustment as a rank.
            # @!attribute [rw] topicality_rank
            #   @return [::Float]
            #     Topicality adjustment as a rank.
            # @!attribute [rw] document_age
            #   @return [::Float]
            #     Age of the document in hours.
            # @!attribute [rw] boosting_factor
            #   @return [::Float]
            #     Combined custom boosts for a doc.
            # @!attribute [rw] default_rank
            #   @return [::Float]
            #     The default rank of the result.
            # @!attribute [rw] custom_signals
            #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SearchResult::RankSignals::CustomSignal>]
            #     A list of custom clearbox signals.
            class RankSignals
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Custom clearbox signal represented by name and value pair.
              # @!attribute [rw] name
              #   @return [::String]
              #     Name of the signal.
              # @!attribute [rw] value
              #   @return [::Float]
              #     Float value representing the ranking signal (e.g. 1.25 for BM25).
              class CustomSignal
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end

          # A facet result.
          # @!attribute [rw] key
          #   @return [::String]
          #     The key for this facet. For example, `"colors"` or `"price"`. It matches
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::FacetSpec::FacetKey#key SearchRequest.FacetSpec.FacetKey.key}.
          # @!attribute [rw] values
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Facet::FacetValue>]
          #     The facet values for this field.
          # @!attribute [rw] dynamic_facet
          #   @return [::Boolean]
          #     Whether the facet is dynamically generated.
          class Facet
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A facet value which contains value names and their count.
            # @!attribute [rw] value
            #   @return [::String]
            #     Text value of a facet, such as "Black" for facet "colors".
            #
            #     Note: The following fields are mutually exclusive: `value`, `interval`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] interval
            #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Interval]
            #     Interval value for a facet, such as [10, 20) for facet "price". It
            #     matches
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::FacetSpec::FacetKey#intervals SearchRequest.FacetSpec.FacetKey.intervals}.
            #
            #     Note: The following fields are mutually exclusive: `interval`, `value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] count
            #   @return [::Integer]
            #     Number of items that have this facet value.
            class FacetValue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Guided search result. The guided search helps user to refine the search
          # results and narrow down to the real needs from a broaded search results.
          # @!attribute [rw] refinement_attributes
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::GuidedSearchResult::RefinementAttribute>]
          #     A list of ranked refinement attributes.
          # @!attribute [rw] follow_up_questions
          #   @return [::Array<::String>]
          #     Suggested follow-up questions.
          class GuidedSearchResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Useful attribute for search result refinements.
            # @!attribute [rw] attribute_key
            #   @return [::String]
            #     Attribute key used to refine the results. For example, `"movie_type"`.
            # @!attribute [rw] attribute_value
            #   @return [::String]
            #     Attribute value used to refine the results. For example, `"drama"`.
            class RefinementAttribute
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Summary of the top N search results specified by the summary spec.
          # @!attribute [rw] summary_text
          #   @return [::String]
          #     The summary content.
          # @!attribute [rw] summary_skipped_reasons
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Summary::SummarySkippedReason>]
          #     Additional summary-skipped reasons. This provides the reason for ignored
          #     cases. If nothing is skipped, this field is not set.
          # @!attribute [rw] safety_attributes
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Summary::SafetyAttributes]
          #     A collection of Safety Attribute categories and their associated
          #     confidence scores.
          # @!attribute [rw] summary_with_metadata
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Summary::SummaryWithMetadata]
          #     Summary with metadata information.
          class Summary
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Safety Attribute categories and their associated confidence scores.
            # @!attribute [rw] categories
            #   @return [::Array<::String>]
            #     The display names of Safety Attribute categories associated with the
            #     generated content. Order matches the Scores.
            # @!attribute [rw] scores
            #   @return [::Array<::Float>]
            #     The confidence scores of the each category, higher
            #     value means higher confidence. Order matches the Categories.
            class SafetyAttributes
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Citation metadata.
            # @!attribute [rw] citations
            #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Summary::Citation>]
            #     Citations for segments.
            class CitationMetadata
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Citation info for a segment.
            # @!attribute [rw] start_index
            #   @return [::Integer]
            #     Index indicates the start of the segment, measured in bytes/unicode.
            # @!attribute [rw] end_index
            #   @return [::Integer]
            #     End of the attributed segment, exclusive.
            # @!attribute [rw] sources
            #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Summary::CitationSource>]
            #     Citation sources for the attributed segment.
            class Citation
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Citation source.
            # @!attribute [rw] reference_index
            #   @return [::Integer]
            #     Document reference index from SummaryWithMetadata.references.
            #     It is 0-indexed and the value will be zero if the reference_index is
            #     not set explicitly.
            class CitationSource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Document reference.
            # @!attribute [rw] title
            #   @return [::String]
            #     Title of the document.
            # @!attribute [rw] document
            #   @return [::String]
            #     Required.
            #     {::Google::Cloud::DiscoveryEngine::V1beta::Document#name Document.name} of
            #     the document. Full resource name of the referenced document, in the
            #     format
            #     `projects/*/locations/*/collections/*/dataStores/*/branches/*/documents/*`.
            # @!attribute [rw] uri
            #   @return [::String]
            #     Cloud Storage or HTTP uri for the document.
            # @!attribute [rw] chunk_contents
            #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Summary::Reference::ChunkContent>]
            #     List of cited chunk contents derived from document content.
            class Reference
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Chunk content.
              # @!attribute [rw] content
              #   @return [::String]
              #     Chunk textual content.
              # @!attribute [rw] page_identifier
              #   @return [::String]
              #     Page identifier.
              class ChunkContent
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # Summary with metadata information.
            # @!attribute [rw] summary
            #   @return [::String]
            #     Summary text with no citation information.
            # @!attribute [rw] citation_metadata
            #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Summary::CitationMetadata]
            #     Citation metadata for given summary.
            # @!attribute [rw] references
            #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::Summary::Reference>]
            #     Document References.
            class SummaryWithMetadata
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # An Enum for summary-skipped reasons.
            module SummarySkippedReason
              # Default value. The summary skipped reason is not specified.
              SUMMARY_SKIPPED_REASON_UNSPECIFIED = 0

              # The adversarial query ignored case.
              #
              # Only used when
              # {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SummarySpec#ignore_adversarial_query SummarySpec.ignore_adversarial_query}
              # is set to `true`.
              ADVERSARIAL_QUERY_IGNORED = 1

              # The non-summary seeking query ignored case.
              #
              # Google skips the summary if the query is chit chat.
              # Only used when
              # {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SummarySpec#ignore_non_summary_seeking_query SummarySpec.ignore_non_summary_seeking_query}
              # is set to `true`.
              NON_SUMMARY_SEEKING_QUERY_IGNORED = 2

              # The out-of-domain query ignored case.
              #
              # Google skips the summary if there are no high-relevance search results.
              # For example, the data store contains facts about company A but the
              # user query is asking questions about company B.
              OUT_OF_DOMAIN_QUERY_IGNORED = 3

              # The potential policy violation case.
              #
              # Google skips the summary if there is a potential policy violation
              # detected. This includes content that may be violent or toxic.
              POTENTIAL_POLICY_VIOLATION = 4

              # The LLM addon not enabled case.
              #
              # Google skips the summary if the LLM addon is not enabled.
              LLM_ADDON_NOT_ENABLED = 5

              # The no relevant content case.
              #
              # Google skips the summary if there is no relevant content in the
              # retrieved search results.
              NO_RELEVANT_CONTENT = 6

              # The jail-breaking query ignored case.
              #
              # For example, "Reply in the tone of a competing company's CEO".
              # Only used when
              # [SearchRequest.ContentSearchSpec.SummarySpec.ignore_jail_breaking_query]
              # is set to `true`.
              JAIL_BREAKING_QUERY_IGNORED = 7

              # The customer policy violation case.
              #
              # Google skips the summary if there is a customer policy violation
              # detected. The policy is defined by the customer.
              CUSTOMER_POLICY_VIOLATION = 8

              # The non-answer seeking query ignored case.
              #
              # Google skips the summary if the query doesn't have clear intent.
              # Only used when
              # [SearchRequest.ContentSearchSpec.SummarySpec.ignore_non_answer_seeking_query]
              # is set to `true`.
              NON_SUMMARY_SEEKING_QUERY_IGNORED_V2 = 9
            end
          end

          # Debug information specifically related to forward geocoding issues arising
          # from Geolocation Search.
          # @!attribute [rw] original_address_query
          #   @return [::String]
          #     The address from which forward geocoding ingestion produced issues.
          # @!attribute [rw] error_message
          #   @return [::String]
          #     The error produced.
          class GeoSearchDebugInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Information describing query expansion including whether expansion has
          # occurred.
          # @!attribute [rw] expanded_query
          #   @return [::Boolean]
          #     Bool describing whether query expansion has occurred.
          # @!attribute [rw] pinned_result_count
          #   @return [::Integer]
          #     Number of pinned results. This field will only be set when expansion
          #     happens and
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::QueryExpansionSpec#pin_unexpanded_results SearchRequest.QueryExpansionSpec.pin_unexpanded_results}
          #     is set to true.
          class QueryExpansionInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Information describing what natural language understanding was
          # done on the input query.
          # @!attribute [rw] extracted_filters
          #   @return [::String]
          #     The filters that were extracted from the input query.
          # @!attribute [rw] rewritten_query
          #   @return [::String]
          #     Rewritten input query minus the extracted filters.
          # @!attribute [rw] structured_extracted_filter
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::NaturalLanguageQueryUnderstandingInfo::StructuredExtractedFilter]
          #     The filters that were extracted from the input query represented in a
          #     structured form.
          class NaturalLanguageQueryUnderstandingInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The filters that were extracted from the input query represented in a
            # structured form.
            # @!attribute [rw] expression
            #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::NaturalLanguageQueryUnderstandingInfo::StructuredExtractedFilter::Expression]
            #     The expression denoting the filter that was extracted from the input
            #     query in a structured form. It can be a simple expression denoting a
            #     single string, numerical or geolocation constraint or a compound
            #     expression which is a combination of multiple expressions connected
            #     using logical (OR and AND) operators.
            class StructuredExtractedFilter
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Constraint expression of a string field.
              # @!attribute [rw] field_name
              #   @return [::String]
              #     Name of the string field as defined in the schema.
              # @!attribute [rw] values
              #   @return [::Array<::String>]
              #     Values of the string field. The record will only be returned if the
              #     field value matches one of the values specified here.
              # @!attribute [rw] query_segment
              #   @return [::String]
              #     Identifies the keywords within the search query that match a filter.
              class StringConstraint
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # Constraint expression of a number field. Example: price < 100.
              # @!attribute [rw] field_name
              #   @return [::String]
              #     Name of the numerical field as defined in the schema.
              # @!attribute [rw] comparison
              #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::NaturalLanguageQueryUnderstandingInfo::StructuredExtractedFilter::NumberConstraint::Comparison]
              #     The comparison operation performed between the field value and the
              #     value specified in the constraint.
              # @!attribute [rw] value
              #   @return [::Float]
              #     The value specified in the numerical constraint.
              # @!attribute [rw] query_segment
              #   @return [::String]
              #     Identifies the keywords within the search query that match a filter.
              class NumberConstraint
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # The comparison operation that was performed.
                module Comparison
                  # Undefined comparison operator.
                  COMPARISON_UNSPECIFIED = 0

                  # Denotes equality `=` operator.
                  EQUALS = 1

                  # Denotes less than or equal to `<=` operator.
                  LESS_THAN_EQUALS = 2

                  # Denotes less than `<` operator.
                  LESS_THAN = 3

                  # Denotes greater than or equal to `>=` operator.
                  GREATER_THAN_EQUALS = 4

                  # Denotes greater than `>` operator.
                  GREATER_THAN = 5
                end
              end

              # Constraint of a geolocation field.
              # Name of the geolocation field as defined in the schema.
              # @!attribute [rw] field_name
              #   @return [::String]
              #     The name of the geolocation field as defined in the schema.
              # @!attribute [rw] address
              #   @return [::String]
              #     The reference address that was inferred from the input query. The
              #     proximity of the reference address to the geolocation field will be
              #     used to filter the results.
              # @!attribute [rw] latitude
              #   @return [::Float]
              #     The latitude of the geolocation inferred from the input query.
              # @!attribute [rw] longitude
              #   @return [::Float]
              #     The longitude of the geolocation inferred from the input query.
              # @!attribute [rw] radius_in_meters
              #   @return [::Float]
              #     The radius in meters around the address. The record is returned if
              #     the location of the geolocation field is within the radius.
              class GeolocationConstraint
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # Logical `And` operator.
              # @!attribute [rw] expressions
              #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::NaturalLanguageQueryUnderstandingInfo::StructuredExtractedFilter::Expression>]
              #     The expressions that were ANDed together.
              class AndExpression
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # Logical `Or` operator.
              # @!attribute [rw] expressions
              #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::NaturalLanguageQueryUnderstandingInfo::StructuredExtractedFilter::Expression>]
              #     The expressions that were ORed together.
              class OrExpression
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # The expression denoting the filter that was extracted from the input
              # query.
              # @!attribute [rw] string_constraint
              #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::NaturalLanguageQueryUnderstandingInfo::StructuredExtractedFilter::StringConstraint]
              #     String constraint expression.
              #
              #     Note: The following fields are mutually exclusive: `string_constraint`, `number_constraint`, `geolocation_constraint`, `and_expr`, `or_expr`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] number_constraint
              #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::NaturalLanguageQueryUnderstandingInfo::StructuredExtractedFilter::NumberConstraint]
              #     Numerical constraint expression.
              #
              #     Note: The following fields are mutually exclusive: `number_constraint`, `string_constraint`, `geolocation_constraint`, `and_expr`, `or_expr`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] geolocation_constraint
              #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::NaturalLanguageQueryUnderstandingInfo::StructuredExtractedFilter::GeolocationConstraint]
              #     Geolocation constraint expression.
              #
              #     Note: The following fields are mutually exclusive: `geolocation_constraint`, `string_constraint`, `number_constraint`, `and_expr`, `or_expr`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] and_expr
              #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::NaturalLanguageQueryUnderstandingInfo::StructuredExtractedFilter::AndExpression]
              #     Logical "And" compound operator connecting multiple expressions.
              #
              #     Note: The following fields are mutually exclusive: `and_expr`, `string_constraint`, `number_constraint`, `geolocation_constraint`, `or_expr`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] or_expr
              #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::NaturalLanguageQueryUnderstandingInfo::StructuredExtractedFilter::OrExpression]
              #     Logical "Or" compound operator connecting multiple expressions.
              #
              #     Note: The following fields are mutually exclusive: `or_expr`, `string_constraint`, `number_constraint`, `geolocation_constraint`, `and_expr`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              class Expression
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end

          # Information about the session.
          # @!attribute [rw] name
          #   @return [::String]
          #     Name of the session.
          #     If the auto-session mode is used (when
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#session SearchRequest.session}
          #     ends with "-"), this field holds the newly generated session name.
          # @!attribute [rw] query_id
          #   @return [::String]
          #     Query ID that corresponds to this search API call.
          #     One session can have multiple turns, each with a unique query ID.
          #
          #     By specifying the session name and this query ID in the Answer API call,
          #     the answer generation happens in the context of the search results from
          #     this search call.
          class SessionInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # OneBoxResult is a holder for all results of specific type that we want
          # to display in UI differently.
          # @!attribute [rw] one_box_type
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::OneBoxResult::OneBoxType]
          #     The type of One Box result.
          # @!attribute [rw] search_results
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SearchResult>]
          #     The search results for this One Box.
          class OneBoxResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of One Box result.
            module OneBoxType
              # Default value. Should not be used.
              ONE_BOX_TYPE_UNSPECIFIED = 0

              # One Box result contains people results.
              PEOPLE = 1

              # One Box result contains organization results.
              ORGANIZATION = 2

              # One Box result contains slack results.
              SLACK = 3

              # One Box result contains Knowledge Graph search responses.
              KNOWLEDGE_GRAPH = 4
            end
          end
        end
      end
    end
  end
end
