# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySetService::Client#get_sample_query_set SampleQuerySetService.GetSampleQuerySet}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet}, such
        #     as
        #     `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}`.
        #
        #     If the caller does not have permission to access the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet},
        #     regardless of whether or not it exists, a PERMISSION_DENIED error is
        #     returned.
        #
        #     If the requested
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet} does
        #     not exist, a NOT_FOUND error is returned.
        class GetSampleQuerySetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySetService::Client#list_sample_query_sets SampleQuerySetService.ListSampleQuerySets}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent location resource name, such as
        #     `projects/{project}/locations/{location}`.
        #
        #     If the caller does not have permission to list
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet}s under
        #     this location, regardless of whether or not this location exists, a
        #     `PERMISSION_DENIED` error is returned.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet}s to
        #     return. If unspecified, defaults to 100. The maximum allowed value is 1000.
        #     Values above 1000 will be coerced to 1000.
        #
        #     If this field is negative, an `INVALID_ARGUMENT` error is returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ListSampleQuerySetsResponse#next_page_token ListSampleQuerySetsResponse.next_page_token},
        #     received from a previous
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySetService::Client#list_sample_query_sets SampleQuerySetService.ListSampleQuerySets}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySetService::Client#list_sample_query_sets SampleQuerySetService.ListSampleQuerySets}
        #     must match the call that provided the page token. Otherwise, an
        #     `INVALID_ARGUMENT` error is returned.
        class ListSampleQuerySetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySetService::Client#list_sample_query_sets SampleQuerySetService.ListSampleQuerySets}
        # method.
        # @!attribute [rw] sample_query_sets
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet>]
        #     The {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet}s.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ListSampleQuerySetsRequest#page_token ListSampleQuerySetsRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListSampleQuerySetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySetService::Client#create_sample_query_set SampleQuerySetService.CreateSampleQuerySet}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name, such as
        #     `projects/{project}/locations/{location}`.
        # @!attribute [rw] sample_query_set
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet]
        #     Required. The
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet} to
        #     create.
        # @!attribute [rw] sample_query_set_id
        #   @return [::String]
        #     Required. The ID to use for the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet}, which
        #     will become the final component of the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet#name SampleQuerySet.name}.
        #
        #     If the caller does not have permission to create the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet},
        #     regardless of whether or not it exists, a `PERMISSION_DENIED` error is
        #     returned.
        #
        #     This field must be unique among all
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet}s with
        #     the same
        #     {::Google::Cloud::DiscoveryEngine::V1beta::CreateSampleQuerySetRequest#parent parent}.
        #     Otherwise, an `ALREADY_EXISTS` error is returned.
        #
        #     This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
        #     standard with a length limit of 63 characters. Otherwise, an
        #     `INVALID_ARGUMENT` error is returned.
        class CreateSampleQuerySetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySetService::Client#update_sample_query_set SampleQuerySetService.UpdateSampleQuerySet}
        # method.
        # @!attribute [rw] sample_query_set
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet]
        #     Required. The sample query set to update.
        #
        #     If the caller does not have permission to update the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet},
        #     regardless of whether or not it exists, a `PERMISSION_DENIED` error is
        #     returned.
        #
        #     If the {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet}
        #     to update does not exist a `NOT_FOUND` error is returned.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Indicates which fields in the provided imported 'sample query set' to
        #     update. If not set, will by default update all fields.
        class UpdateSampleQuerySetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySetService::Client#delete_sample_query_set SampleQuerySetService.DeleteSampleQuerySet}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet}, such
        #     as
        #     `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}`.
        #
        #     If the caller does not have permission to delete the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet},
        #     regardless of whether or not it exists, a `PERMISSION_DENIED` error is
        #     returned.
        #
        #     If the {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet}
        #     to delete does not exist, a `NOT_FOUND` error is returned.
        class DeleteSampleQuerySetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
