# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # A SampleQuerySet is the parent resource of SampleQuery, and contains the
        # configurations shared by all SampleQuery under it.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The full resource name of the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet}, in
        #     the format of
        #     `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}`.
        #
        #     This field must be a UTF-8 encoded string with a length limit of 1024
        #     characters.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The sample query set display name.
        #
        #     This field must be a UTF-8 encoded string with a length limit of 128
        #     characters.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet} was
        #     created at.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuerySet SampleQuerySet}.
        class SampleQuerySet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
