# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Client#get_sample_query SampleQueryService.GetSampleQuery}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, such as
        #     `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
        #
        #     If the caller does not have permission to access the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, regardless
        #     of whether or not it exists, a PERMISSION_DENIED error is returned.
        #
        #     If the requested
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery} does not
        #     exist, a NOT_FOUND error is returned.
        class GetSampleQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Client#list_sample_queries SampleQueryService.ListSampleQueries}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent sample query set resource name, such as
        #     `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
        #
        #     If the caller does not have permission to list
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}s under this
        #     sample query set, regardless of whether or not this sample query set
        #     exists, a `PERMISSION_DENIED` error is returned.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}s to return.
        #     If unspecified, defaults to 100. The maximum allowed value is 1000. Values
        #     above 1000 will be coerced to 1000.
        #
        #     If this field is negative, an `INVALID_ARGUMENT` error is returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ListSampleQueriesResponse#next_page_token ListSampleQueriesResponse.next_page_token},
        #     received from a previous
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Client#list_sample_queries SampleQueryService.ListSampleQueries}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Client#list_sample_queries SampleQueryService.ListSampleQueries}
        #     must match the call that provided the page token. Otherwise, an
        #     `INVALID_ARGUMENT` error is returned.
        class ListSampleQueriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Client#list_sample_queries SampleQueryService.ListSampleQueries}
        # method.
        # @!attribute [rw] sample_queries
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery>]
        #     The {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}s.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ListSampleQueriesRequest#page_token ListSampleQueriesRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListSampleQueriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Client#create_sample_query SampleQueryService.CreateSampleQuery}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name, such as
        #     `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
        # @!attribute [rw] sample_query
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery]
        #     Required. The
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery} to create.
        # @!attribute [rw] sample_query_id
        #   @return [::String]
        #     Required. The ID to use for the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, which will
        #     become the final component of the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery#name SampleQuery.name}.
        #
        #     If the caller does not have permission to create the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, regardless
        #     of whether or not it exists, a `PERMISSION_DENIED` error is returned.
        #
        #     This field must be unique among all
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}s with the
        #     same
        #     {::Google::Cloud::DiscoveryEngine::V1beta::CreateSampleQueryRequest#parent parent}.
        #     Otherwise, an `ALREADY_EXISTS` error is returned.
        #
        #     This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
        #     standard with a length limit of 63 characters. Otherwise, an
        #     `INVALID_ARGUMENT` error is returned.
        class CreateSampleQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Client#update_sample_query SampleQueryService.UpdateSampleQuery}
        # method.
        # @!attribute [rw] sample_query
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery]
        #     Required. The simple query to update.
        #
        #     If the caller does not have permission to update the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, regardless
        #     of whether or not it exists, a `PERMISSION_DENIED` error is returned.
        #
        #     If the {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery} to
        #     update does not exist a `NOT_FOUND` error is returned.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Indicates which fields in the provided imported 'simple query' to update.
        #     If not set, will by default update all fields.
        class UpdateSampleQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Client#delete_sample_query SampleQueryService.DeleteSampleQuery}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, such as
        #     `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
        #
        #     If the caller does not have permission to delete the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, regardless
        #     of whether or not it exists, a `PERMISSION_DENIED` error is returned.
        #
        #     If the {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery} to
        #     delete does not exist, a `NOT_FOUND` error is returned.
        class DeleteSampleQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
