# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Sample Query captures metadata to be used for evaluation.
        # @!attribute [rw] query_entry
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery::QueryEntry]
        #     The query entry.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The full resource name of the sample query, in the format of
        #     `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
        #
        #     This field must be a UTF-8 encoded string with a length limit of 1024
        #     characters.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery} was created
        #     at.
        class SampleQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Query Entry captures metadata to be used for search evaluation.
          # @!attribute [rw] query
          #   @return [::String]
          #     Required. The query.
          # @!attribute [rw] targets
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery::QueryEntry::Target>]
          #     List of targets for the query.
          class QueryEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines the parameters of the query's expected outcome.
            # @!attribute [rw] uri
            #   @return [::String]
            #     Expected uri of the target.
            #
            #     This field must be a UTF-8 encoded string with a length limit of 2048
            #     characters.
            #
            #     Example of valid uris: `https://example.com/abc`,
            #     `gcs://example/example.pdf`.
            # @!attribute [rw] page_numbers
            #   @return [::Array<::Integer>]
            #     Expected page numbers of the target.
            #
            #     Each page number must be non negative.
            # @!attribute [rw] score
            #   @return [::Float]
            #     Relevance score of the target.
            class Target
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
