# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EvaluationService::Client#get_evaluation EvaluationService.GetEvaluation}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Evaluation Evaluation}, such as
        #     `projects/{project}/locations/{location}/evaluations/{evaluation}`.
        #
        #     If the caller does not have permission to access the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Evaluation Evaluation}, regardless of
        #     whether or not it exists, a PERMISSION_DENIED error is returned.
        #
        #     If the requested
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Evaluation Evaluation} does not
        #     exist, a NOT_FOUND error is returned.
        class GetEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EvaluationService::Client#list_evaluations EvaluationService.ListEvaluations}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent location resource name, such as
        #     `projects/{project}/locations/{location}`.
        #
        #     If the caller does not have permission to list
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Evaluation Evaluation}s under this
        #     location, regardless of whether or not this location exists, a
        #     `PERMISSION_DENIED` error is returned.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Evaluation Evaluation}s to return. If
        #     unspecified, defaults to 100. The maximum allowed value is 1000. Values
        #     above 1000 will be coerced to 1000.
        #
        #     If this field is negative, an `INVALID_ARGUMENT` error is returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ListEvaluationsResponse#next_page_token ListEvaluationsResponse.next_page_token},
        #     received from a previous
        #     {::Google::Cloud::DiscoveryEngine::V1beta::EvaluationService::Client#list_evaluations EvaluationService.ListEvaluations}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::DiscoveryEngine::V1beta::EvaluationService::Client#list_evaluations EvaluationService.ListEvaluations}
        #     must match the call that provided the page token. Otherwise, an
        #     `INVALID_ARGUMENT` error is returned.
        class ListEvaluationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EvaluationService::Client#list_evaluations EvaluationService.ListEvaluations}
        # method.
        # @!attribute [rw] evaluations
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::Evaluation>]
        #     The {::Google::Cloud::DiscoveryEngine::V1beta::Evaluation Evaluation}s.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ListEvaluationsRequest#page_token ListEvaluationsRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListEvaluationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EvaluationService::Client#create_evaluation EvaluationService.CreateEvaluation}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name, such as
        #     `projects/{project}/locations/{location}`.
        # @!attribute [rw] evaluation
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Evaluation]
        #     Required. The {::Google::Cloud::DiscoveryEngine::V1beta::Evaluation Evaluation}
        #     to create.
        class CreateEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EvaluationService::Client#create_evaluation EvaluationService.CreateEvaluation}
        # method.
        class CreateEvaluationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EvaluationService::Client#list_evaluation_results EvaluationService.ListEvaluationResults}
        # method.
        # @!attribute [rw] evaluation
        #   @return [::String]
        #     Required. The evaluation resource name, such as
        #     `projects/{project}/locations/{location}/evaluations/{evaluation}`.
        #
        #     If the caller does not have permission to list [EvaluationResult][]
        #     under this evaluation, regardless of whether or not this evaluation
        #     set exists, a `PERMISSION_DENIED` error is returned.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of [EvaluationResult][] to return. If unspecified,
        #     defaults to 100. The maximum allowed value is 1000. Values above 1000 will
        #     be coerced to 1000.
        #
        #     If this field is negative, an `INVALID_ARGUMENT` error is returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ListEvaluationResultsResponse#next_page_token ListEvaluationResultsResponse.next_page_token},
        #     received from a previous
        #     {::Google::Cloud::DiscoveryEngine::V1beta::EvaluationService::Client#list_evaluation_results EvaluationService.ListEvaluationResults}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::DiscoveryEngine::V1beta::EvaluationService::Client#list_evaluation_results EvaluationService.ListEvaluationResults}
        #     must match the call that provided the page token. Otherwise, an
        #     `INVALID_ARGUMENT` error is returned.
        class ListEvaluationResultsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EvaluationService::Client#list_evaluation_results EvaluationService.ListEvaluationResults}
        # method.
        # @!attribute [rw] evaluation_results
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::ListEvaluationResultsResponse::EvaluationResult>]
        #     The
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ListEvaluationResultsResponse::EvaluationResult EvaluationResult}s.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ListEvaluationResultsRequest#page_token ListEvaluationResultsRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListEvaluationResultsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents the results of an evaluation for a single
          # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}.
          # @!attribute [r] sample_query
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery]
          #     Output only. The
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery} that was
          #     evaluated.
          # @!attribute [r] quality_metrics
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::QualityMetrics]
          #     Output only. The metrics produced by the evaluation, for a given
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}.
          class EvaluationResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
