# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Request for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#create_engine EngineService.CreateEngine}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name, such as
        #     `projects/{project}/locations/{location}/collections/{collection}`.
        # @!attribute [rw] engine
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Engine]
        #     Required. The {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine} to
        #     create.
        # @!attribute [rw] engine_id
        #   @return [::String]
        #     Required. The ID to use for the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine}, which will become the
        #     final component of the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine}'s resource name.
        #
        #     This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
        #     standard with a length limit of 63 characters. Otherwise, an
        #     INVALID_ARGUMENT error is returned.
        class CreateEngineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata related to the progress of the
        # {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#create_engine EngineService.CreateEngine}
        # operation. This will be returned by the google.longrunning.Operation.metadata
        # field.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation create time.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation last update time. If the operation is done, this is also the
        #     finish time.
        class CreateEngineMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#delete_engine EngineService.DeleteEngine}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine}, such as
        #     `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
        #
        #     If the caller does not have permission to delete the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine}, regardless of whether
        #     or not it exists, a PERMISSION_DENIED error is returned.
        #
        #     If the {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine} to delete does
        #     not exist, a NOT_FOUND error is returned.
        class DeleteEngineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata related to the progress of the
        # {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#delete_engine EngineService.DeleteEngine}
        # operation. This will be returned by the google.longrunning.Operation.metadata
        # field.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation create time.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation last update time. If the operation is done, this is also the
        #     finish time.
        class DeleteEngineMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#get_engine EngineService.GetEngine}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine}, such as
        #     `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
        class GetEngineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#list_engines EngineService.ListEngines}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name, such as
        #     `projects/{project}/locations/{location}/collections/{collection_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Not supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Not supported.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter by solution type. For example:
        #     solution_type=SOLUTION_TYPE_SEARCH
        class ListEnginesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#list_engines EngineService.ListEngines}
        # method.
        # @!attribute [rw] engines
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::Engine>]
        #     All the customer's {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine}s.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Not supported.
        class ListEnginesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#update_engine EngineService.UpdateEngine}
        # method.
        # @!attribute [rw] engine
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Engine]
        #     Required. The {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine} to
        #     update.
        #
        #     If the caller does not have permission to update the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine}, regardless of whether
        #     or not it exists, a PERMISSION_DENIED error is returned.
        #
        #     If the {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine} to update does
        #     not exist, a NOT_FOUND error is returned.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Indicates which fields in the provided
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine} to update.
        #
        #     If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
        #     is returned.
        class UpdateEngineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for pausing training of an engine.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the engine to pause.
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`
        class PauseEngineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for resuming training of an engine.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the engine to resume.
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`
        class ResumeEngineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to manually start a tuning process now (instead of waiting for
        # the periodically scheduled tuning to happen).
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the engine to tune.
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`
        class TuneEngineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata associated with a tune operation.
        # @!attribute [rw] engine
        #   @return [::String]
        #     Required. The resource name of the engine that this tune applies to.
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`
        class TuneEngineMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response associated with a tune operation.
        class TuneEngineResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
