# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Metadata that describes the training and serving parameters of an
        # {::Google::Cloud::DiscoveryEngine::V1beta::Engine Engine}.
        # @!attribute [rw] chat_engine_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Engine::ChatEngineConfig]
        #     Configurations for the Chat Engine. Only applicable if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Engine#solution_type solution_type}
        #     is
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_CHAT SOLUTION_TYPE_CHAT}.
        #
        #     Note: The following fields are mutually exclusive: `chat_engine_config`, `search_engine_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] search_engine_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Engine::SearchEngineConfig]
        #     Configurations for the Search Engine. Only applicable if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Engine#solution_type solution_type}
        #     is
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_SEARCH SOLUTION_TYPE_SEARCH}.
        #
        #     Note: The following fields are mutually exclusive: `search_engine_config`, `chat_engine_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] chat_engine_metadata
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Engine::ChatEngineMetadata]
        #     Output only. Additional information of the Chat Engine. Only applicable
        #     if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Engine#solution_type solution_type}
        #     is
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_CHAT SOLUTION_TYPE_CHAT}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The fully qualified resource name of the engine.
        #
        #     This field must be a UTF-8 encoded string with a length limit of 1024
        #     characters.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
        #     engine should be 1-63 characters, and valid characters are
        #     /[a-z0-9][a-z0-9-_]*/. Otherwise, an INVALID_ARGUMENT error is returned.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the engine. Should be human readable. UTF-8
        #     encoded string with limit of 1024 characters.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp the Recommendation Engine was created at.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp the Recommendation Engine was last updated.
        # @!attribute [rw] data_store_ids
        #   @return [::Array<::String>]
        #     The data stores associated with this engine.
        #
        #     For
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_SEARCH SOLUTION_TYPE_SEARCH}
        #     and
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_RECOMMENDATION SOLUTION_TYPE_RECOMMENDATION}
        #     type of engines, they can only associate with at most one data store.
        #
        #     If
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Engine#solution_type solution_type}
        #     is
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_CHAT SOLUTION_TYPE_CHAT},
        #     multiple {::Google::Cloud::DiscoveryEngine::V1beta::DataStore DataStore}s in the
        #     same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
        #     associated here.
        #
        #     Note that when used in
        #     {::Google::Cloud::DiscoveryEngine::V1beta::CreateEngineRequest CreateEngineRequest},
        #     one DataStore id must be provided as the system will use it for necessary
        #     initializations.
        # @!attribute [rw] solution_type
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SolutionType]
        #     Required. The solutions of the engine.
        # @!attribute [rw] industry_vertical
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::IndustryVertical]
        #     The industry vertical that the engine registers.
        #     The restriction of the Engine industry vertical is based on
        #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore DataStore}: If unspecified,
        #     default to `GENERIC`. Vertical on Engine has to match vertical of the
        #     DataStore linked to the engine.
        # @!attribute [rw] common_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Engine::CommonConfig]
        #     Common config spec that specifies the metadata of the engine.
        # @!attribute [rw] disable_analytics
        #   @return [::Boolean]
        #     Optional. Whether to disable analytics for searches performed on this
        #     engine.
        class Engine
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configurations for a Search Engine.
          # @!attribute [rw] search_tier
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchTier]
          #     The search feature tier of this engine.
          #
          #     Different tiers might have different
          #     pricing. To learn more, check the pricing documentation.
          #
          #     Defaults to
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchTier::SEARCH_TIER_STANDARD SearchTier.SEARCH_TIER_STANDARD}
          #     if not specified.
          # @!attribute [rw] search_add_ons
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchAddOn>]
          #     The add-on that this search engine enables.
          class SearchEngineConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configurations for a Chat Engine.
          # @!attribute [rw] agent_creation_config
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Engine::ChatEngineConfig::AgentCreationConfig]
          #     The configurationt generate the Dialogflow agent that is associated to
          #     this Engine.
          #
          #     Note that these configurations are one-time consumed by
          #     and passed to Dialogflow service. It means they cannot be retrieved using
          #     {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#get_engine EngineService.GetEngine}
          #     or
          #     {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#list_engines EngineService.ListEngines}
          #     API after engine creation.
          # @!attribute [rw] dialogflow_agent_to_link
          #   @return [::String]
          #     The resource name of an exist Dialogflow agent to link to this Chat
          #     Engine. Customers can either provide `agent_creation_config` to create
          #     agent or provide an agent name that links the agent with the Chat engine.
          #
          #     Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
          #     ID>`.
          #
          #     Note that the `dialogflow_agent_to_link` are one-time consumed by and
          #     passed to Dialogflow service. It means they cannot be retrieved using
          #     {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#get_engine EngineService.GetEngine}
          #     or
          #     {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#list_engines EngineService.ListEngines}
          #     API after engine creation. Use
          #     {::Google::Cloud::DiscoveryEngine::V1beta::Engine::ChatEngineMetadata#dialogflow_agent ChatEngineMetadata.dialogflow_agent}
          #     for actual agent association after Engine is created.
          class ChatEngineConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configurations for generating a Dialogflow agent.
            #
            # Note that these configurations are one-time consumed by
            # and passed to Dialogflow service. It means they cannot be retrieved using
            # {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#get_engine EngineService.GetEngine}
            # or
            # {::Google::Cloud::DiscoveryEngine::V1beta::EngineService::Client#list_engines EngineService.ListEngines}
            # API after engine creation.
            # @!attribute [rw] business
            #   @return [::String]
            #     Name of the company, organization or other entity that the agent
            #     represents. Used for knowledge connector LLM prompt and for knowledge
            #     search.
            # @!attribute [rw] default_language_code
            #   @return [::String]
            #     Required. The default language of the agent as a language tag.
            #     See [Language
            #     Support](https://cloud.google.com/dialogflow/docs/reference/language)
            #     for a list of the currently supported language codes.
            # @!attribute [rw] time_zone
            #   @return [::String]
            #     Required. The time zone of the agent from the [time zone
            #     database](https://www.iana.org/time-zones), e.g., America/New_York,
            #     Europe/Paris.
            # @!attribute [rw] location
            #   @return [::String]
            #     Agent location for Agent creation, supported values: global/us/eu.
            #     If not provided, us Engine will create Agent using us-central-1 by
            #     default; eu Engine will create Agent using eu-west-1 by default.
            class AgentCreationConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Common configurations for an Engine.
          # @!attribute [rw] company_name
          #   @return [::String]
          #     The name of the company, business or entity that is associated with the
          #     engine. Setting this may help improve LLM related features.
          class CommonConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Additional information of a Chat Engine.
          # Fields in this message are output only.
          # @!attribute [rw] dialogflow_agent
          #   @return [::String]
          #     The resource name of a Dialogflow agent, that this Chat Engine refers
          #     to.
          #
          #     Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
          #     ID>`.
          class ChatEngineMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
