# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # DataStore captures global settings and configs at the DataStore level.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The full resource name of the data store.
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
        #
        #     This field must be a UTF-8 encoded string with a length limit of 1024
        #     characters.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The data store display name.
        #
        #     This field must be a UTF-8 encoded string with a length limit of 128
        #     characters. Otherwise, an INVALID_ARGUMENT error is returned.
        # @!attribute [rw] industry_vertical
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::IndustryVertical]
        #     Immutable. The industry vertical that the data store registers.
        # @!attribute [rw] solution_types
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SolutionType>]
        #     The solutions that the data store enrolls. Available solutions for each
        #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore#industry_vertical industry_vertical}:
        #
        #     * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
        #     * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
        #       solutions cannot be enrolled.
        # @!attribute [r] default_schema_id
        #   @return [::String]
        #     Output only. The id of the default
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Schema Schema} asscociated to this
        #     data store.
        # @!attribute [rw] content_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::DataStore::ContentConfig]
        #     Immutable. The content config of the data store. If this field is unset,
        #     the server behavior defaults to
        #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore::ContentConfig::NO_CONTENT ContentConfig.NO_CONTENT}.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore DataStore} was created at.
        # @!attribute [rw] language_info
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::LanguageInfo]
        #     Language info for DataStore.
        # @!attribute [rw] natural_language_query_understanding_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::NaturalLanguageQueryUnderstandingConfig]
        #     Optional. Configuration for Natural Language Query Understanding.
        # @!attribute [r] billing_estimation
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::DataStore::BillingEstimation]
        #     Output only. Data size estimation for billing.
        # @!attribute [rw] workspace_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::WorkspaceConfig]
        #     Config to store data store type configuration for workspace data. This
        #     must be set when
        #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore#content_config DataStore.content_config}
        #     is set as
        #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore::ContentConfig::GOOGLE_WORKSPACE DataStore.ContentConfig.GOOGLE_WORKSPACE}.
        # @!attribute [rw] document_processing_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::DocumentProcessingConfig]
        #     Configuration for Document understanding and enrichment.
        # @!attribute [rw] starting_schema
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Schema]
        #     The start schema to use for this
        #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore DataStore} when
        #     provisioning it. If unset, a default vertical specialized schema will be
        #     used.
        #
        #     This field is only used by [CreateDataStore][] API, and will be ignored if
        #     used in other APIs. This field will be omitted from all API responses
        #     including [CreateDataStore][] API. To retrieve a schema of a
        #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore DataStore}, use
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SchemaService::Client#get_schema SchemaService.GetSchema}
        #     API instead.
        #
        #     The provided schema will be validated against certain rules on schema.
        #     Learn more from [this
        #     doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
        # @!attribute [rw] serving_config_data_store
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::DataStore::ServingConfigDataStore]
        #     Optional. Stores serving config at DataStore level.
        class DataStore
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Estimation of data size per data store.
          # @!attribute [rw] structured_data_size
          #   @return [::Integer]
          #     Data size for structured data in terms of bytes.
          # @!attribute [rw] unstructured_data_size
          #   @return [::Integer]
          #     Data size for unstructured data in terms of bytes.
          # @!attribute [rw] website_data_size
          #   @return [::Integer]
          #     Data size for websites in terms of bytes.
          # @!attribute [rw] structured_data_update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Last updated timestamp for structured data.
          # @!attribute [rw] unstructured_data_update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Last updated timestamp for unstructured data.
          # @!attribute [rw] website_data_update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Last updated timestamp for websites.
          class BillingEstimation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Stores information regarding the serving configurations at DataStore level.
          # @!attribute [rw] disabled_for_serving
          #   @return [::Boolean]
          #     If set true, the DataStore will not be available for serving search
          #     requests.
          class ServingConfigDataStore
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Content config of the data store.
          module ContentConfig
            # Default value.
            CONTENT_CONFIG_UNSPECIFIED = 0

            # Only contains documents without any
            # {::Google::Cloud::DiscoveryEngine::V1beta::Document#content Document.content}.
            NO_CONTENT = 1

            # Only contains documents with
            # {::Google::Cloud::DiscoveryEngine::V1beta::Document#content Document.content}.
            CONTENT_REQUIRED = 2

            # The data store is used for public website search.
            PUBLIC_WEBSITE = 3

            # The data store is used for workspace search. Details of workspace
            # data store are specified in the
            # {::Google::Cloud::DiscoveryEngine::V1beta::WorkspaceConfig WorkspaceConfig}.
            GOOGLE_WORKSPACE = 4
          end
        end

        # Language info for DataStore.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     The language code for the DataStore.
        # @!attribute [r] normalized_language_code
        #   @return [::String]
        #     Output only. This is the normalized form of language_code.
        #     E.g.: language_code of `en-GB`, `en_GB`, `en-UK` or `en-gb`
        #     will have normalized_language_code of `en-GB`.
        # @!attribute [r] language
        #   @return [::String]
        #     Output only. Language part of normalized_language_code.
        #     E.g.: `en-US` -> `en`, `zh-Hans-HK` -> `zh`, `en` -> `en`.
        # @!attribute [r] region
        #   @return [::String]
        #     Output only. Region part of normalized_language_code, if present.
        #     E.g.: `en-US` -> `US`, `zh-Hans-HK` -> `HK`, `en` -> ``.
        class LanguageInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for Natural Language Query Understanding.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::NaturalLanguageQueryUnderstandingConfig::Mode]
        #     Mode of Natural Language Query Understanding. If this field is unset, the
        #     behavior defaults to
        #     {::Google::Cloud::DiscoveryEngine::V1beta::NaturalLanguageQueryUnderstandingConfig::Mode::DISABLED NaturalLanguageQueryUnderstandingConfig.Mode.DISABLED}.
        class NaturalLanguageQueryUnderstandingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Mode of Natural Language Query Understanding. When the
          # NaturalLanguageQueryUnderstandingConfig.Mode is ENABLED, the natural
          # language understanding capabilities will be enabled for a search request if
          # the NaturalLanguageQueryUnderstandingSpec.FilterExtractionCondition in the
          # SearchRequest is ENABLED.
          module Mode
            # Default value.
            MODE_UNSPECIFIED = 0

            # Natural Language Query Understanding is disabled.
            DISABLED = 1

            # Natural Language Query Understanding is enabled.
            ENABLED = 2
          end
        end

        # Config to store data store type configuration for workspace data
        # @!attribute [rw] type
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::WorkspaceConfig::Type]
        #     The Google Workspace data source.
        # @!attribute [rw] dasher_customer_id
        #   @return [::String]
        #     Obfuscated Dasher customer ID.
        # @!attribute [rw] super_admin_service_account
        #   @return [::String]
        #     Optional. The super admin service account for the workspace that will be
        #     used for access token generation. For now we only use it for Native Google
        #     Drive connector data ingestion.
        # @!attribute [rw] super_admin_email_address
        #   @return [::String]
        #     Optional. The super admin email address for the workspace that will be used
        #     for access token generation. For now we only use it for Native Google Drive
        #     connector data ingestion.
        class WorkspaceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the type of Workspace App supported by this DataStore
          module Type
            # Defaults to an unspecified Workspace type.
            TYPE_UNSPECIFIED = 0

            # Workspace Data Store contains Drive data
            GOOGLE_DRIVE = 1

            # Workspace Data Store contains Mail data
            GOOGLE_MAIL = 2

            # Workspace Data Store contains Sites data
            GOOGLE_SITES = 3

            # Workspace Data Store contains Calendar data
            GOOGLE_CALENDAR = 4

            # Workspace Data Store contains Chat data
            GOOGLE_CHAT = 5

            # Workspace Data Store contains Groups data
            GOOGLE_GROUPS = 6

            # Workspace Data Store contains Keep data
            GOOGLE_KEEP = 7
          end
        end
      end
    end
  end
end
