# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Metadata that describes a custom tuned model.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The fully qualified resource name of the model.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/customTuningModels/{custom_tuning_model}`.
        #
        #     Model must be an alpha-numerical string with limit of 40 characters.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the model.
        # @!attribute [rw] model_version
        #   @return [::Integer]
        #     The version of the model.
        # @!attribute [rw] model_state
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::CustomTuningModel::ModelState]
        #     The state that the model is in (e.g.`TRAINING` or `TRAINING_FAILED`).
        # @!attribute [rw] create_time
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Protobuf::Timestamp]
        #     Deprecated: Timestamp the Model was created at.
        # @!attribute [rw] training_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp the model training was initiated.
        # @!attribute [rw] metrics
        #   @return [::Google::Protobuf::Map{::String => ::Float}]
        #     The metrics of the trained model.
        # @!attribute [rw] error_message
        #   @return [::String]
        #     Currently this is only populated if the model state is
        #     `INPUT_VALIDATION_FAILED`.
        class CustomTuningModel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Float]
          class MetricsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state of the model.
          module ModelState
            # Default value.
            MODEL_STATE_UNSPECIFIED = 0

            # The model is in a paused training state.
            TRAINING_PAUSED = 1

            # The model is currently training.
            TRAINING = 2

            # The model has successfully completed training.
            TRAINING_COMPLETE = 3

            # The model is ready for serving.
            READY_FOR_SERVING = 4

            # The model training failed.
            TRAINING_FAILED = 5

            # The model training finished successfully but metrics did not improve.
            NO_IMPROVEMENT = 6

            # Input data validation failed. Model training didn't start.
            INPUT_VALIDATION_FAILED = 7
          end
        end
      end
    end
  end
end
