# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::ConversationalSearchService::Client#converse_conversation ConversationalSearchService.ConverseConversation}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Conversation to get. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
        #     Use
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store_id}/conversations/-`
        #     to activate auto session mode, which automatically creates a new
        #     conversation inside a ConverseConversation session.
        # @!attribute [rw] query
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::TextInput]
        #     Required. Current user input.
        # @!attribute [rw] serving_config
        #   @return [::String]
        #     The resource name of the Serving Config to use. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store_id}/servingConfigs/{serving_config_id}`
        #     If this is not set, the default serving config will be used.
        # @!attribute [rw] conversation
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Conversation]
        #     The conversation to be used by auto session only. The name field will be
        #     ignored as we automatically assign new name for the conversation in auto
        #     session.
        # @!attribute [rw] safe_search
        #   @return [::Boolean]
        #     Whether to turn on safe search.
        # @!attribute [rw] user_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The user labels applied to a resource must meet the following requirements:
        #
        #     * Each resource can have multiple labels, up to a maximum of 64.
        #     * Each label must be a key-value pair.
        #     * Keys have a minimum length of 1 character and a maximum length of 63
        #       characters and cannot be empty. Values can be empty and have a maximum
        #       length of 63 characters.
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #       underscores, and dashes. All characters must use UTF-8 encoding, and
        #       international characters are allowed.
        #     * The key portion of a label must be unique. However, you can use the same
        #       key with multiple resources.
        #     * Keys must start with a lowercase letter or international character.
        #
        #     See [Google Cloud
        #     Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
        #     for more details.
        # @!attribute [rw] summary_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SummarySpec]
        #     A specification for configuring the summary returned in the response.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter syntax consists of an expression language for constructing a
        #     predicate from one or more fields of the documents being filtered. Filter
        #     expression is case-sensitive. This will be used to filter search results
        #     which may affect the summary response.
        #
        #     If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
        #
        #     Filtering in Vertex AI Search is done by mapping the LHS filter key to a
        #     key property defined in the Vertex AI Search backend -- this mapping is
        #     defined by the customer in their schema. For example a media customer might
        #     have a field 'name' in their schema. In this case the filter would look
        #     like this: filter --> name:'ANY("king kong")'
        #
        #     For more information about filtering including syntax and filter
        #     operators, see
        #     [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
        # @!attribute [rw] boost_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::BoostSpec]
        #     Boost specification to boost certain documents in search results which may
        #     affect the converse response. For more information on boosting, see
        #     [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
        class ConverseConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class UserLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::ConversationalSearchService::Client#converse_conversation ConversationalSearchService.ConverseConversation}
        # method.
        # @!attribute [rw] reply
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Reply]
        #     Answer to the current query.
        # @!attribute [rw] conversation
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Conversation]
        #     Updated conversation including the answer.
        # @!attribute [rw] related_questions
        #   @return [::Array<::String>]
        #     Suggested related questions.
        # @!attribute [rw] search_results
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SearchResult>]
        #     Search Results.
        class ConverseConversationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for CreateConversation method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Full resource name of parent data store. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store_id}`
        # @!attribute [rw] conversation
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Conversation]
        #     Required. The conversation to create.
        class CreateConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for UpdateConversation method.
        # @!attribute [rw] conversation
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Conversation]
        #     Required. The Conversation to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Indicates which fields in the provided
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Conversation Conversation} to update.
        #     The following are NOT supported:
        #
        #     * {::Google::Cloud::DiscoveryEngine::V1beta::Conversation#name Conversation.name}
        #
        #     If not set or empty, all supported fields are updated.
        class UpdateConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DeleteConversation method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Conversation to delete. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`
        class DeleteConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetConversation method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Conversation to get. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`
        class GetConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ListConversations method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The data store resource name. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of results to return. If unspecified, defaults
        #     to 50. Max allowed value is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListConversations` call.
        #     Provide this to retrieve the subsequent page.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter to apply on the list results. The supported features are:
        #     user_pseudo_id, state.
        #
        #     Example:
        #     "user_pseudo_id = some_id"
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        #     Supported fields:
        #       * `update_time`
        #       * `create_time`
        #       * `conversation_name`
        #
        #     Example:
        #     "update_time desc"
        #     "create_time"
        class ListConversationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListConversations method.
        # @!attribute [rw] conversations
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::Conversation>]
        #     All the Conversations for a given data store.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pagination token, if not returned indicates the last page.
        class ListConversationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::ConversationalSearchService::Client#answer_query ConversationalSearchService.AnswerQuery}
        # method.
        # @!attribute [rw] serving_config
        #   @return [::String]
        #     Required. The resource name of the Search serving config, such as
        #     `projects/*/locations/global/collections/default_collection/engines/*/servingConfigs/default_serving_config`,
        #     or
        #     `projects/*/locations/global/collections/default_collection/dataStores/*/servingConfigs/default_serving_config`.
        #     This field is used to identify the serving configuration name, set
        #     of models used to make the search.
        # @!attribute [rw] query
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Query]
        #     Required. Current user query.
        # @!attribute [rw] session
        #   @return [::String]
        #     The session resource name. Not required.
        #
        #     When session field is not set, the API is in sessionless mode.
        #
        #     We support auto session mode: users can use the wildcard symbol `-` as
        #     session ID.  A new ID will be automatically generated and assigned.
        # @!attribute [rw] safety_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::SafetySpec]
        #     Model specification.
        # @!attribute [rw] related_questions_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::RelatedQuestionsSpec]
        #     Related questions specification.
        # @!attribute [rw] grounding_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::GroundingSpec]
        #     Optional. Grounding specification.
        # @!attribute [rw] answer_generation_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::AnswerGenerationSpec]
        #     Answer generation specification.
        # @!attribute [rw] search_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::SearchSpec]
        #     Search specification.
        # @!attribute [rw] query_understanding_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::QueryUnderstandingSpec]
        #     Query understanding specification.
        # @!attribute [rw] asynchronous_mode
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Deprecated: This field is deprecated. Streaming Answer API will be
        #     supported.
        #
        #     Asynchronous mode control.
        #
        #     If enabled, the response will be returned with answer/session resource
        #     name without final answer. The API users need to do the polling to get
        #     the latest status of answer/session by calling
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ConversationalSearchService::Client#get_answer ConversationalSearchService.GetAnswer}
        #     or
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ConversationalSearchService::Client#get_session ConversationalSearchService.GetSession}
        #     method.
        # @!attribute [rw] user_pseudo_id
        #   @return [::String]
        #     A unique identifier for tracking visitors. For example, this could be
        #     implemented with an HTTP cookie, which should be able to uniquely identify
        #     a visitor on a single device. This unique identifier should not change if
        #     the visitor logs in or out of the website.
        #
        #     This field should NOT have a fixed value such as `unknown_visitor`.
        #
        #     The field must be a UTF-8 encoded string with a length limit of 128
        #     characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
        # @!attribute [rw] user_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The user labels applied to a resource must meet the following requirements:
        #
        #     * Each resource can have multiple labels, up to a maximum of 64.
        #     * Each label must be a key-value pair.
        #     * Keys have a minimum length of 1 character and a maximum length of 63
        #       characters and cannot be empty. Values can be empty and have a maximum
        #       length of 63 characters.
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #       underscores, and dashes. All characters must use UTF-8 encoding, and
        #       international characters are allowed.
        #     * The key portion of a label must be unique. However, you can use the same
        #       key with multiple resources.
        #     * Keys must start with a lowercase letter or international character.
        #
        #     See [Google Cloud
        #     Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
        #     for more details.
        class AnswerQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Safety specification.
          # @!attribute [rw] enable
          #   @return [::Boolean]
          #     Enable the safety filtering on the answer response. It is false by
          #     default.
          class SafetySpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Related questions specification.
          # @!attribute [rw] enable
          #   @return [::Boolean]
          #     Enable related questions feature if true.
          class RelatedQuestionsSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Grounding specification.
          # @!attribute [rw] include_grounding_supports
          #   @return [::Boolean]
          #     Optional. Specifies whether to include grounding_supports in the answer.
          #     The default value is `false`.
          #
          #     When this field is set to `true`, returned answer will have
          #     `grounding_score` and will contain GroundingSupports for each claim.
          # @!attribute [rw] filtering_level
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::GroundingSpec::FilteringLevel]
          #     Optional. Specifies whether to enable the filtering based on grounding
          #     score and at what level.
          class GroundingSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Level to filter based on answer grounding.
            module FilteringLevel
              # Default is no filter
              FILTERING_LEVEL_UNSPECIFIED = 0

              # Filter answers based on a low threshold.
              FILTERING_LEVEL_LOW = 1

              # Filter answers based on a high threshold.
              FILTERING_LEVEL_HIGH = 2
            end
          end

          # Answer generation specification.
          # @!attribute [rw] model_spec
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::AnswerGenerationSpec::ModelSpec]
          #     Answer generation model specification.
          # @!attribute [rw] prompt_spec
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::AnswerGenerationSpec::PromptSpec]
          #     Answer generation prompt specification.
          # @!attribute [rw] include_citations
          #   @return [::Boolean]
          #     Specifies whether to include citation metadata in the answer. The default
          #     value is `false`.
          # @!attribute [rw] answer_language_code
          #   @return [::String]
          #     Language code for Answer. Use language tags defined by
          #     [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
          #     Note: This is an experimental feature.
          # @!attribute [rw] ignore_adversarial_query
          #   @return [::Boolean]
          #     Specifies whether to filter out adversarial queries. The default value
          #     is `false`.
          #
          #     Google employs search-query classification to detect adversarial
          #     queries. No answer is returned if the search query is classified as an
          #     adversarial query. For example, a user might ask a question regarding
          #     negative comments about the company or submit a query designed to
          #     generate unsafe, policy-violating output. If this field is set to
          #     `true`, we skip generating answers for adversarial queries and return
          #     fallback messages instead.
          # @!attribute [rw] ignore_non_answer_seeking_query
          #   @return [::Boolean]
          #     Specifies whether to filter out queries that are not answer-seeking.
          #     The default value is `false`.
          #
          #     Google employs search-query classification to detect answer-seeking
          #     queries. No answer is returned if the search query is classified as a
          #     non-answer seeking query. If this field is set to `true`, we skip
          #     generating answers for non-answer seeking queries and return
          #     fallback messages instead.
          # @!attribute [rw] ignore_low_relevant_content
          #   @return [::Boolean]
          #     Specifies whether to filter out queries that have low relevance.
          #
          #     If this field is set to `false`, all search results are used regardless
          #     of relevance to generate answers. If set to `true` or unset, the behavior
          #     will be determined automatically by the service.
          # @!attribute [rw] ignore_jail_breaking_query
          #   @return [::Boolean]
          #     Optional. Specifies whether to filter out jail-breaking queries. The
          #     default value is `false`.
          #
          #     Google employs search-query classification to detect jail-breaking
          #     queries. No summary is returned if the search query is classified as a
          #     jail-breaking query. A user might add instructions to the query to
          #     change the tone, style, language, content of the answer, or ask the
          #     model to act as a different entity, e.g. "Reply in the tone of a
          #     competing company's CEO". If this field is set to `true`, we skip
          #     generating summaries for jail-breaking queries and return fallback
          #     messages instead.
          class AnswerGenerationSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Answer Generation Model specification.
            # @!attribute [rw] model_version
            #   @return [::String]
            #     Model version. If not set, it will use the default stable model.
            #     Allowed values are: stable, preview.
            class ModelSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Answer generation prompt specification.
            # @!attribute [rw] preamble
            #   @return [::String]
            #     Customized preamble.
            class PromptSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Search specification.
          # @!attribute [rw] search_params
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::SearchSpec::SearchParams]
          #     Search parameters.
          #
          #     Note: The following fields are mutually exclusive: `search_params`, `search_result_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] search_result_list
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::SearchSpec::SearchResultList]
          #     Search result list.
          #
          #     Note: The following fields are mutually exclusive: `search_result_list`, `search_params`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class SearchSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Search parameters.
            # @!attribute [rw] max_return_results
            #   @return [::Integer]
            #     Number of search results to return.
            #     The default value is 10.
            # @!attribute [rw] filter
            #   @return [::String]
            #     The filter syntax consists of an expression language for constructing
            #     a predicate from one or more fields of the documents being filtered.
            #     Filter expression is case-sensitive. This will be used to filter
            #     search results which may affect the Answer response.
            #
            #     If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
            #
            #     Filtering in Vertex AI Search is done by mapping the LHS filter key
            #     to a key property defined in the Vertex AI Search backend -- this
            #     mapping is defined by the customer in their schema. For example a
            #     media customers might have a field 'name' in their schema. In this
            #     case the filter would look like this: filter --> name:'ANY("king
            #     kong")'
            #
            #     For more information about filtering including syntax and filter
            #     operators, see
            #     [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
            # @!attribute [rw] boost_spec
            #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::BoostSpec]
            #     Boost specification to boost certain documents in search results which
            #     may affect the answer query response. For more information on boosting,
            #     see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
            # @!attribute [rw] order_by
            #   @return [::String]
            #     The order in which documents are returned. Documents can be ordered
            #     by a field in an
            #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document} object. Leave
            #     it unset if ordered by relevance. `order_by` expression is
            #     case-sensitive. For more information on ordering, see
            #     [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
            #
            #     If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
            # @!attribute [rw] search_result_mode
            #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::SearchResultMode]
            #     Specifies the search result mode. If unspecified, the
            #     search result mode defaults to `DOCUMENTS`.
            #     See [parse and chunk
            #     documents](https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
            # @!attribute [rw] data_store_specs
            #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::DataStoreSpec>]
            #     Specs defining dataStores to filter on in a search call and
            #     configurations for those dataStores. This is only considered for
            #     engines with multiple dataStores use case. For single dataStore within
            #     an engine, they should use the specs at the top level.
            # @!attribute [rw] natural_language_query_understanding_spec
            #   @return [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::NaturalLanguageQueryUnderstandingSpec]
            #     Optional. Specification to enable natural language understanding
            #     capabilities for search requests.
            class SearchParams
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Search result list.
            # @!attribute [rw] search_results
            #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::SearchSpec::SearchResultList::SearchResult>]
            #     Search results.
            class SearchResultList
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Search result.
              # @!attribute [rw] unstructured_document_info
              #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::SearchSpec::SearchResultList::SearchResult::UnstructuredDocumentInfo]
              #     Unstructured document information.
              #
              #     Note: The following fields are mutually exclusive: `unstructured_document_info`, `chunk_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] chunk_info
              #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::SearchSpec::SearchResultList::SearchResult::ChunkInfo]
              #     Chunk information.
              #
              #     Note: The following fields are mutually exclusive: `chunk_info`, `unstructured_document_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              class SearchResult
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # Unstructured document information.
                # @!attribute [rw] document
                #   @return [::String]
                #     Document resource name.
                # @!attribute [rw] uri
                #   @return [::String]
                #     URI for the document.
                # @!attribute [rw] title
                #   @return [::String]
                #     Title.
                # @!attribute [rw] document_contexts
                #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::SearchSpec::SearchResultList::SearchResult::UnstructuredDocumentInfo::DocumentContext>]
                #     List of document contexts. The content will be used for Answer
                #     Generation. This is supposed to be the main content of the document
                #     that can be long and comprehensive.
                # @!attribute [rw] extractive_segments
                #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::SearchSpec::SearchResultList::SearchResult::UnstructuredDocumentInfo::ExtractiveSegment>]
                #     List of extractive segments.
                # @!attribute [rw] extractive_answers
                #   @deprecated This field is deprecated and may be removed in the next major version update.
                #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::SearchSpec::SearchResultList::SearchResult::UnstructuredDocumentInfo::ExtractiveAnswer>]
                #     Deprecated: This field is deprecated and will have no effect on
                #     the Answer generation.
                #     Please use document_contexts and extractive_segments fields.
                #     List of extractive answers.
                class UnstructuredDocumentInfo
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods

                  # Document context.
                  # @!attribute [rw] page_identifier
                  #   @return [::String]
                  #     Page identifier.
                  # @!attribute [rw] content
                  #   @return [::String]
                  #     Document content to be used for answer generation.
                  class DocumentContext
                    include ::Google::Protobuf::MessageExts
                    extend ::Google::Protobuf::MessageExts::ClassMethods
                  end

                  # Extractive segment.
                  # [Guide](https://cloud.google.com/generative-ai-app-builder/docs/snippets#extractive-segments)
                  # Answer generation will only use it if document_contexts is empty.
                  # This is supposed to be shorter snippets.
                  # @!attribute [rw] page_identifier
                  #   @return [::String]
                  #     Page identifier.
                  # @!attribute [rw] content
                  #   @return [::String]
                  #     Extractive segment content.
                  class ExtractiveSegment
                    include ::Google::Protobuf::MessageExts
                    extend ::Google::Protobuf::MessageExts::ClassMethods
                  end

                  # Extractive answer.
                  # [Guide](https://cloud.google.com/generative-ai-app-builder/docs/snippets#get-answers)
                  # @!attribute [rw] page_identifier
                  #   @return [::String]
                  #     Page identifier.
                  # @!attribute [rw] content
                  #   @return [::String]
                  #     Extractive answer content.
                  class ExtractiveAnswer
                    include ::Google::Protobuf::MessageExts
                    extend ::Google::Protobuf::MessageExts::ClassMethods
                  end
                end

                # Chunk information.
                # @!attribute [rw] chunk
                #   @return [::String]
                #     Chunk resource name.
                # @!attribute [rw] content
                #   @return [::String]
                #     Chunk textual content.
                # @!attribute [rw] document_metadata
                #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::SearchSpec::SearchResultList::SearchResult::ChunkInfo::DocumentMetadata]
                #     Metadata of the document from the current chunk.
                class ChunkInfo
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods

                  # Document metadata contains the information of the document of the
                  # current chunk.
                  # @!attribute [rw] uri
                  #   @return [::String]
                  #     Uri of the document.
                  # @!attribute [rw] title
                  #   @return [::String]
                  #     Title of the document.
                  class DocumentMetadata
                    include ::Google::Protobuf::MessageExts
                    extend ::Google::Protobuf::MessageExts::ClassMethods
                  end
                end
              end
            end
          end

          # Query understanding specification.
          # @!attribute [rw] query_classification_spec
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::QueryUnderstandingSpec::QueryClassificationSpec]
          #     Query classification specification.
          # @!attribute [rw] query_rephraser_spec
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::QueryUnderstandingSpec::QueryRephraserSpec]
          #     Query rephraser specification.
          class QueryUnderstandingSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Query classification specification.
            # @!attribute [rw] types
            #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::QueryUnderstandingSpec::QueryClassificationSpec::Type>]
            #     Enabled query classification types.
            class QueryClassificationSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Query classification types.
              module Type
                # Unspecified query classification type.
                TYPE_UNSPECIFIED = 0

                # Adversarial query classification type.
                ADVERSARIAL_QUERY = 1

                # Non-answer-seeking query classification type, for chit chat.
                NON_ANSWER_SEEKING_QUERY = 2

                # Jail-breaking query classification type.
                JAIL_BREAKING_QUERY = 3

                # Non-answer-seeking query classification type, for no clear intent.
                NON_ANSWER_SEEKING_QUERY_V2 = 4
              end
            end

            # Query rephraser specification.
            # @!attribute [rw] disable
            #   @return [::Boolean]
            #     Disable query rephraser.
            # @!attribute [rw] max_rephrase_steps
            #   @return [::Integer]
            #     Max rephrase steps.
            #     The max number is 5 steps.
            #     If not set or set to < 1, it will be set to 1 by default.
            class QueryRephraserSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class UserLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::ConversationalSearchService::Client#answer_query ConversationalSearchService.AnswerQuery}
        # method.
        # @!attribute [rw] answer
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Answer]
        #     Answer resource object.
        #     If
        #     {::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest::QueryUnderstandingSpec::QueryRephraserSpec#max_rephrase_steps AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec.max_rephrase_steps}
        #     is greater than 1, use
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Answer#name Answer.name} to fetch
        #     answer information using
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ConversationalSearchService::Client#get_answer ConversationalSearchService.GetAnswer}
        #     API.
        # @!attribute [rw] session
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Session]
        #     Session resource object.
        #     It will be only available when session field is set and valid in the
        #     {::Google::Cloud::DiscoveryEngine::V1beta::AnswerQueryRequest AnswerQueryRequest}
        #     request.
        # @!attribute [rw] answer_query_token
        #   @return [::String]
        #     A global unique ID used for logging.
        class AnswerQueryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetAnswer method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Answer to get. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/engines/{engine_id}/sessions/{session_id}/answers/{answer_id}`
        class GetAnswerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for CreateSession method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Full resource name of parent data store. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store_id}`
        # @!attribute [rw] session
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Session]
        #     Required. The session to create.
        class CreateSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for UpdateSession method.
        # @!attribute [rw] session
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Session]
        #     Required. The Session to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Indicates which fields in the provided
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Session Session} to update. The
        #     following are NOT supported:
        #
        #     * {::Google::Cloud::DiscoveryEngine::V1beta::Session#name Session.name}
        #
        #     If not set or empty, all supported fields are updated.
        class UpdateSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DeleteSession method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Session to delete. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store_id}/sessions/{session_id}`
        class DeleteSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetSession method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Session to get. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store_id}/sessions/{session_id}`
        # @!attribute [rw] include_answer_details
        #   @return [::Boolean]
        #     Optional. If set to true, the full session including all answer details
        #     will be returned.
        class GetSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ListSessions method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The data store resource name. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of results to return. If unspecified, defaults
        #     to 50. Max allowed value is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListSessions` call.
        #     Provide this to retrieve the subsequent page.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A comma-separated list of fields to filter by, in EBNF grammar.
        #     The supported fields are:
        #     * `user_pseudo_id`
        #     * `state`
        #     * `display_name`
        #     * `starred`
        #     * `is_pinned`
        #     * `labels`
        #     * `create_time`
        #     * `update_time`
        #
        #     Examples:
        #     "user_pseudo_id = some_id"
        #     "display_name = \"some_name\""
        #     "starred = true"
        #     "is_pinned=true AND (NOT labels:hidden)"
        #     "create_time > \"1970-01-01T12:00:00Z\""
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        #     Supported fields:
        #
        #       * `update_time`
        #       * `create_time`
        #       * `session_name`
        #       * `is_pinned`
        #
        #     Example:
        #
        #     * "update_time desc"
        #     * "create_time"
        #     * "is_pinned desc,update_time desc": list sessions by is_pinned first, then
        #        by update_time.
        class ListSessionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListSessions method.
        # @!attribute [rw] sessions
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::Session>]
        #     All the Sessions for a given data store.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pagination token, if not returned indicates the last page.
        class ListSessionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
