# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client#complete_query CompletionService.CompleteQuery}
        # method.
        # @!attribute [rw] data_store
        #   @return [::String]
        #     Required. The parent data store resource name for which the completion is
        #     performed, such as
        #     `projects/*/locations/global/collections/default_collection/dataStores/default_data_store`.
        # @!attribute [rw] query
        #   @return [::String]
        #     Required. The typeahead input used to fetch suggestions. Maximum length is
        #     128 characters.
        # @!attribute [rw] query_model
        #   @return [::String]
        #     Specifies the autocomplete data model. This overrides any model specified
        #     in the Configuration > Autocomplete section of the Cloud console. Currently
        #     supported values:
        #
        #     * `document` - Using suggestions generated from user-imported documents.
        #     * `search-history` - Using suggestions generated from the past history of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
        #     API calls. Do not use it when there is no traffic for Search API.
        #     * `user-event` - Using suggestions generated from user-imported search
        #     events.
        #     * `document-completable` - Using suggestions taken directly from
        #     user-imported document fields marked as completable.
        #
        #     Default values:
        #
        #     * `document` is the default model for regular dataStores.
        #     * `search-history` is the default model for site search dataStores.
        # @!attribute [rw] user_pseudo_id
        #   @return [::String]
        #     A unique identifier for tracking visitors. For example, this could be
        #     implemented with an HTTP cookie, which should be able to uniquely identify
        #     a visitor on a single device. This unique identifier should not change if
        #     the visitor logs in or out of the website.
        #
        #     This field should NOT have a fixed value such as `unknown_visitor`.
        #
        #     This should be the same identifier as
        #     {::Google::Cloud::DiscoveryEngine::V1beta::UserEvent#user_pseudo_id UserEvent.user_pseudo_id}
        #     and
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#user_pseudo_id SearchRequest.user_pseudo_id}.
        #
        #     The field must be a UTF-8 encoded string with a length limit of 128
        #     characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
        # @!attribute [rw] include_tail_suggestions
        #   @return [::Boolean]
        #     Indicates if tail suggestions should be returned if there are no
        #     suggestions that match the full query. Even if set to true, if there are
        #     suggestions that match the full query, those are returned and no
        #     tail suggestions are returned.
        class CompleteQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client#complete_query CompletionService.CompleteQuery}
        # method.
        # @!attribute [rw] query_suggestions
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::CompleteQueryResponse::QuerySuggestion>]
        #     Results of the matched query suggestions. The result list is ordered and
        #     the first result is a top suggestion.
        # @!attribute [rw] tail_match_triggered
        #   @return [::Boolean]
        #     True if the returned suggestions are all tail suggestions.
        #
        #     For tail matching to be triggered, include_tail_suggestions in the request
        #     must be true and there must be no suggestions that match the full query.
        class CompleteQueryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Suggestions as search queries.
          # @!attribute [rw] suggestion
          #   @return [::String]
          #     The suggestion for the query.
          # @!attribute [rw] completable_field_paths
          #   @return [::Array<::String>]
          #     The unique document field paths that serve as the source of this
          #     suggestion if it was generated from completable fields.
          #
          #     This field is only populated for the document-completable model.
          class QuerySuggestion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client#advanced_complete_query CompletionService.AdvancedCompleteQuery}
        # method.
        # .
        # @!attribute [rw] completion_config
        #   @return [::String]
        #     Required. The completion_config of the parent dataStore or engine resource
        #     name for which the completion is performed, such as
        #     `projects/*/locations/global/collections/default_collection/dataStores/*/completionConfig`
        #     `projects/*/locations/global/collections/default_collection/engines/*/completionConfig`.
        # @!attribute [rw] query
        #   @return [::String]
        #     Required. The typeahead input used to fetch suggestions. Maximum length is
        #     128 characters.
        #
        #     The query can not be empty for most of the suggestion types. If it is
        #     empty, an `INVALID_ARGUMENT` error is returned. The exception is when the
        #     suggestion_types contains only the type `RECENT_SEARCH`, the query can
        #     be an empty string. The is called "zero prefix" feature, which returns
        #     user's recently searched queries given the empty query.
        # @!attribute [rw] query_model
        #   @return [::String]
        #     Specifies the autocomplete data model. This overrides any model specified
        #     in the Configuration > Autocomplete section of the Cloud console. Currently
        #     supported values:
        #
        #     * `document` - Using suggestions generated from user-imported documents.
        #     * `search-history` - Using suggestions generated from the past history of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
        #     API calls. Do not use it when there is no traffic for Search API.
        #     * `user-event` - Using suggestions generated from user-imported search
        #     events.
        #     * `document-completable` - Using suggestions taken directly from
        #     user-imported document fields marked as completable.
        #
        #     Default values:
        #
        #     * `document` is the default model for regular dataStores.
        #     * `search-history` is the default model for site search dataStores.
        # @!attribute [rw] user_pseudo_id
        #   @return [::String]
        #     A unique identifier for tracking visitors. For example, this could be
        #     implemented with an HTTP cookie, which should be able to uniquely identify
        #     a visitor on a single device. This unique identifier should not change if
        #     the visitor logs in or out of the website.
        #
        #     This field should NOT have a fixed value such as `unknown_visitor`.
        #
        #     This should be the same identifier as
        #     {::Google::Cloud::DiscoveryEngine::V1beta::UserEvent#user_pseudo_id UserEvent.user_pseudo_id}
        #     and
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#user_pseudo_id SearchRequest.user_pseudo_id}.
        #
        #     The field must be a UTF-8 encoded string with a length limit of 128
        # @!attribute [rw] user_info
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::UserInfo]
        #     Optional. Information about the end user.
        #
        #     This should be the same identifier information as
        #     {::Google::Cloud::DiscoveryEngine::V1beta::UserEvent#user_info UserEvent.user_info}
        #     and
        #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#user_info SearchRequest.user_info}.
        # @!attribute [rw] include_tail_suggestions
        #   @return [::Boolean]
        #     Indicates if tail suggestions should be returned if there are no
        #     suggestions that match the full query. Even if set to true, if there are
        #     suggestions that match the full query, those are returned and no
        #     tail suggestions are returned.
        # @!attribute [rw] boost_spec
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryRequest::BoostSpec]
        #     Optional. Specification to boost suggestions matching the condition.
        # @!attribute [rw] suggestion_types
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryRequest::SuggestionType>]
        #     Optional. Suggestion types to return. If empty or unspecified, query
        #     suggestions are returned. Only one suggestion type is supported at the
        #     moment.
        class AdvancedCompleteQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specification to boost suggestions based on the condtion of the suggestion.
          # @!attribute [rw] condition_boost_specs
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryRequest::BoostSpec::ConditionBoostSpec>]
          #     Condition boost specifications. If a suggestion matches multiple
          #     conditions in the specifictions, boost values from these specifications
          #     are all applied and combined in a non-linear way. Maximum number of
          #     specifications is 20.
          #
          #     Note: Currently only support language condition boost.
          class BoostSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Boost applies to suggestions which match a condition.
            # @!attribute [rw] condition
            #   @return [::String]
            #     An expression which specifies a boost condition. The syntax is the same
            #     as [filter expression
            #     syntax](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
            #     Currently, the only supported condition is a list of BCP-47 lang codes.
            #
            #     Example:
            #
            #     * To boost suggestions in languages `en` or `fr`:
            #     `(lang_code: ANY("en", "fr"))`
            # @!attribute [rw] boost
            #   @return [::Float]
            #     Strength of the boost, which should be in [-1, 1].
            #     Negative boost means demotion. Default is 0.0.
            #
            #     Setting to 1.0 gives the suggestions a big promotion. However, it does
            #     not necessarily mean that the top result will be a boosted suggestion.
            #
            #     Setting to -1.0 gives the suggestions a big demotion. However, other
            #     suggestions that are relevant might still be shown.
            #
            #     Setting to 0.0 means no boost applied. The boosting condition is
            #     ignored.
            class ConditionBoostSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Suggestion type to return.
          module SuggestionType
            # Default value.
            SUGGESTION_TYPE_UNSPECIFIED = 0

            # Returns query suggestions.
            QUERY = 1

            # Returns people suggestions.
            PEOPLE = 2

            # Returns content suggestions.
            CONTENT = 3

            # Returns recent search suggestions.
            RECENT_SEARCH = 4

            # Returns Google Workspace suggestions.
            GOOGLE_WORKSPACE = 5
          end
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client#advanced_complete_query CompletionService.AdvancedCompleteQuery}
        # method.
        # @!attribute [rw] query_suggestions
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryResponse::QuerySuggestion>]
        #     Results of the matched query suggestions. The result list is ordered and
        #     the first result is a top suggestion.
        # @!attribute [rw] tail_match_triggered
        #   @return [::Boolean]
        #     True if the returned suggestions are all tail suggestions.
        #
        #     For tail matching to be triggered, include_tail_suggestions in the request
        #     must be true and there must be no suggestions that match the full query.
        # @!attribute [rw] people_suggestions
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryResponse::PersonSuggestion>]
        #     Results of the matched people suggestions. The result list is ordered and
        #     the first result is the top suggestion.
        # @!attribute [rw] content_suggestions
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryResponse::ContentSuggestion>]
        #     Results of the matched content suggestions. The result list is ordered and
        #     the first result is the top suggestion.
        # @!attribute [rw] recent_search_suggestions
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryResponse::RecentSearchSuggestion>]
        #     Results of the matched "recent search" suggestions. The result list is
        #     ordered and the first result is the top suggestion.
        class AdvancedCompleteQueryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Suggestions as search queries.
          # @!attribute [rw] suggestion
          #   @return [::String]
          #     The suggestion for the query.
          # @!attribute [rw] completable_field_paths
          #   @return [::Array<::String>]
          #     The unique document field paths that serve as the source of this
          #     suggestion if it was generated from completable fields.
          #
          #     This field is only populated for the document-completable model.
          # @!attribute [rw] data_store
          #   @return [::Array<::String>]
          #     The name of the dataStore that this suggestion belongs to.
          class QuerySuggestion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Suggestions as people.
          # @!attribute [rw] suggestion
          #   @return [::String]
          #     The suggestion for the query.
          # @!attribute [rw] person_type
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryResponse::PersonSuggestion::PersonType]
          #     The type of the person.
          # @!attribute [rw] document
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Document]
          #     The document data snippet in the suggestion. Only a subset of fields is
          #     populated.
          # @!attribute [rw] data_store
          #   @return [::String]
          #     The name of the dataStore that this suggestion belongs to.
          class PersonSuggestion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of the person based on the source.
            module PersonType
              # Default value.
              PERSON_TYPE_UNSPECIFIED = 0

              # The suggestion is from a GOOGLE_IDENTITY source.
              CLOUD_IDENTITY = 1

              # The suggestion is from a THIRD_PARTY_IDENTITY source.
              THIRD_PARTY_IDENTITY = 2
            end
          end

          # Suggestions as content.
          # @!attribute [rw] suggestion
          #   @return [::String]
          #     The suggestion for the query.
          # @!attribute [rw] content_type
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryResponse::ContentSuggestion::ContentType]
          #     The type of the content suggestion.
          # @!attribute [rw] document
          #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Document]
          #     The document data snippet in the suggestion. Only a subset of fields will
          #     be populated.
          # @!attribute [rw] data_store
          #   @return [::String]
          #     The name of the dataStore that this suggestion belongs to.
          class ContentSuggestion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of the content returned for content suggestions.
            module ContentType
              # Default value.
              CONTENT_TYPE_UNSPECIFIED = 0

              # The suggestion is from a Google Workspace source.
              GOOGLE_WORKSPACE = 1

              # The suggestion is from a third party source.
              THIRD_PARTY = 2
            end
          end

          # Suggestions from recent search history.
          # @!attribute [rw] suggestion
          #   @return [::String]
          #     The suggestion for the query.
          # @!attribute [rw] recent_search_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time when this recent rearch happened.
          class RecentSearchSuggestion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
