# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # A floating point interval.
        # @!attribute [rw] minimum
        #   @return [::Float]
        #     Inclusive lower bound.
        #
        #     Note: The following fields are mutually exclusive: `minimum`, `exclusive_minimum`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] exclusive_minimum
        #   @return [::Float]
        #     Exclusive lower bound.
        #
        #     Note: The following fields are mutually exclusive: `exclusive_minimum`, `minimum`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] maximum
        #   @return [::Float]
        #     Inclusive upper bound.
        #
        #     Note: The following fields are mutually exclusive: `maximum`, `exclusive_maximum`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] exclusive_maximum
        #   @return [::Float]
        #     Exclusive upper bound.
        #
        #     Note: The following fields are mutually exclusive: `exclusive_maximum`, `maximum`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Interval
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A custom attribute that is not explicitly modeled in a resource, e.g.
        # {::Google::Cloud::DiscoveryEngine::V1beta::UserEvent UserEvent}.
        # @!attribute [rw] text
        #   @return [::Array<::String>]
        #     The textual values of this custom attribute. For example, `["yellow",
        #     "green"]` when the key is "color".
        #
        #     Empty string is not allowed. Otherwise, an `INVALID_ARGUMENT` error is
        #     returned.
        #
        #     Exactly one of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::CustomAttribute#text CustomAttribute.text}
        #     or
        #     {::Google::Cloud::DiscoveryEngine::V1beta::CustomAttribute#numbers CustomAttribute.numbers}
        #     should be set. Otherwise, an `INVALID_ARGUMENT` error is returned.
        # @!attribute [rw] numbers
        #   @return [::Array<::Float>]
        #     The numerical values of this custom attribute. For example, `[2.3, 15.4]`
        #     when the key is "lengths_cm".
        #
        #     Exactly one of
        #     {::Google::Cloud::DiscoveryEngine::V1beta::CustomAttribute#text CustomAttribute.text}
        #     or
        #     {::Google::Cloud::DiscoveryEngine::V1beta::CustomAttribute#numbers CustomAttribute.numbers}
        #     should be set. Otherwise, an `INVALID_ARGUMENT` error is returned.
        class CustomAttribute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information of an end user.
        # @!attribute [rw] user_id
        #   @return [::String]
        #     Highly recommended for logged-in users. Unique identifier for logged-in
        #     user, such as a user name. Don't set for anonymous users.
        #
        #     Always use a hashed value for this ID.
        #
        #     Don't set the field to the same fixed ID for different users. This mixes
        #     the event history of those users together, which results in degraded
        #     model quality.
        #
        #     The field must be a UTF-8 encoded string with a length limit of 128
        #     characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
        # @!attribute [rw] user_agent
        #   @return [::String]
        #     User agent as included in the HTTP header.
        #
        #     The field must be a UTF-8 encoded string with a length limit of 1,000
        #     characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
        #
        #     This should not be set when using the client side event reporting with
        #     GTM or JavaScript tag in
        #     {::Google::Cloud::DiscoveryEngine::V1beta::UserEventService::Client#collect_user_event UserEventService.CollectUserEvent}
        #     or if
        #     {::Google::Cloud::DiscoveryEngine::V1beta::UserEvent#direct_user_request UserEvent.direct_user_request}
        #     is set.
        class UserInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines embedding config, used for bring your own embeddings feature.
        # @!attribute [rw] field_path
        #   @return [::String]
        #     Full field path in the schema mapped as embedding field.
        class EmbeddingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Double list.
        # @!attribute [rw] values
        #   @return [::Array<::Float>]
        #     Double values.
        class DoubleList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The industry vertical associated with the
        # {::Google::Cloud::DiscoveryEngine::V1beta::DataStore DataStore}.
        module IndustryVertical
          # Value used when unset.
          INDUSTRY_VERTICAL_UNSPECIFIED = 0

          # The generic vertical for documents that are not specific to any industry
          # vertical.
          GENERIC = 1

          # The media industry vertical.
          MEDIA = 2

          # The healthcare FHIR vertical.
          HEALTHCARE_FHIR = 7
        end

        # The type of solution.
        module SolutionType
          # Default value.
          SOLUTION_TYPE_UNSPECIFIED = 0

          # Used for Recommendations AI.
          SOLUTION_TYPE_RECOMMENDATION = 1

          # Used for Discovery Search.
          SOLUTION_TYPE_SEARCH = 2

          # Used for use cases related to the Generative AI agent.
          SOLUTION_TYPE_CHAT = 3

          # Used for use cases related to the Generative Chat agent.
          # It's used for Generative chat engine only, the associated data stores
          # must enrolled with `SOLUTION_TYPE_CHAT` solution.
          SOLUTION_TYPE_GENERATIVE_CHAT = 4
        end

        # Defines a further subdivision of `SolutionType`.
        # Specifically applies to
        # {::Google::Cloud::DiscoveryEngine::V1beta::SolutionType::SOLUTION_TYPE_SEARCH SOLUTION_TYPE_SEARCH}.
        module SearchUseCase
          # Value used when unset. Will not occur in CSS.
          SEARCH_USE_CASE_UNSPECIFIED = 0

          # Search use case. Expects the traffic has a non-empty
          # {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#query query}.
          SEARCH_USE_CASE_SEARCH = 1

          # Browse use case. Expects the traffic has an empty
          # {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#query query}.
          SEARCH_USE_CASE_BROWSE = 2
        end

        # Tiers of search features. Different tiers might have different
        # pricing. To learn more, check the pricing documentation.
        module SearchTier
          # Default value when the enum is unspecified. This is invalid to use.
          SEARCH_TIER_UNSPECIFIED = 0

          # Standard tier.
          SEARCH_TIER_STANDARD = 1

          # Enterprise tier.
          SEARCH_TIER_ENTERPRISE = 2
        end

        # Add-on that provides additional functionality for search.
        module SearchAddOn
          # Default value when the enum is unspecified. This is invalid to use.
          SEARCH_ADD_ON_UNSPECIFIED = 0

          # Large language model add-on.
          SEARCH_ADD_ON_LLM = 1
        end
      end
    end
  end
end
