# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Chunk captures all raw metadata information of items to be recommended or
        # searched in the chunk mode.
        # @!attribute [rw] name
        #   @return [::String]
        #     The full resource name of the chunk.
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
        #
        #     This field must be a UTF-8 encoded string with a length limit of 1024
        #     characters.
        # @!attribute [rw] id
        #   @return [::String]
        #     Unique chunk ID of the current chunk.
        # @!attribute [rw] content
        #   @return [::String]
        #     Content is a string from a document (parsed content).
        # @!attribute [r] relevance_score
        #   @return [::Float]
        #     Output only. Represents the relevance score based on similarity.
        #     Higher score indicates higher chunk relevance.
        #     The score is in range [-1.0, 1.0].
        #     Only populated on [SearchService.SearchResponse][].
        # @!attribute [rw] document_metadata
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Chunk::DocumentMetadata]
        #     Metadata of the document from the current chunk.
        # @!attribute [r] derived_struct_data
        #   @return [::Google::Protobuf::Struct]
        #     Output only. This field is OUTPUT_ONLY.
        #     It contains derived data that are not in the original input document.
        # @!attribute [rw] page_span
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Chunk::PageSpan]
        #     Page span of the chunk.
        # @!attribute [r] chunk_metadata
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::Chunk::ChunkMetadata]
        #     Output only. Metadata of the current chunk.
        class Chunk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Document metadata contains the information of the document of the current
          # chunk.
          # @!attribute [rw] uri
          #   @return [::String]
          #     Uri of the document.
          # @!attribute [rw] title
          #   @return [::String]
          #     Title of the document.
          # @!attribute [rw] struct_data
          #   @return [::Google::Protobuf::Struct]
          #     Data representation.
          #     The structured JSON data for the document. It should conform to the
          #     registered {::Google::Cloud::DiscoveryEngine::V1beta::Schema Schema} or an
          #     `INVALID_ARGUMENT` error is thrown.
          class DocumentMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Page span of the chunk.
          # @!attribute [rw] page_start
          #   @return [::Integer]
          #     The start page of the chunk.
          # @!attribute [rw] page_end
          #   @return [::Integer]
          #     The end page of the chunk.
          class PageSpan
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata of the current chunk. This field is only populated on
          # {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
          # API.
          # @!attribute [rw] previous_chunks
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::Chunk>]
          #     The previous chunks of the current chunk. The number is controlled by
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::ChunkSpec#num_previous_chunks SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks}.
          #     This field is only populated on
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
          #     API.
          # @!attribute [rw] next_chunks
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::Chunk>]
          #     The next chunks of the current chunk. The number is controlled by
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec::ChunkSpec#num_next_chunks SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks}.
          #     This field is only populated on
          #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
          #     API.
          class ChunkMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
