# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/discoveryengine/v1beta/site_search_engine_service_pb"
require "google/cloud/location"

module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        module SiteSearchEngineService
          ##
          # Client for the SiteSearchEngineService service.
          #
          # Service for managing site search related resources.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "discoveryengine.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :site_search_engine_service_stub

            ##
            # Configure the SiteSearchEngineService Client class.
            #
            # See {::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all SiteSearchEngineService clients
            #   ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "DiscoveryEngine", "V1beta"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the SiteSearchEngineService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @site_search_engine_service_stub.universe_domain
            end

            ##
            # Create a new SiteSearchEngineService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the SiteSearchEngineService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/discoveryengine/v1beta/site_search_engine_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @site_search_engine_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @site_search_engine_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @site_search_engine_service_stub.endpoint
                config.universe_domain = @site_search_engine_service_stub.universe_domain
                config.logger = @site_search_engine_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @site_search_engine_service_stub.logger
            end

            # Service calls

            ##
            # Gets the
            # {::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngine SiteSearchEngine}.
            #
            # @overload get_site_search_engine(request, options = nil)
            #   Pass arguments to `get_site_search_engine` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::GetSiteSearchEngineRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::GetSiteSearchEngineRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_site_search_engine(name: nil)
            #   Pass arguments to `get_site_search_engine` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngine SiteSearchEngine},
            #     such as
            #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
            #
            #     If the caller does not have permission to access the [SiteSearchEngine],
            #     regardless of whether or not it exists, a PERMISSION_DENIED error is
            #     returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngine]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngine]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::GetSiteSearchEngineRequest.new
            #
            #   # Call the get_site_search_engine method.
            #   result = client.get_site_search_engine request
            #
            #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngine.
            #   p result
            #
            def get_site_search_engine request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::GetSiteSearchEngineRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_site_search_engine.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_site_search_engine.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_site_search_engine.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :get_site_search_engine, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}.
            #
            # @overload create_target_site(request, options = nil)
            #   Pass arguments to `create_target_site` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::CreateTargetSiteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::CreateTargetSiteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_target_site(parent: nil, target_site: nil)
            #   Pass arguments to `create_target_site` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent resource name of
            #     {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}, such as
            #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
            #   @param target_site [::Google::Cloud::DiscoveryEngine::V1beta::TargetSite, ::Hash]
            #     Required. The {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}
            #     to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::CreateTargetSiteRequest.new
            #
            #   # Call the create_target_site method.
            #   result = client.create_target_site request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_target_site request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::CreateTargetSiteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_target_site.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_target_site.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_target_site.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :create_target_site, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite} in a
            # batch.
            #
            # @overload batch_create_target_sites(request, options = nil)
            #   Pass arguments to `batch_create_target_sites` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::BatchCreateTargetSitesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::BatchCreateTargetSitesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_create_target_sites(parent: nil, requests: nil)
            #   Pass arguments to `batch_create_target_sites` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource shared by all TargetSites being created.
            #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
            #     The parent field in the CreateBookRequest messages must either be empty or
            #     match this field.
            #   @param requests [::Array<::Google::Cloud::DiscoveryEngine::V1beta::CreateTargetSiteRequest, ::Hash>]
            #     Required. The request message specifying the resources to create.
            #     A maximum of 20 TargetSites can be created in a batch.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::BatchCreateTargetSitesRequest.new
            #
            #   # Call the batch_create_target_sites method.
            #   result = client.batch_create_target_sites request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_create_target_sites request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::BatchCreateTargetSitesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_create_target_sites.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_create_target_sites.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_create_target_sites.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :batch_create_target_sites, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}.
            #
            # @overload get_target_site(request, options = nil)
            #   Pass arguments to `get_target_site` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::GetTargetSiteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::GetTargetSiteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_target_site(name: nil)
            #   Pass arguments to `get_target_site` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Full resource name of
            #     {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}, such as
            #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`.
            #
            #     If the caller does not have permission to access the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}, regardless of
            #     whether or not it exists, a PERMISSION_DENIED error is returned.
            #
            #     If the requested
            #     {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite} does not
            #     exist, a NOT_FOUND error is returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DiscoveryEngine::V1beta::TargetSite]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DiscoveryEngine::V1beta::TargetSite]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::GetTargetSiteRequest.new
            #
            #   # Call the get_target_site method.
            #   result = client.get_target_site request
            #
            #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1beta::TargetSite.
            #   p result
            #
            def get_target_site request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::GetTargetSiteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_target_site.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_target_site.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_target_site.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :get_target_site, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}.
            #
            # @overload update_target_site(request, options = nil)
            #   Pass arguments to `update_target_site` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::UpdateTargetSiteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::UpdateTargetSiteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_target_site(target_site: nil)
            #   Pass arguments to `update_target_site` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param target_site [::Google::Cloud::DiscoveryEngine::V1beta::TargetSite, ::Hash]
            #     Required. The target site to update.
            #     If the caller does not have permission to update the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}, regardless of
            #     whether or not it exists, a PERMISSION_DENIED error is returned.
            #
            #     If the {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite} to
            #     update does not exist, a NOT_FOUND error is returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::UpdateTargetSiteRequest.new
            #
            #   # Call the update_target_site method.
            #   result = client.update_target_site request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_target_site request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::UpdateTargetSiteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_target_site.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.target_site&.name
                header_params["target_site.name"] = request.target_site.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_target_site.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_target_site.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :update_target_site, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}.
            #
            # @overload delete_target_site(request, options = nil)
            #   Pass arguments to `delete_target_site` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::DeleteTargetSiteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::DeleteTargetSiteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_target_site(name: nil)
            #   Pass arguments to `delete_target_site` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Full resource name of
            #     {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}, such as
            #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`.
            #
            #     If the caller does not have permission to access the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}, regardless of
            #     whether or not it exists, a PERMISSION_DENIED error is returned.
            #
            #     If the requested
            #     {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite} does not
            #     exist, a NOT_FOUND error is returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::DeleteTargetSiteRequest.new
            #
            #   # Call the delete_target_site method.
            #   result = client.delete_target_site request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_target_site request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::DeleteTargetSiteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_target_site.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_target_site.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_target_site.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :delete_target_site, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a list of
            # {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}s.
            #
            # @overload list_target_sites(request, options = nil)
            #   Pass arguments to `list_target_sites` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::ListTargetSitesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::ListTargetSitesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_target_sites(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_target_sites` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent site search engine resource name, such as
            #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
            #
            #     If the caller does not have permission to list
            #     {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite}s under this
            #     site search engine, regardless of whether or not this branch exists, a
            #     PERMISSION_DENIED error is returned.
            #   @param page_size [::Integer]
            #     Requested page size. Server may return fewer items than requested. If
            #     unspecified, server will pick an appropriate default. The maximum value is
            #     1000; values above 1000 will be coerced to 1000.
            #
            #     If this field is negative, an INVALID_ARGUMENT error is returned.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListTargetSites` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListTargetSites`
            #     must match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1beta::TargetSite>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1beta::TargetSite>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::ListTargetSitesRequest.new
            #
            #   # Call the list_target_sites method.
            #   result = client.list_target_sites request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DiscoveryEngine::V1beta::TargetSite.
            #     p item
            #   end
            #
            def list_target_sites request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::ListTargetSitesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_target_sites.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_target_sites.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_target_sites.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :list_target_sites, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @site_search_engine_service_stub, :list_target_sites, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a {::Google::Cloud::DiscoveryEngine::V1beta::Sitemap Sitemap}.
            #
            # @overload create_sitemap(request, options = nil)
            #   Pass arguments to `create_sitemap` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::CreateSitemapRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::CreateSitemapRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_sitemap(parent: nil, sitemap: nil)
            #   Pass arguments to `create_sitemap` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent resource name of the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngine SiteSearchEngine},
            #     such as
            #     `projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine`.
            #   @param sitemap [::Google::Cloud::DiscoveryEngine::V1beta::Sitemap, ::Hash]
            #     Required. The {::Google::Cloud::DiscoveryEngine::V1beta::Sitemap Sitemap} to
            #     create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::CreateSitemapRequest.new
            #
            #   # Call the create_sitemap method.
            #   result = client.create_sitemap request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_sitemap request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::CreateSitemapRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_sitemap.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_sitemap.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_sitemap.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :create_sitemap, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a {::Google::Cloud::DiscoveryEngine::V1beta::Sitemap Sitemap}.
            #
            # @overload delete_sitemap(request, options = nil)
            #   Pass arguments to `delete_sitemap` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::DeleteSitemapRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::DeleteSitemapRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_sitemap(name: nil)
            #   Pass arguments to `delete_sitemap` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Full resource name of
            #     {::Google::Cloud::DiscoveryEngine::V1beta::Sitemap Sitemap}, such as
            #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/sitemaps/{sitemap}`.
            #
            #     If the caller does not have permission to access the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::Sitemap Sitemap}, regardless of
            #     whether or not it exists, a PERMISSION_DENIED error is returned.
            #
            #     If the requested {::Google::Cloud::DiscoveryEngine::V1beta::Sitemap Sitemap}
            #     does not exist, a NOT_FOUND error is returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::DeleteSitemapRequest.new
            #
            #   # Call the delete_sitemap method.
            #   result = client.delete_sitemap request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_sitemap request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::DeleteSitemapRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_sitemap.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_sitemap.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_sitemap.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :delete_sitemap, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetch {::Google::Cloud::DiscoveryEngine::V1beta::Sitemap Sitemap}s in a
            # {::Google::Cloud::DiscoveryEngine::V1beta::DataStore DataStore}.
            #
            # @overload fetch_sitemaps(request, options = nil)
            #   Pass arguments to `fetch_sitemaps` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::FetchSitemapsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::FetchSitemapsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_sitemaps(parent: nil, matcher: nil)
            #   Pass arguments to `fetch_sitemaps` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent resource name of the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngine SiteSearchEngine},
            #     such as
            #     `projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine`.
            #   @param matcher [::Google::Cloud::DiscoveryEngine::V1beta::FetchSitemapsRequest::Matcher, ::Hash]
            #     Optional. If specified, fetches the matching
            #     {::Google::Cloud::DiscoveryEngine::V1beta::Sitemap Sitemap}s. If not specified,
            #     fetches all {::Google::Cloud::DiscoveryEngine::V1beta::Sitemap Sitemap}s in the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore DataStore}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DiscoveryEngine::V1beta::FetchSitemapsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DiscoveryEngine::V1beta::FetchSitemapsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::FetchSitemapsRequest.new
            #
            #   # Call the fetch_sitemaps method.
            #   result = client.fetch_sitemaps request
            #
            #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1beta::FetchSitemapsResponse.
            #   p result
            #
            def fetch_sitemaps request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::FetchSitemapsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_sitemaps.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_sitemaps.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_sitemaps.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :fetch_sitemaps, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Upgrade from basic site search to advanced site search.
            #
            # @overload enable_advanced_site_search(request, options = nil)
            #   Pass arguments to `enable_advanced_site_search` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::EnableAdvancedSiteSearchRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::EnableAdvancedSiteSearchRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload enable_advanced_site_search(site_search_engine: nil)
            #   Pass arguments to `enable_advanced_site_search` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param site_search_engine [::String]
            #     Required. Full resource name of the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngine SiteSearchEngine},
            #     such as
            #     `projects/{project}/locations/{location}/dataStores/{data_store_id}/siteSearchEngine`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::EnableAdvancedSiteSearchRequest.new
            #
            #   # Call the enable_advanced_site_search method.
            #   result = client.enable_advanced_site_search request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def enable_advanced_site_search request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::EnableAdvancedSiteSearchRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.enable_advanced_site_search.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.site_search_engine
                header_params["site_search_engine"] = request.site_search_engine
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.enable_advanced_site_search.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.enable_advanced_site_search.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :enable_advanced_site_search, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Downgrade from advanced site search to basic site search.
            #
            # @overload disable_advanced_site_search(request, options = nil)
            #   Pass arguments to `disable_advanced_site_search` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::DisableAdvancedSiteSearchRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::DisableAdvancedSiteSearchRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload disable_advanced_site_search(site_search_engine: nil)
            #   Pass arguments to `disable_advanced_site_search` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param site_search_engine [::String]
            #     Required. Full resource name of the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngine SiteSearchEngine},
            #     such as
            #     `projects/{project}/locations/{location}/dataStores/{data_store_id}/siteSearchEngine`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::DisableAdvancedSiteSearchRequest.new
            #
            #   # Call the disable_advanced_site_search method.
            #   result = client.disable_advanced_site_search request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def disable_advanced_site_search request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::DisableAdvancedSiteSearchRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.disable_advanced_site_search.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.site_search_engine
                header_params["site_search_engine"] = request.site_search_engine
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.disable_advanced_site_search.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.disable_advanced_site_search.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :disable_advanced_site_search, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Request on-demand recrawl for a list of URIs.
            #
            # @overload recrawl_uris(request, options = nil)
            #   Pass arguments to `recrawl_uris` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::RecrawlUrisRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::RecrawlUrisRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload recrawl_uris(site_search_engine: nil, uris: nil, site_credential: nil)
            #   Pass arguments to `recrawl_uris` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param site_search_engine [::String]
            #     Required. Full resource name of the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngine SiteSearchEngine},
            #     such as
            #     `projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine`.
            #   @param uris [::Array<::String>]
            #     Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
            #     an INVALID_ARGUMENT error is thrown. Each URI should match at least one
            #     {::Google::Cloud::DiscoveryEngine::V1beta::TargetSite TargetSite} in
            #     `site_search_engine`.
            #   @param site_credential [::String]
            #     Optional. Full resource name of the [SiteCredential][], such as
            #     `projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/siteCredentials/*`.
            #     Only set to crawl private URIs.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::RecrawlUrisRequest.new
            #
            #   # Call the recrawl_uris method.
            #   result = client.recrawl_uris request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def recrawl_uris request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::RecrawlUrisRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.recrawl_uris.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.site_search_engine
                header_params["site_search_engine"] = request.site_search_engine
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.recrawl_uris.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.recrawl_uris.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :recrawl_uris, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Verify target sites' ownership and validity.
            # This API sends all the target sites under site search engine for
            # verification.
            #
            # @overload batch_verify_target_sites(request, options = nil)
            #   Pass arguments to `batch_verify_target_sites` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::BatchVerifyTargetSitesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::BatchVerifyTargetSitesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_verify_target_sites(parent: nil)
            #   Pass arguments to `batch_verify_target_sites` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource shared by all TargetSites being verified.
            #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::BatchVerifyTargetSitesRequest.new
            #
            #   # Call the batch_verify_target_sites method.
            #   result = client.batch_verify_target_sites request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_verify_target_sites request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::BatchVerifyTargetSitesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_verify_target_sites.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_verify_target_sites.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_verify_target_sites.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :batch_verify_target_sites, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns list of target sites with its domain verification status.
            # This method can only be called under data store with BASIC_SITE_SEARCH
            # state at the moment.
            #
            # @overload fetch_domain_verification_status(request, options = nil)
            #   Pass arguments to `fetch_domain_verification_status` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::FetchDomainVerificationStatusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::FetchDomainVerificationStatusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_domain_verification_status(site_search_engine: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `fetch_domain_verification_status` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param site_search_engine [::String]
            #     Required. The site search engine resource under which we fetch all the
            #     domain verification status.
            #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
            #   @param page_size [::Integer]
            #     Requested page size. Server may return fewer items than requested. If
            #     unspecified, server will pick an appropriate default. The maximum value is
            #     1000; values above 1000 will be coerced to 1000.
            #
            #     If this field is negative, an INVALID_ARGUMENT error is returned.
            #   @param page_token [::String]
            #     A page token, received from a previous `FetchDomainVerificationStatus`
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `FetchDomainVerificationStatus` must match the call that provided the page
            #     token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1beta::TargetSite>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1beta::TargetSite>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::FetchDomainVerificationStatusRequest.new
            #
            #   # Call the fetch_domain_verification_status method.
            #   result = client.fetch_domain_verification_status request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DiscoveryEngine::V1beta::TargetSite.
            #     p item
            #   end
            #
            def fetch_domain_verification_status request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::FetchDomainVerificationStatusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_domain_verification_status.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.site_search_engine
                header_params["site_search_engine"] = request.site_search_engine
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_domain_verification_status.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_domain_verification_status.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @site_search_engine_service_stub.call_rpc :fetch_domain_verification_status, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @site_search_engine_service_stub, :fetch_domain_verification_status, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the SiteSearchEngineService API.
            #
            # This class represents the configuration for SiteSearchEngineService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # get_site_search_engine to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_site_search_engine.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_site_search_engine.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "discoveryengine.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the SiteSearchEngineService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `get_site_search_engine`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_site_search_engine
                ##
                # RPC-specific configuration for `create_target_site`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_target_site
                ##
                # RPC-specific configuration for `batch_create_target_sites`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_create_target_sites
                ##
                # RPC-specific configuration for `get_target_site`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_target_site
                ##
                # RPC-specific configuration for `update_target_site`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_target_site
                ##
                # RPC-specific configuration for `delete_target_site`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_target_site
                ##
                # RPC-specific configuration for `list_target_sites`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_target_sites
                ##
                # RPC-specific configuration for `create_sitemap`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_sitemap
                ##
                # RPC-specific configuration for `delete_sitemap`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_sitemap
                ##
                # RPC-specific configuration for `fetch_sitemaps`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_sitemaps
                ##
                # RPC-specific configuration for `enable_advanced_site_search`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :enable_advanced_site_search
                ##
                # RPC-specific configuration for `disable_advanced_site_search`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :disable_advanced_site_search
                ##
                # RPC-specific configuration for `recrawl_uris`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :recrawl_uris
                ##
                # RPC-specific configuration for `batch_verify_target_sites`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_verify_target_sites
                ##
                # RPC-specific configuration for `fetch_domain_verification_status`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_domain_verification_status

                # @private
                def initialize parent_rpcs = nil
                  get_site_search_engine_config = parent_rpcs.get_site_search_engine if parent_rpcs.respond_to? :get_site_search_engine
                  @get_site_search_engine = ::Gapic::Config::Method.new get_site_search_engine_config
                  create_target_site_config = parent_rpcs.create_target_site if parent_rpcs.respond_to? :create_target_site
                  @create_target_site = ::Gapic::Config::Method.new create_target_site_config
                  batch_create_target_sites_config = parent_rpcs.batch_create_target_sites if parent_rpcs.respond_to? :batch_create_target_sites
                  @batch_create_target_sites = ::Gapic::Config::Method.new batch_create_target_sites_config
                  get_target_site_config = parent_rpcs.get_target_site if parent_rpcs.respond_to? :get_target_site
                  @get_target_site = ::Gapic::Config::Method.new get_target_site_config
                  update_target_site_config = parent_rpcs.update_target_site if parent_rpcs.respond_to? :update_target_site
                  @update_target_site = ::Gapic::Config::Method.new update_target_site_config
                  delete_target_site_config = parent_rpcs.delete_target_site if parent_rpcs.respond_to? :delete_target_site
                  @delete_target_site = ::Gapic::Config::Method.new delete_target_site_config
                  list_target_sites_config = parent_rpcs.list_target_sites if parent_rpcs.respond_to? :list_target_sites
                  @list_target_sites = ::Gapic::Config::Method.new list_target_sites_config
                  create_sitemap_config = parent_rpcs.create_sitemap if parent_rpcs.respond_to? :create_sitemap
                  @create_sitemap = ::Gapic::Config::Method.new create_sitemap_config
                  delete_sitemap_config = parent_rpcs.delete_sitemap if parent_rpcs.respond_to? :delete_sitemap
                  @delete_sitemap = ::Gapic::Config::Method.new delete_sitemap_config
                  fetch_sitemaps_config = parent_rpcs.fetch_sitemaps if parent_rpcs.respond_to? :fetch_sitemaps
                  @fetch_sitemaps = ::Gapic::Config::Method.new fetch_sitemaps_config
                  enable_advanced_site_search_config = parent_rpcs.enable_advanced_site_search if parent_rpcs.respond_to? :enable_advanced_site_search
                  @enable_advanced_site_search = ::Gapic::Config::Method.new enable_advanced_site_search_config
                  disable_advanced_site_search_config = parent_rpcs.disable_advanced_site_search if parent_rpcs.respond_to? :disable_advanced_site_search
                  @disable_advanced_site_search = ::Gapic::Config::Method.new disable_advanced_site_search_config
                  recrawl_uris_config = parent_rpcs.recrawl_uris if parent_rpcs.respond_to? :recrawl_uris
                  @recrawl_uris = ::Gapic::Config::Method.new recrawl_uris_config
                  batch_verify_target_sites_config = parent_rpcs.batch_verify_target_sites if parent_rpcs.respond_to? :batch_verify_target_sites
                  @batch_verify_target_sites = ::Gapic::Config::Method.new batch_verify_target_sites_config
                  fetch_domain_verification_status_config = parent_rpcs.fetch_domain_verification_status if parent_rpcs.respond_to? :fetch_domain_verification_status
                  @fetch_domain_verification_status = ::Gapic::Config::Method.new fetch_domain_verification_status_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
