# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        module SearchService
          # Path helper methods for the SearchService API.
          module Paths
            ##
            # Create a fully-qualified Branch resource string.
            #
            # @overload branch_path(project:, location:, data_store:, branch:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param data_store [String]
            #   @param branch [String]
            #
            # @overload branch_path(project:, location:, collection:, data_store:, branch:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param collection [String]
            #   @param data_store [String]
            #   @param branch [String]
            #
            # @return [::String]
            def branch_path **args
              resources = {
                "branch:data_store:location:project" => (proc do |project:, location:, data_store:, branch:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "data_store cannot contain /" if data_store.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/dataStores/#{data_store}/branches/#{branch}"
                end),
                "branch:collection:data_store:location:project" => (proc do |project:, location:, collection:, data_store:, branch:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"
                  raise ::ArgumentError, "data_store cannot contain /" if data_store.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/collections/#{collection}/dataStores/#{data_store}/branches/#{branch}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified DataStore resource string.
            #
            # @overload data_store_path(project:, location:, data_store:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/dataStores/{data_store}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param data_store [String]
            #
            # @overload data_store_path(project:, location:, collection:, data_store:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param collection [String]
            #   @param data_store [String]
            #
            # @return [::String]
            def data_store_path **args
              resources = {
                "data_store:location:project" => (proc do |project:, location:, data_store:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/dataStores/#{data_store}"
                end),
                "collection:data_store:location:project" => (proc do |project:, location:, collection:, data_store:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/collections/#{collection}/dataStores/#{data_store}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified ServingConfig resource string.
            #
            # @overload serving_config_path(project:, location:, data_store:, serving_config:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/dataStores/{data_store}/servingConfigs/{serving_config}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param data_store [String]
            #   @param serving_config [String]
            #
            # @overload serving_config_path(project:, location:, collection:, data_store:, serving_config:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/servingConfigs/{serving_config}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param collection [String]
            #   @param data_store [String]
            #   @param serving_config [String]
            #
            # @overload serving_config_path(project:, location:, collection:, engine:, serving_config:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/servingConfigs/{serving_config}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param collection [String]
            #   @param engine [String]
            #   @param serving_config [String]
            #
            # @return [::String]
            def serving_config_path **args
              resources = {
                "data_store:location:project:serving_config" => (proc do |project:, location:, data_store:, serving_config:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "data_store cannot contain /" if data_store.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/dataStores/#{data_store}/servingConfigs/#{serving_config}"
                end),
                "collection:data_store:location:project:serving_config" => (proc do |project:, location:, collection:, data_store:, serving_config:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"
                  raise ::ArgumentError, "data_store cannot contain /" if data_store.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/collections/#{collection}/dataStores/#{data_store}/servingConfigs/#{serving_config}"
                end),
                "collection:engine:location:project:serving_config" => (proc do |project:, location:, collection:, engine:, serving_config:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"
                  raise ::ArgumentError, "engine cannot contain /" if engine.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/collections/#{collection}/engines/#{engine}/servingConfigs/#{serving_config}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Session resource string.
            #
            # @overload session_path(project:, location:, data_store:, session:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/dataStores/{data_store}/sessions/{session}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param data_store [String]
            #   @param session [String]
            #
            # @overload session_path(project:, location:, collection:, data_store:, session:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/sessions/{session}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param collection [String]
            #   @param data_store [String]
            #   @param session [String]
            #
            # @overload session_path(project:, location:, collection:, engine:, session:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/sessions/{session}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param collection [String]
            #   @param engine [String]
            #   @param session [String]
            #
            # @return [::String]
            def session_path **args
              resources = {
                "data_store:location:project:session" => (proc do |project:, location:, data_store:, session:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "data_store cannot contain /" if data_store.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/dataStores/#{data_store}/sessions/#{session}"
                end),
                "collection:data_store:location:project:session" => (proc do |project:, location:, collection:, data_store:, session:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"
                  raise ::ArgumentError, "data_store cannot contain /" if data_store.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/collections/#{collection}/dataStores/#{data_store}/sessions/#{session}"
                end),
                "collection:engine:location:project:session" => (proc do |project:, location:, collection:, engine:, session:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"
                  raise ::ArgumentError, "engine cannot contain /" if engine.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/collections/#{collection}/engines/#{engine}/sessions/#{session}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
