# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/discoveryengine/v1beta/search_service_pb"
require "google/cloud/location"

module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        module SearchService
          ##
          # Client for the SearchService service.
          #
          # Service for search.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "discoveryengine.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :search_service_stub

            ##
            # Configure the SearchService Client class.
            #
            # See {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all SearchService clients
            #   ::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "DiscoveryEngine", "V1beta"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 30.0
                default_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the SearchService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @search_service_stub.universe_domain
            end

            ##
            # Create a new SearchService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the SearchService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/discoveryengine/v1beta/search_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @search_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @search_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @search_service_stub.endpoint
                config.universe_domain = @search_service_stub.universe_domain
                config.logger = @search_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @search_service_stub.logger
            end

            # Service calls

            ##
            # Performs a search.
            #
            # @overload search(request, options = nil)
            #   Pass arguments to `search` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search(serving_config: nil, branch: nil, query: nil, image_query: nil, page_size: nil, page_token: nil, offset: nil, one_box_page_size: nil, data_store_specs: nil, filter: nil, canonical_filter: nil, order_by: nil, user_info: nil, language_code: nil, region_code: nil, facet_specs: nil, boost_spec: nil, params: nil, query_expansion_spec: nil, spell_correction_spec: nil, user_pseudo_id: nil, content_search_spec: nil, embedding_spec: nil, ranking_expression: nil, ranking_expression_backend: nil, safe_search: nil, user_labels: nil, natural_language_query_understanding_spec: nil, search_as_you_type_spec: nil, session: nil, session_spec: nil, relevance_threshold: nil, personalization_spec: nil)
            #   Pass arguments to `search` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param serving_config [::String]
            #     Required. The resource name of the Search serving config, such as
            #     `projects/*/locations/global/collections/default_collection/engines/*/servingConfigs/default_serving_config`,
            #     or
            #     `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
            #     This field is used to identify the serving configuration name, set
            #     of models used to make the search.
            #   @param branch [::String]
            #     The branch resource name, such as
            #     `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
            #
            #     Use `default_branch` as the branch ID or leave this field empty, to search
            #     documents under the default branch.
            #   @param query [::String]
            #     Raw search query.
            #   @param image_query [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ImageQuery, ::Hash]
            #     Raw image query.
            #   @param page_size [::Integer]
            #     Maximum number of {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s
            #     to return. The maximum allowed value depends on the data type. Values above
            #     the maximum value are coerced to the maximum value.
            #
            #     * Websites with basic indexing: Default `10`, Maximum `25`.
            #     * Websites with advanced indexing: Default `25`, Maximum `50`.
            #     * Other: Default `50`, Maximum `100`.
            #
            #     If this field is negative, an  `INVALID_ARGUMENT` is returned.
            #   @param page_token [::String]
            #     A page token received from a previous
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
            #     must match the call that provided the page token. Otherwise, an
            #      `INVALID_ARGUMENT`  error is returned.
            #   @param offset [::Integer]
            #     A 0-indexed integer that specifies the current offset (that is, starting
            #     result location, amongst the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s deemed by the API
            #     as relevant) in search results. This field is only considered if
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#page_token page_token}
            #     is unset.
            #
            #     If this field is negative, an  `INVALID_ARGUMENT`  is returned.
            #   @param one_box_page_size [::Integer]
            #     The maximum number of results to return for OneBox.
            #     This applies to each OneBox type individually.
            #     Default number is 10.
            #   @param data_store_specs [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::DataStoreSpec, ::Hash>]
            #     Specs defining dataStores to filter on in a search call and configurations
            #     for those dataStores. This is only considered for engines with multiple
            #     dataStores use case. For single dataStore within an engine, they should
            #     use the specs at the top level.
            #   @param filter [::String]
            #     The filter syntax consists of an expression language for constructing a
            #     predicate from one or more fields of the documents being filtered. Filter
            #     expression is case-sensitive.
            #
            #     If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
            #
            #     Filtering in Vertex AI Search is done by mapping the LHS filter key to a
            #     key property defined in the Vertex AI Search backend -- this mapping is
            #     defined by the customer in their schema. For example a media customer might
            #     have a field 'name' in their schema. In this case the filter would look
            #     like this: filter --> name:'ANY("king kong")'
            #
            #     For more information about filtering including syntax and filter
            #     operators, see
            #     [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
            #   @param canonical_filter [::String]
            #     The default filter that is applied when a user performs a search without
            #     checking any filters on the search page.
            #
            #     The filter applied to every search request when quality improvement such as
            #     query expansion is needed. In the case a query does not have a sufficient
            #     amount of results this filter will be used to determine whether or not to
            #     enable the query expansion flow. The original filter will still be used for
            #     the query expanded search.
            #     This field is strongly recommended to achieve high search quality.
            #
            #     For more information about filter syntax, see
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#filter SearchRequest.filter}.
            #   @param order_by [::String]
            #     The order in which documents are returned. Documents can be ordered by
            #     a field in an {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}
            #     object. Leave it unset if ordered by relevance. `order_by` expression is
            #     case-sensitive.
            #
            #     For more information on ordering the website search results, see
            #     [Order web search
            #     results](https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results).
            #     For more information on ordering the healthcare search results, see
            #     [Order healthcare search
            #     results](https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results).
            #     If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
            #   @param user_info [::Google::Cloud::DiscoveryEngine::V1beta::UserInfo, ::Hash]
            #     Information about the end user.
            #     Highly recommended for analytics.
            #     {::Google::Cloud::DiscoveryEngine::V1beta::UserInfo#user_agent UserInfo.user_agent}
            #     is used to deduce `device_type` for analytics.
            #   @param language_code [::String]
            #     The BCP-47 language code, such as "en-US" or "sr-Latn". For more
            #     information, see [Standard
            #     fields](https://cloud.google.com/apis/design/standard_fields). This field
            #     helps to better interpret the query. If a value isn't specified, the query
            #     language code is automatically detected, which may not be accurate.
            #   @param region_code [::String]
            #     The Unicode country/region code (CLDR) of a location, such as "US" and
            #     "419". For more information, see [Standard
            #     fields](https://cloud.google.com/apis/design/standard_fields). If set,
            #     then results will be boosted based on the region_code provided.
            #   @param facet_specs [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::FacetSpec, ::Hash>]
            #     Facet specifications for faceted search. If empty, no facets are returned.
            #
            #     A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
            #     error is returned.
            #   @param boost_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::BoostSpec, ::Hash]
            #     Boost specification to boost certain documents.
            #     For more information on boosting, see
            #     [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
            #   @param params [::Hash{::String => ::Google::Protobuf::Value, ::Hash}]
            #     Additional search parameters.
            #
            #     For public website search only, supported values are:
            #
            #     * `user_country_code`: string. Default empty. If set to non-empty, results
            #        are restricted or boosted based on the location provided.
            #        For example, `user_country_code: "au"`
            #
            #        For available codes see [Country
            #        Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
            #
            #     * `search_type`: double. Default empty. Enables non-webpage searching
            #        depending on the value. The only valid non-default value is 1,
            #        which enables image searching.
            #        For example, `search_type: 1`
            #   @param query_expansion_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::QueryExpansionSpec, ::Hash]
            #     The query expansion specification that specifies the conditions under which
            #     query expansion occurs.
            #   @param spell_correction_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SpellCorrectionSpec, ::Hash]
            #     The spell correction specification that specifies the mode under
            #     which spell correction takes effect.
            #   @param user_pseudo_id [::String]
            #     A unique identifier for tracking visitors. For example, this could be
            #     implemented with an HTTP cookie, which should be able to uniquely identify
            #     a visitor on a single device. This unique identifier should not change if
            #     the visitor logs in or out of the website.
            #
            #     This field should NOT have a fixed value such as `unknown_visitor`.
            #
            #     This should be the same identifier as
            #     {::Google::Cloud::DiscoveryEngine::V1beta::UserEvent#user_pseudo_id UserEvent.user_pseudo_id}
            #     and
            #     {::Google::Cloud::DiscoveryEngine::V1beta::CompleteQueryRequest#user_pseudo_id CompleteQueryRequest.user_pseudo_id}
            #
            #     The field must be a UTF-8 encoded string with a length limit of 128
            #     characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
            #   @param content_search_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec, ::Hash]
            #     A specification for configuring the behavior of content search.
            #   @param embedding_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec, ::Hash]
            #     Uses the provided embedding to do additional semantic document retrieval.
            #     The retrieval is based on the dot product of
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec::EmbeddingVector#vector SearchRequest.EmbeddingSpec.EmbeddingVector.vector}
            #     and the document embedding that is provided in
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec::EmbeddingVector#field_path SearchRequest.EmbeddingSpec.EmbeddingVector.field_path}.
            #
            #     If
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec::EmbeddingVector#field_path SearchRequest.EmbeddingSpec.EmbeddingVector.field_path}
            #     is not provided, it will use
            #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#embedding_config ServingConfig.EmbeddingConfig.field_path}.
            #   @param ranking_expression [::String]
            #     The ranking expression controls the customized ranking on retrieval
            #     documents. This overrides
            #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#ranking_expression ServingConfig.ranking_expression}.
            #     The syntax and supported features depend on the
            #     `ranking_expression_backend` value. If `ranking_expression_backend` is not
            #     provided, it defaults to `RANK_BY_EMBEDDING`.
            #
            #     If
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#ranking_expression_backend ranking_expression_backend}
            #     is not provided or set to `RANK_BY_EMBEDDING`, it should be a single
            #     function or multiple functions that are joined by "+".
            #
            #       * ranking_expression = function, { " + ", function };
            #
            #     Supported functions:
            #
            #       * double * relevance_score
            #       * double * dotProduct(embedding_field_path)
            #
            #     Function variables:
            #
            #       * `relevance_score`: pre-defined keywords, used for measure relevance
            #       between query and document.
            #       * `embedding_field_path`: the document embedding field
            #       used with query embedding vector.
            #       * `dotProduct`: embedding function between `embedding_field_path` and
            #       query embedding vector.
            #
            #      Example ranking expression:
            #
            #        If document has an embedding field doc_embedding, the ranking expression
            #        could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
            #
            #     If
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#ranking_expression_backend ranking_expression_backend}
            #     is set to `RANK_BY_FORMULA`, the following expression types (and
            #     combinations of those chained using + or
            #     * operators) are supported:
            #
            #       * `double`
            #       * `signal`
            #       * `log(signal)`
            #       * `exp(signal)`
            #       * `rr(signal, double > 0)`  -- reciprocal rank transformation with second
            #       argument being a denominator constant.
            #       * `is_nan(signal)` -- returns 0 if signal is NaN, 1 otherwise.
            #       * `fill_nan(signal1, signal2 | double)` -- if signal1 is NaN, returns
            #       signal2 | double, else returns signal1.
            #
            #       Here are a few examples of ranking formulas that use the supported
            #       ranking expression types:
            #
            #       - `0.2 * semantic_similarity_score + 0.8 * log(keyword_similarity_score)`
            #       -- mostly rank by the logarithm of `keyword_similarity_score` with slight
            #       `semantic_smilarity_score` adjustment.
            #       - `0.2 * exp(fill_nan(semantic_similarity_score, 0)) + 0.3 *
            #       is_nan(keyword_similarity_score)` -- rank by the exponent of
            #       `semantic_similarity_score` filling the value with 0 if it's NaN, also
            #       add constant 0.3 adjustment to the final score if
            #       `semantic_similarity_score` is NaN.
            #       - `0.2 * rr(semantic_similarity_score, 16) + 0.8 *
            #       rr(keyword_similarity_score, 16)` -- mostly rank by the reciprocal rank
            #       of `keyword_similarity_score` with slight adjustment of reciprocal rank
            #       of `semantic_smilarity_score`.
            #
            #     The following signals are supported:
            #
            #       * `semantic_similarity_score`: semantic similarity adjustment that is
            #       calculated using the embeddings generated by a proprietary Google model.
            #       This score determines how semantically similar a search query is to a
            #       document.
            #       * `keyword_similarity_score`: keyword match adjustment uses the Best
            #       Match 25 (BM25) ranking function. This score is calculated using a
            #       probabilistic model to estimate the probability that a document is
            #       relevant to a given query.
            #       * `relevance_score`: semantic relevance adjustment that uses a
            #       proprietary Google model to determine the meaning and intent behind a
            #       user's query in context with the content in the documents.
            #       * `pctr_rank`: predicted conversion rate adjustment as a rank use
            #       predicted Click-through rate (pCTR) to gauge the relevance and
            #       attractiveness of a search result from a user's perspective. A higher
            #       pCTR suggests that the result is more likely to satisfy the user's query
            #       and intent, making it a valuable signal for ranking.
            #       * `freshness_rank`: freshness adjustment as a rank
            #       * `document_age`: The time in hours elapsed since the document was last
            #       updated, a floating-point number (e.g., 0.25 means 15 minutes).
            #       * `topicality_rank`: topicality adjustment as a rank. Uses proprietary
            #       Google model to determine the keyword-based overlap between the query and
            #       the document.
            #       * `base_rank`: the default rank of the result
            #   @param ranking_expression_backend [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::RankingExpressionBackend]
            #     The backend to use for the ranking expression evaluation.
            #   @param safe_search [::Boolean]
            #     Whether to turn on safe search. This is only supported for
            #     website search.
            #   @param user_labels [::Hash{::String => ::String}]
            #     The user labels applied to a resource must meet the following requirements:
            #
            #     * Each resource can have multiple labels, up to a maximum of 64.
            #     * Each label must be a key-value pair.
            #     * Keys have a minimum length of 1 character and a maximum length of 63
            #       characters and cannot be empty. Values can be empty and have a maximum
            #       length of 63 characters.
            #     * Keys and values can contain only lowercase letters, numeric characters,
            #       underscores, and dashes. All characters must use UTF-8 encoding, and
            #       international characters are allowed.
            #     * The key portion of a label must be unique. However, you can use the same
            #       key with multiple resources.
            #     * Keys must start with a lowercase letter or international character.
            #
            #     See [Google Cloud
            #     Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
            #     for more details.
            #   @param natural_language_query_understanding_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::NaturalLanguageQueryUnderstandingSpec, ::Hash]
            #     If `naturalLanguageQueryUnderstandingSpec` is not specified, no additional
            #     natural language query understanding will be done.
            #   @param search_as_you_type_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SearchAsYouTypeSpec, ::Hash]
            #     Search as you type configuration. Only supported for the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::IndustryVertical::MEDIA IndustryVertical.MEDIA}
            #     vertical.
            #   @param session [::String]
            #     The session resource name. Optional.
            #
            #     Session allows users to do multi-turn /search API calls or coordination
            #     between /search API calls and /answer API calls.
            #
            #     Example #1 (multi-turn /search API calls):
            #       Call /search API with the session ID generated in the first call.
            #       Here, the previous search query gets considered in query
            #       standing. I.e., if the first query is "How did Alphabet do in 2022?"
            #       and the current query is "How about 2023?", the current query will
            #       be interpreted as "How did Alphabet do in 2023?".
            #
            #     Example #2 (coordination between /search API calls and /answer API calls):
            #       Call /answer API with the session ID generated in the first call.
            #       Here, the answer generation happens in the context of the search
            #       results from the first search call.
            #
            #     Multi-turn Search feature is currently at private GA stage. Please use
            #     v1alpha or v1beta version instead before we launch this feature to public
            #     GA. Or ask for allowlisting through Google Support team.
            #   @param session_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SessionSpec, ::Hash]
            #     Session specification.
            #
            #     Can be used only when `session` is set.
            #   @param relevance_threshold [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::RelevanceThreshold]
            #     The relevance threshold of the search results.
            #
            #     Default to Google defined threshold, leveraging a balance of
            #     precision and recall to deliver both highly accurate results and
            #     comprehensive coverage of relevant information.
            #   @param personalization_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::PersonalizationSpec, ::Hash]
            #     The specification for personalization.
            #
            #     Notice that if both
            #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#personalization_spec ServingConfig.personalization_spec}
            #     and
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#personalization_spec SearchRequest.personalization_spec}
            #     are set,
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#personalization_spec SearchRequest.personalization_spec}
            #     overrides
            #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#personalization_spec ServingConfig.personalization_spec}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SearchResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SearchResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::SearchRequest.new
            #
            #   # Call the search method.
            #   result = client.search request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SearchResult.
            #     p item
            #   end
            #
            def search request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.serving_config
                header_params["serving_config"] = request.serving_config
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @search_service_stub.call_rpc :search, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @search_service_stub, :search, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Performs a search. Similar to the
            # {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
            # method, but a lite version that allows API key for authentication, where
            # OAuth and IAM checks are not required.
            #
            # Only public website search is supported by this method. If data stores and
            # engines not associated with public website search are specified, a
            # `FAILED_PRECONDITION` error is returned.
            #
            # This method can be used for easy onboarding without having to implement an
            # authentication backend. However, it is strongly recommended to use
            # {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
            # instead with required OAuth and IAM checks to provide better data security.
            #
            # @overload search_lite(request, options = nil)
            #   Pass arguments to `search_lite` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_lite(serving_config: nil, branch: nil, query: nil, image_query: nil, page_size: nil, page_token: nil, offset: nil, one_box_page_size: nil, data_store_specs: nil, filter: nil, canonical_filter: nil, order_by: nil, user_info: nil, language_code: nil, region_code: nil, facet_specs: nil, boost_spec: nil, params: nil, query_expansion_spec: nil, spell_correction_spec: nil, user_pseudo_id: nil, content_search_spec: nil, embedding_spec: nil, ranking_expression: nil, ranking_expression_backend: nil, safe_search: nil, user_labels: nil, natural_language_query_understanding_spec: nil, search_as_you_type_spec: nil, session: nil, session_spec: nil, relevance_threshold: nil, personalization_spec: nil)
            #   Pass arguments to `search_lite` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param serving_config [::String]
            #     Required. The resource name of the Search serving config, such as
            #     `projects/*/locations/global/collections/default_collection/engines/*/servingConfigs/default_serving_config`,
            #     or
            #     `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
            #     This field is used to identify the serving configuration name, set
            #     of models used to make the search.
            #   @param branch [::String]
            #     The branch resource name, such as
            #     `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
            #
            #     Use `default_branch` as the branch ID or leave this field empty, to search
            #     documents under the default branch.
            #   @param query [::String]
            #     Raw search query.
            #   @param image_query [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ImageQuery, ::Hash]
            #     Raw image query.
            #   @param page_size [::Integer]
            #     Maximum number of {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s
            #     to return. The maximum allowed value depends on the data type. Values above
            #     the maximum value are coerced to the maximum value.
            #
            #     * Websites with basic indexing: Default `10`, Maximum `25`.
            #     * Websites with advanced indexing: Default `25`, Maximum `50`.
            #     * Other: Default `50`, Maximum `100`.
            #
            #     If this field is negative, an  `INVALID_ARGUMENT` is returned.
            #   @param page_token [::String]
            #     A page token received from a previous
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client#search SearchService.Search}
            #     must match the call that provided the page token. Otherwise, an
            #      `INVALID_ARGUMENT`  error is returned.
            #   @param offset [::Integer]
            #     A 0-indexed integer that specifies the current offset (that is, starting
            #     result location, amongst the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s deemed by the API
            #     as relevant) in search results. This field is only considered if
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#page_token page_token}
            #     is unset.
            #
            #     If this field is negative, an  `INVALID_ARGUMENT`  is returned.
            #   @param one_box_page_size [::Integer]
            #     The maximum number of results to return for OneBox.
            #     This applies to each OneBox type individually.
            #     Default number is 10.
            #   @param data_store_specs [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::DataStoreSpec, ::Hash>]
            #     Specs defining dataStores to filter on in a search call and configurations
            #     for those dataStores. This is only considered for engines with multiple
            #     dataStores use case. For single dataStore within an engine, they should
            #     use the specs at the top level.
            #   @param filter [::String]
            #     The filter syntax consists of an expression language for constructing a
            #     predicate from one or more fields of the documents being filtered. Filter
            #     expression is case-sensitive.
            #
            #     If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
            #
            #     Filtering in Vertex AI Search is done by mapping the LHS filter key to a
            #     key property defined in the Vertex AI Search backend -- this mapping is
            #     defined by the customer in their schema. For example a media customer might
            #     have a field 'name' in their schema. In this case the filter would look
            #     like this: filter --> name:'ANY("king kong")'
            #
            #     For more information about filtering including syntax and filter
            #     operators, see
            #     [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
            #   @param canonical_filter [::String]
            #     The default filter that is applied when a user performs a search without
            #     checking any filters on the search page.
            #
            #     The filter applied to every search request when quality improvement such as
            #     query expansion is needed. In the case a query does not have a sufficient
            #     amount of results this filter will be used to determine whether or not to
            #     enable the query expansion flow. The original filter will still be used for
            #     the query expanded search.
            #     This field is strongly recommended to achieve high search quality.
            #
            #     For more information about filter syntax, see
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#filter SearchRequest.filter}.
            #   @param order_by [::String]
            #     The order in which documents are returned. Documents can be ordered by
            #     a field in an {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}
            #     object. Leave it unset if ordered by relevance. `order_by` expression is
            #     case-sensitive.
            #
            #     For more information on ordering the website search results, see
            #     [Order web search
            #     results](https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results).
            #     For more information on ordering the healthcare search results, see
            #     [Order healthcare search
            #     results](https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results).
            #     If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
            #   @param user_info [::Google::Cloud::DiscoveryEngine::V1beta::UserInfo, ::Hash]
            #     Information about the end user.
            #     Highly recommended for analytics.
            #     {::Google::Cloud::DiscoveryEngine::V1beta::UserInfo#user_agent UserInfo.user_agent}
            #     is used to deduce `device_type` for analytics.
            #   @param language_code [::String]
            #     The BCP-47 language code, such as "en-US" or "sr-Latn". For more
            #     information, see [Standard
            #     fields](https://cloud.google.com/apis/design/standard_fields). This field
            #     helps to better interpret the query. If a value isn't specified, the query
            #     language code is automatically detected, which may not be accurate.
            #   @param region_code [::String]
            #     The Unicode country/region code (CLDR) of a location, such as "US" and
            #     "419". For more information, see [Standard
            #     fields](https://cloud.google.com/apis/design/standard_fields). If set,
            #     then results will be boosted based on the region_code provided.
            #   @param facet_specs [::Array<::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::FacetSpec, ::Hash>]
            #     Facet specifications for faceted search. If empty, no facets are returned.
            #
            #     A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
            #     error is returned.
            #   @param boost_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::BoostSpec, ::Hash]
            #     Boost specification to boost certain documents.
            #     For more information on boosting, see
            #     [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
            #   @param params [::Hash{::String => ::Google::Protobuf::Value, ::Hash}]
            #     Additional search parameters.
            #
            #     For public website search only, supported values are:
            #
            #     * `user_country_code`: string. Default empty. If set to non-empty, results
            #        are restricted or boosted based on the location provided.
            #        For example, `user_country_code: "au"`
            #
            #        For available codes see [Country
            #        Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
            #
            #     * `search_type`: double. Default empty. Enables non-webpage searching
            #        depending on the value. The only valid non-default value is 1,
            #        which enables image searching.
            #        For example, `search_type: 1`
            #   @param query_expansion_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::QueryExpansionSpec, ::Hash]
            #     The query expansion specification that specifies the conditions under which
            #     query expansion occurs.
            #   @param spell_correction_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SpellCorrectionSpec, ::Hash]
            #     The spell correction specification that specifies the mode under
            #     which spell correction takes effect.
            #   @param user_pseudo_id [::String]
            #     A unique identifier for tracking visitors. For example, this could be
            #     implemented with an HTTP cookie, which should be able to uniquely identify
            #     a visitor on a single device. This unique identifier should not change if
            #     the visitor logs in or out of the website.
            #
            #     This field should NOT have a fixed value such as `unknown_visitor`.
            #
            #     This should be the same identifier as
            #     {::Google::Cloud::DiscoveryEngine::V1beta::UserEvent#user_pseudo_id UserEvent.user_pseudo_id}
            #     and
            #     {::Google::Cloud::DiscoveryEngine::V1beta::CompleteQueryRequest#user_pseudo_id CompleteQueryRequest.user_pseudo_id}
            #
            #     The field must be a UTF-8 encoded string with a length limit of 128
            #     characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
            #   @param content_search_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::ContentSearchSpec, ::Hash]
            #     A specification for configuring the behavior of content search.
            #   @param embedding_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec, ::Hash]
            #     Uses the provided embedding to do additional semantic document retrieval.
            #     The retrieval is based on the dot product of
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec::EmbeddingVector#vector SearchRequest.EmbeddingSpec.EmbeddingVector.vector}
            #     and the document embedding that is provided in
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec::EmbeddingVector#field_path SearchRequest.EmbeddingSpec.EmbeddingVector.field_path}.
            #
            #     If
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::EmbeddingSpec::EmbeddingVector#field_path SearchRequest.EmbeddingSpec.EmbeddingVector.field_path}
            #     is not provided, it will use
            #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#embedding_config ServingConfig.EmbeddingConfig.field_path}.
            #   @param ranking_expression [::String]
            #     The ranking expression controls the customized ranking on retrieval
            #     documents. This overrides
            #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#ranking_expression ServingConfig.ranking_expression}.
            #     The syntax and supported features depend on the
            #     `ranking_expression_backend` value. If `ranking_expression_backend` is not
            #     provided, it defaults to `RANK_BY_EMBEDDING`.
            #
            #     If
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#ranking_expression_backend ranking_expression_backend}
            #     is not provided or set to `RANK_BY_EMBEDDING`, it should be a single
            #     function or multiple functions that are joined by "+".
            #
            #       * ranking_expression = function, { " + ", function };
            #
            #     Supported functions:
            #
            #       * double * relevance_score
            #       * double * dotProduct(embedding_field_path)
            #
            #     Function variables:
            #
            #       * `relevance_score`: pre-defined keywords, used for measure relevance
            #       between query and document.
            #       * `embedding_field_path`: the document embedding field
            #       used with query embedding vector.
            #       * `dotProduct`: embedding function between `embedding_field_path` and
            #       query embedding vector.
            #
            #      Example ranking expression:
            #
            #        If document has an embedding field doc_embedding, the ranking expression
            #        could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
            #
            #     If
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#ranking_expression_backend ranking_expression_backend}
            #     is set to `RANK_BY_FORMULA`, the following expression types (and
            #     combinations of those chained using + or
            #     * operators) are supported:
            #
            #       * `double`
            #       * `signal`
            #       * `log(signal)`
            #       * `exp(signal)`
            #       * `rr(signal, double > 0)`  -- reciprocal rank transformation with second
            #       argument being a denominator constant.
            #       * `is_nan(signal)` -- returns 0 if signal is NaN, 1 otherwise.
            #       * `fill_nan(signal1, signal2 | double)` -- if signal1 is NaN, returns
            #       signal2 | double, else returns signal1.
            #
            #       Here are a few examples of ranking formulas that use the supported
            #       ranking expression types:
            #
            #       - `0.2 * semantic_similarity_score + 0.8 * log(keyword_similarity_score)`
            #       -- mostly rank by the logarithm of `keyword_similarity_score` with slight
            #       `semantic_smilarity_score` adjustment.
            #       - `0.2 * exp(fill_nan(semantic_similarity_score, 0)) + 0.3 *
            #       is_nan(keyword_similarity_score)` -- rank by the exponent of
            #       `semantic_similarity_score` filling the value with 0 if it's NaN, also
            #       add constant 0.3 adjustment to the final score if
            #       `semantic_similarity_score` is NaN.
            #       - `0.2 * rr(semantic_similarity_score, 16) + 0.8 *
            #       rr(keyword_similarity_score, 16)` -- mostly rank by the reciprocal rank
            #       of `keyword_similarity_score` with slight adjustment of reciprocal rank
            #       of `semantic_smilarity_score`.
            #
            #     The following signals are supported:
            #
            #       * `semantic_similarity_score`: semantic similarity adjustment that is
            #       calculated using the embeddings generated by a proprietary Google model.
            #       This score determines how semantically similar a search query is to a
            #       document.
            #       * `keyword_similarity_score`: keyword match adjustment uses the Best
            #       Match 25 (BM25) ranking function. This score is calculated using a
            #       probabilistic model to estimate the probability that a document is
            #       relevant to a given query.
            #       * `relevance_score`: semantic relevance adjustment that uses a
            #       proprietary Google model to determine the meaning and intent behind a
            #       user's query in context with the content in the documents.
            #       * `pctr_rank`: predicted conversion rate adjustment as a rank use
            #       predicted Click-through rate (pCTR) to gauge the relevance and
            #       attractiveness of a search result from a user's perspective. A higher
            #       pCTR suggests that the result is more likely to satisfy the user's query
            #       and intent, making it a valuable signal for ranking.
            #       * `freshness_rank`: freshness adjustment as a rank
            #       * `document_age`: The time in hours elapsed since the document was last
            #       updated, a floating-point number (e.g., 0.25 means 15 minutes).
            #       * `topicality_rank`: topicality adjustment as a rank. Uses proprietary
            #       Google model to determine the keyword-based overlap between the query and
            #       the document.
            #       * `base_rank`: the default rank of the result
            #   @param ranking_expression_backend [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::RankingExpressionBackend]
            #     The backend to use for the ranking expression evaluation.
            #   @param safe_search [::Boolean]
            #     Whether to turn on safe search. This is only supported for
            #     website search.
            #   @param user_labels [::Hash{::String => ::String}]
            #     The user labels applied to a resource must meet the following requirements:
            #
            #     * Each resource can have multiple labels, up to a maximum of 64.
            #     * Each label must be a key-value pair.
            #     * Keys have a minimum length of 1 character and a maximum length of 63
            #       characters and cannot be empty. Values can be empty and have a maximum
            #       length of 63 characters.
            #     * Keys and values can contain only lowercase letters, numeric characters,
            #       underscores, and dashes. All characters must use UTF-8 encoding, and
            #       international characters are allowed.
            #     * The key portion of a label must be unique. However, you can use the same
            #       key with multiple resources.
            #     * Keys must start with a lowercase letter or international character.
            #
            #     See [Google Cloud
            #     Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
            #     for more details.
            #   @param natural_language_query_understanding_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::NaturalLanguageQueryUnderstandingSpec, ::Hash]
            #     If `naturalLanguageQueryUnderstandingSpec` is not specified, no additional
            #     natural language query understanding will be done.
            #   @param search_as_you_type_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SearchAsYouTypeSpec, ::Hash]
            #     Search as you type configuration. Only supported for the
            #     {::Google::Cloud::DiscoveryEngine::V1beta::IndustryVertical::MEDIA IndustryVertical.MEDIA}
            #     vertical.
            #   @param session [::String]
            #     The session resource name. Optional.
            #
            #     Session allows users to do multi-turn /search API calls or coordination
            #     between /search API calls and /answer API calls.
            #
            #     Example #1 (multi-turn /search API calls):
            #       Call /search API with the session ID generated in the first call.
            #       Here, the previous search query gets considered in query
            #       standing. I.e., if the first query is "How did Alphabet do in 2022?"
            #       and the current query is "How about 2023?", the current query will
            #       be interpreted as "How did Alphabet do in 2023?".
            #
            #     Example #2 (coordination between /search API calls and /answer API calls):
            #       Call /answer API with the session ID generated in the first call.
            #       Here, the answer generation happens in the context of the search
            #       results from the first search call.
            #
            #     Multi-turn Search feature is currently at private GA stage. Please use
            #     v1alpha or v1beta version instead before we launch this feature to public
            #     GA. Or ask for allowlisting through Google Support team.
            #   @param session_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::SessionSpec, ::Hash]
            #     Session specification.
            #
            #     Can be used only when `session` is set.
            #   @param relevance_threshold [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::RelevanceThreshold]
            #     The relevance threshold of the search results.
            #
            #     Default to Google defined threshold, leveraging a balance of
            #     precision and recall to deliver both highly accurate results and
            #     comprehensive coverage of relevant information.
            #   @param personalization_spec [::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest::PersonalizationSpec, ::Hash]
            #     The specification for personalization.
            #
            #     Notice that if both
            #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#personalization_spec ServingConfig.personalization_spec}
            #     and
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#personalization_spec SearchRequest.personalization_spec}
            #     are set,
            #     {::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest#personalization_spec SearchRequest.personalization_spec}
            #     overrides
            #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#personalization_spec ServingConfig.personalization_spec}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SearchResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SearchResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1beta::SearchRequest.new
            #
            #   # Call the search_lite method.
            #   result = client.search_lite request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DiscoveryEngine::V1beta::SearchResponse::SearchResult.
            #     p item
            #   end
            #
            def search_lite request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::SearchRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_lite.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.serving_config
                header_params["serving_config"] = request.serving_config
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_lite.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_lite.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @search_service_stub.call_rpc :search_lite, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @search_service_stub, :search_lite, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the SearchService API.
            #
            # This class represents the configuration for SearchService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # search to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.search.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.search.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::DiscoveryEngine::V1beta::SearchService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "discoveryengine.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the SearchService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `search`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search
                ##
                # RPC-specific configuration for `search_lite`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_lite

                # @private
                def initialize parent_rpcs = nil
                  search_config = parent_rpcs.search if parent_rpcs.respond_to? :search
                  @search = ::Gapic::Config::Method.new search_config
                  search_lite_config = parent_rpcs.search_lite if parent_rpcs.respond_to? :search_lite
                  @search_lite = ::Gapic::Config::Method.new search_lite_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
