# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/discoveryengine/v1beta/sample_query_service_pb"
require "google/cloud/discovery_engine/v1beta/sample_query_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        module SampleQueryService
          module Rest
            ##
            # REST client for the SampleQueryService service.
            #
            # Service for managing
            # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}s,
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "discoveryengine.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :sample_query_service_stub

              ##
              # Configure the SampleQueryService Client class.
              #
              # See {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all SampleQueryService clients
              #   ::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "DiscoveryEngine", "V1beta"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 30.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the SampleQueryService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @sample_query_service_stub.universe_domain
              end

              ##
              # Create a new SampleQueryService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the SampleQueryService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @sample_query_service_stub = ::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @sample_query_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @sample_query_service_stub.endpoint
                  config.universe_domain = @sample_query_service_stub.universe_domain
                  config.logger = @sample_query_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @sample_query_service_stub.logger
              end

              # Service calls

              ##
              # Gets a {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}.
              #
              # @overload get_sample_query(request, options = nil)
              #   Pass arguments to `get_sample_query` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::GetSampleQueryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::GetSampleQueryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_sample_query(name: nil)
              #   Pass arguments to `get_sample_query` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Full resource name of
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, such as
              #     `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
              #
              #     If the caller does not have permission to access the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, regardless
              #     of whether or not it exists, a PERMISSION_DENIED error is returned.
              #
              #     If the requested
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery} does not
              #     exist, a NOT_FOUND error is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::GetSampleQueryRequest.new
              #
              #   # Call the get_sample_query method.
              #   result = client.get_sample_query request
              #
              #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1beta::SampleQuery.
              #   p result
              #
              def get_sample_query request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::GetSampleQueryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_sample_query.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_sample_query.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_sample_query.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @sample_query_service_stub.get_sample_query request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a list of
              # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}s.
              #
              # @overload list_sample_queries(request, options = nil)
              #   Pass arguments to `list_sample_queries` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::ListSampleQueriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::ListSampleQueriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_sample_queries(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_sample_queries` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent sample query set resource name, such as
              #     `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
              #
              #     If the caller does not have permission to list
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}s under this
              #     sample query set, regardless of whether or not this sample query set
              #     exists, a `PERMISSION_DENIED` error is returned.
              #   @param page_size [::Integer]
              #     Maximum number of
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}s to return.
              #     If unspecified, defaults to 100. The maximum allowed value is 1000. Values
              #     above 1000 will be coerced to 1000.
              #
              #     If this field is negative, an `INVALID_ARGUMENT` error is returned.
              #   @param page_token [::String]
              #     A page token
              #     {::Google::Cloud::DiscoveryEngine::V1beta::ListSampleQueriesResponse#next_page_token ListSampleQueriesResponse.next_page_token},
              #     received from a previous
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client#list_sample_queries SampleQueryService.ListSampleQueries}
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client#list_sample_queries SampleQueryService.ListSampleQueries}
              #     must match the call that provided the page token. Otherwise, an
              #     `INVALID_ARGUMENT` error is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::ListSampleQueriesRequest.new
              #
              #   # Call the list_sample_queries method.
              #   result = client.list_sample_queries request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery.
              #     p item
              #   end
              #
              def list_sample_queries request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::ListSampleQueriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_sample_queries.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_sample_queries.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_sample_queries.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @sample_query_service_stub.list_sample_queries request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @sample_query_service_stub, :list_sample_queries, "sample_queries", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}
              #
              # @overload create_sample_query(request, options = nil)
              #   Pass arguments to `create_sample_query` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::CreateSampleQueryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::CreateSampleQueryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_sample_query(parent: nil, sample_query: nil, sample_query_id: nil)
              #   Pass arguments to `create_sample_query` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, such as
              #     `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
              #   @param sample_query [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery, ::Hash]
              #     Required. The
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery} to create.
              #   @param sample_query_id [::String]
              #     Required. The ID to use for the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, which will
              #     become the final component of the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery#name SampleQuery.name}.
              #
              #     If the caller does not have permission to create the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, regardless
              #     of whether or not it exists, a `PERMISSION_DENIED` error is returned.
              #
              #     This field must be unique among all
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}s with the
              #     same
              #     {::Google::Cloud::DiscoveryEngine::V1beta::CreateSampleQueryRequest#parent parent}.
              #     Otherwise, an `ALREADY_EXISTS` error is returned.
              #
              #     This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
              #     standard with a length limit of 63 characters. Otherwise, an
              #     `INVALID_ARGUMENT` error is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::CreateSampleQueryRequest.new
              #
              #   # Call the create_sample_query method.
              #   result = client.create_sample_query request
              #
              #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1beta::SampleQuery.
              #   p result
              #
              def create_sample_query request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::CreateSampleQueryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_sample_query.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_sample_query.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_sample_query.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @sample_query_service_stub.create_sample_query request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}.
              #
              # @overload update_sample_query(request, options = nil)
              #   Pass arguments to `update_sample_query` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::UpdateSampleQueryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::UpdateSampleQueryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_sample_query(sample_query: nil, update_mask: nil)
              #   Pass arguments to `update_sample_query` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param sample_query [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery, ::Hash]
              #     Required. The simple query to update.
              #
              #     If the caller does not have permission to update the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, regardless
              #     of whether or not it exists, a `PERMISSION_DENIED` error is returned.
              #
              #     If the {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery} to
              #     update does not exist a `NOT_FOUND` error is returned.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Indicates which fields in the provided imported 'simple query' to update.
              #     If not set, will by default update all fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::UpdateSampleQueryRequest.new
              #
              #   # Call the update_sample_query method.
              #   result = client.update_sample_query request
              #
              #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1beta::SampleQuery.
              #   p result
              #
              def update_sample_query request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::UpdateSampleQueryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_sample_query.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_sample_query.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_sample_query.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @sample_query_service_stub.update_sample_query request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}.
              #
              # @overload delete_sample_query(request, options = nil)
              #   Pass arguments to `delete_sample_query` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::DeleteSampleQueryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::DeleteSampleQueryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_sample_query(name: nil)
              #   Pass arguments to `delete_sample_query` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Full resource name of
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, such as
              #     `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
              #
              #     If the caller does not have permission to delete the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}, regardless
              #     of whether or not it exists, a `PERMISSION_DENIED` error is returned.
              #
              #     If the {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery} to
              #     delete does not exist, a `NOT_FOUND` error is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::DeleteSampleQueryRequest.new
              #
              #   # Call the delete_sample_query method.
              #   result = client.delete_sample_query request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_sample_query request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::DeleteSampleQueryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_sample_query.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_sample_query.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_sample_query.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @sample_query_service_stub.delete_sample_query request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Bulk import of multiple
              # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}s. Sample
              # queries that already exist may be deleted.
              #
              # Note: It is possible for a subset of the
              # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}s to be
              # successfully imported.
              #
              # @overload import_sample_queries(request, options = nil)
              #   Pass arguments to `import_sample_queries` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::ImportSampleQueriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::ImportSampleQueriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_sample_queries(inline_source: nil, gcs_source: nil, bigquery_source: nil, parent: nil, error_config: nil)
              #   Pass arguments to `import_sample_queries` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param inline_source [::Google::Cloud::DiscoveryEngine::V1beta::ImportSampleQueriesRequest::InlineSource, ::Hash]
              #     The Inline source for sample query entries.
              #
              #     Note: The following parameters are mutually exclusive: `inline_source`, `gcs_source`, `bigquery_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param gcs_source [::Google::Cloud::DiscoveryEngine::V1beta::GcsSource, ::Hash]
              #     Cloud Storage location for the input content.
              #
              #     Note: The following parameters are mutually exclusive: `gcs_source`, `inline_source`, `bigquery_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param bigquery_source [::Google::Cloud::DiscoveryEngine::V1beta::BigQuerySource, ::Hash]
              #     BigQuery input source.
              #
              #     Note: The following parameters are mutually exclusive: `bigquery_source`, `inline_source`, `gcs_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. The parent sample query set resource name, such as
              #     `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
              #
              #     If the caller does not have permission to list
              #     {::Google::Cloud::DiscoveryEngine::V1beta::SampleQuery SampleQuery}s under this
              #     sample query set, regardless of whether or not this sample query set
              #     exists, a `PERMISSION_DENIED` error is returned.
              #   @param error_config [::Google::Cloud::DiscoveryEngine::V1beta::ImportErrorConfig, ::Hash]
              #     The desired location of errors incurred during the Import.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::ImportSampleQueriesRequest.new
              #
              #   # Call the import_sample_queries method.
              #   result = client.import_sample_queries request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_sample_queries request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::ImportSampleQueriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_sample_queries.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_sample_queries.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_sample_queries.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @sample_query_service_stub.import_sample_queries request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the SampleQueryService REST API.
              #
              # This class represents the configuration for SampleQueryService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_sample_query to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_sample_query.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::DiscoveryEngine::V1beta::SampleQueryService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_sample_query.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "discoveryengine.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the SampleQueryService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_sample_query`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_sample_query
                  ##
                  # RPC-specific configuration for `list_sample_queries`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_sample_queries
                  ##
                  # RPC-specific configuration for `create_sample_query`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_sample_query
                  ##
                  # RPC-specific configuration for `update_sample_query`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_sample_query
                  ##
                  # RPC-specific configuration for `delete_sample_query`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_sample_query
                  ##
                  # RPC-specific configuration for `import_sample_queries`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_sample_queries

                  # @private
                  def initialize parent_rpcs = nil
                    get_sample_query_config = parent_rpcs.get_sample_query if parent_rpcs.respond_to? :get_sample_query
                    @get_sample_query = ::Gapic::Config::Method.new get_sample_query_config
                    list_sample_queries_config = parent_rpcs.list_sample_queries if parent_rpcs.respond_to? :list_sample_queries
                    @list_sample_queries = ::Gapic::Config::Method.new list_sample_queries_config
                    create_sample_query_config = parent_rpcs.create_sample_query if parent_rpcs.respond_to? :create_sample_query
                    @create_sample_query = ::Gapic::Config::Method.new create_sample_query_config
                    update_sample_query_config = parent_rpcs.update_sample_query if parent_rpcs.respond_to? :update_sample_query
                    @update_sample_query = ::Gapic::Config::Method.new update_sample_query_config
                    delete_sample_query_config = parent_rpcs.delete_sample_query if parent_rpcs.respond_to? :delete_sample_query
                    @delete_sample_query = ::Gapic::Config::Method.new delete_sample_query_config
                    import_sample_queries_config = parent_rpcs.import_sample_queries if parent_rpcs.respond_to? :import_sample_queries
                    @import_sample_queries = ::Gapic::Config::Method.new import_sample_queries_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
