# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        module SampleQueryService
          # Path helper methods for the SampleQueryService API.
          module Paths
            ##
            # Create a fully-qualified SampleQuery resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`
            #
            # @param project [String]
            # @param location [String]
            # @param sample_query_set [String]
            # @param sample_query [String]
            #
            # @return [::String]
            def sample_query_path project:, location:, sample_query_set:, sample_query:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "sample_query_set cannot contain /" if sample_query_set.to_s.include? "/"

              "projects/#{project}/locations/#{location}/sampleQuerySets/#{sample_query_set}/sampleQueries/#{sample_query}"
            end

            ##
            # Create a fully-qualified SampleQuerySet resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}`
            #
            # @param project [String]
            # @param location [String]
            # @param sample_query_set [String]
            #
            # @return [::String]
            def sample_query_set_path project:, location:, sample_query_set:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/sampleQuerySets/#{sample_query_set}"
            end

            extend self
          end
        end
      end
    end
  end
end
