# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/discoveryengine/v1beta/document_service_pb"
require "google/cloud/discovery_engine/v1beta/document_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        module DocumentService
          module Rest
            ##
            # REST client for the DocumentService service.
            #
            # Service for ingesting
            # {::Google::Cloud::DiscoveryEngine::V1beta::Document Document} information of the
            # customer's website.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "discoveryengine.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :document_service_stub

              ##
              # Configure the DocumentService Client class.
              #
              # See {::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all DocumentService clients
              #   ::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "DiscoveryEngine", "V1beta"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 30.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.import_documents.timeout = 300.0
                  default_config.rpcs.import_documents.retry_policy = {
                    initial_delay: 1.0, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DocumentService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @document_service_stub.universe_domain
              end

              ##
              # Create a new DocumentService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DocumentService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @document_service_stub = ::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @document_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @document_service_stub.endpoint
                  config.universe_domain = @document_service_stub.universe_domain
                  config.logger = @document_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @document_service_stub.logger
              end

              # Service calls

              ##
              # Gets a {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}.
              #
              # @overload get_document(request, options = nil)
              #   Pass arguments to `get_document` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::GetDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::GetDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_document(name: nil)
              #   Pass arguments to `get_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Full resource name of
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}, such as
              #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`.
              #
              #     If the caller does not have permission to access the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}, regardless of
              #     whether or not it exists, a `PERMISSION_DENIED` error is returned.
              #
              #     If the requested {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}
              #     does not exist, a `NOT_FOUND` error is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DiscoveryEngine::V1beta::Document]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1beta::Document]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::GetDocumentRequest.new
              #
              #   # Call the get_document method.
              #   result = client.get_document request
              #
              #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1beta::Document.
              #   p result
              #
              def get_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::GetDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.get_document request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a list of {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s.
              #
              # @overload list_documents(request, options = nil)
              #   Pass arguments to `list_documents` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::ListDocumentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::ListDocumentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_documents(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_documents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent branch resource name, such as
              #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
              #     Use `default_branch` as the branch ID, to list documents under the default
              #     branch.
              #
              #     If the caller does not have permission to list
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s under this
              #     branch, regardless of whether or not this branch exists, a
              #     `PERMISSION_DENIED` error is returned.
              #   @param page_size [::Integer]
              #     Maximum number of {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s
              #     to return. If unspecified, defaults to 100. The maximum allowed value is
              #     1000. Values above 1000 are set to 1000.
              #
              #     If this field is negative, an `INVALID_ARGUMENT` error is returned.
              #   @param page_token [::String]
              #     A page token
              #     {::Google::Cloud::DiscoveryEngine::V1beta::ListDocumentsResponse#next_page_token ListDocumentsResponse.next_page_token},
              #     received from a previous
              #     {::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client#list_documents DocumentService.ListDocuments}
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     {::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client#list_documents DocumentService.ListDocuments}
              #     must match the call that provided the page token. Otherwise, an
              #     `INVALID_ARGUMENT` error is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1beta::Document>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1beta::Document>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::ListDocumentsRequest.new
              #
              #   # Call the list_documents method.
              #   result = client.list_documents request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DiscoveryEngine::V1beta::Document.
              #     p item
              #   end
              #
              def list_documents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::ListDocumentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_documents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_documents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_documents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.list_documents request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @document_service_stub, :list_documents, "documents", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}.
              #
              # @overload create_document(request, options = nil)
              #   Pass arguments to `create_document` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::CreateDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::CreateDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_document(parent: nil, document: nil, document_id: nil)
              #   Pass arguments to `create_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, such as
              #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
              #   @param document [::Google::Cloud::DiscoveryEngine::V1beta::Document, ::Hash]
              #     Required. The {::Google::Cloud::DiscoveryEngine::V1beta::Document Document} to
              #     create.
              #   @param document_id [::String]
              #     Required. The ID to use for the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}, which becomes the
              #     final component of the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document#name Document.name}.
              #
              #     If the caller does not have permission to create the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}, regardless of
              #     whether or not it exists, a `PERMISSION_DENIED` error is returned.
              #
              #     This field must be unique among all
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s with the same
              #     {::Google::Cloud::DiscoveryEngine::V1beta::CreateDocumentRequest#parent parent}.
              #     Otherwise, an `ALREADY_EXISTS` error is returned.
              #
              #     This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
              #     standard with a length limit of 63 characters. Otherwise, an
              #     `INVALID_ARGUMENT` error is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DiscoveryEngine::V1beta::Document]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1beta::Document]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::CreateDocumentRequest.new
              #
              #   # Call the create_document method.
              #   result = client.create_document request
              #
              #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1beta::Document.
              #   p result
              #
              def create_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::CreateDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.create_document request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}.
              #
              # @overload update_document(request, options = nil)
              #   Pass arguments to `update_document` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::UpdateDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::UpdateDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_document(document: nil, allow_missing: nil, update_mask: nil)
              #   Pass arguments to `update_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param document [::Google::Cloud::DiscoveryEngine::V1beta::Document, ::Hash]
              #     Required. The document to update/create.
              #
              #     If the caller does not have permission to update the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}, regardless of
              #     whether or not it exists, a `PERMISSION_DENIED` error is returned.
              #
              #     If the {::Google::Cloud::DiscoveryEngine::V1beta::Document Document} to update
              #     does not exist and
              #     {::Google::Cloud::DiscoveryEngine::V1beta::UpdateDocumentRequest#allow_missing allow_missing}
              #     is not set, a `NOT_FOUND` error is returned.
              #   @param allow_missing [::Boolean]
              #     If set to `true` and the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document} is not found, a
              #     new {::Google::Cloud::DiscoveryEngine::V1beta::Document Document} is be created.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Indicates which fields in the provided imported 'document' to update. If
              #     not set, by default updates all fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DiscoveryEngine::V1beta::Document]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1beta::Document]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::UpdateDocumentRequest.new
              #
              #   # Call the update_document method.
              #   result = client.update_document request
              #
              #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1beta::Document.
              #   p result
              #
              def update_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::UpdateDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.update_document request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}.
              #
              # @overload delete_document(request, options = nil)
              #   Pass arguments to `delete_document` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::DeleteDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::DeleteDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_document(name: nil)
              #   Pass arguments to `delete_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Full resource name of
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}, such as
              #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`.
              #
              #     If the caller does not have permission to delete the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}, regardless of
              #     whether or not it exists, a `PERMISSION_DENIED` error is returned.
              #
              #     If the {::Google::Cloud::DiscoveryEngine::V1beta::Document Document} to delete
              #     does not exist, a `NOT_FOUND` error is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::DeleteDocumentRequest.new
              #
              #   # Call the delete_document method.
              #   result = client.delete_document request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::DeleteDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.delete_document request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Bulk import of multiple
              # {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s. Request
              # processing may be synchronous. Non-existing items are created.
              #
              # Note: It is possible for a subset of the
              # {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s to be
              # successfully updated.
              #
              # @overload import_documents(request, options = nil)
              #   Pass arguments to `import_documents` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::ImportDocumentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::ImportDocumentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_documents(inline_source: nil, gcs_source: nil, bigquery_source: nil, fhir_store_source: nil, spanner_source: nil, cloud_sql_source: nil, firestore_source: nil, alloy_db_source: nil, bigtable_source: nil, parent: nil, error_config: nil, reconciliation_mode: nil, update_mask: nil, auto_generate_ids: nil, id_field: nil)
              #   Pass arguments to `import_documents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param inline_source [::Google::Cloud::DiscoveryEngine::V1beta::ImportDocumentsRequest::InlineSource, ::Hash]
              #     The Inline source for the input content for documents.
              #
              #     Note: The following parameters are mutually exclusive: `inline_source`, `gcs_source`, `bigquery_source`, `fhir_store_source`, `spanner_source`, `cloud_sql_source`, `firestore_source`, `alloy_db_source`, `bigtable_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param gcs_source [::Google::Cloud::DiscoveryEngine::V1beta::GcsSource, ::Hash]
              #     Cloud Storage location for the input content.
              #
              #     Note: The following parameters are mutually exclusive: `gcs_source`, `inline_source`, `bigquery_source`, `fhir_store_source`, `spanner_source`, `cloud_sql_source`, `firestore_source`, `alloy_db_source`, `bigtable_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param bigquery_source [::Google::Cloud::DiscoveryEngine::V1beta::BigQuerySource, ::Hash]
              #     BigQuery input source.
              #
              #     Note: The following parameters are mutually exclusive: `bigquery_source`, `inline_source`, `gcs_source`, `fhir_store_source`, `spanner_source`, `cloud_sql_source`, `firestore_source`, `alloy_db_source`, `bigtable_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param fhir_store_source [::Google::Cloud::DiscoveryEngine::V1beta::FhirStoreSource, ::Hash]
              #     FhirStore input source.
              #
              #     Note: The following parameters are mutually exclusive: `fhir_store_source`, `inline_source`, `gcs_source`, `bigquery_source`, `spanner_source`, `cloud_sql_source`, `firestore_source`, `alloy_db_source`, `bigtable_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param spanner_source [::Google::Cloud::DiscoveryEngine::V1beta::SpannerSource, ::Hash]
              #     Spanner input source.
              #
              #     Note: The following parameters are mutually exclusive: `spanner_source`, `inline_source`, `gcs_source`, `bigquery_source`, `fhir_store_source`, `cloud_sql_source`, `firestore_source`, `alloy_db_source`, `bigtable_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param cloud_sql_source [::Google::Cloud::DiscoveryEngine::V1beta::CloudSqlSource, ::Hash]
              #     Cloud SQL input source.
              #
              #     Note: The following parameters are mutually exclusive: `cloud_sql_source`, `inline_source`, `gcs_source`, `bigquery_source`, `fhir_store_source`, `spanner_source`, `firestore_source`, `alloy_db_source`, `bigtable_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param firestore_source [::Google::Cloud::DiscoveryEngine::V1beta::FirestoreSource, ::Hash]
              #     Firestore input source.
              #
              #     Note: The following parameters are mutually exclusive: `firestore_source`, `inline_source`, `gcs_source`, `bigquery_source`, `fhir_store_source`, `spanner_source`, `cloud_sql_source`, `alloy_db_source`, `bigtable_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param alloy_db_source [::Google::Cloud::DiscoveryEngine::V1beta::AlloyDbSource, ::Hash]
              #     AlloyDB input source.
              #
              #     Note: The following parameters are mutually exclusive: `alloy_db_source`, `inline_source`, `gcs_source`, `bigquery_source`, `fhir_store_source`, `spanner_source`, `cloud_sql_source`, `firestore_source`, `bigtable_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param bigtable_source [::Google::Cloud::DiscoveryEngine::V1beta::BigtableSource, ::Hash]
              #     Cloud Bigtable input source.
              #
              #     Note: The following parameters are mutually exclusive: `bigtable_source`, `inline_source`, `gcs_source`, `bigquery_source`, `fhir_store_source`, `spanner_source`, `cloud_sql_source`, `firestore_source`, `alloy_db_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. The parent branch resource name, such as
              #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
              #     Requires create/update permission.
              #   @param error_config [::Google::Cloud::DiscoveryEngine::V1beta::ImportErrorConfig, ::Hash]
              #     The desired location of errors incurred during the Import.
              #   @param reconciliation_mode [::Google::Cloud::DiscoveryEngine::V1beta::ImportDocumentsRequest::ReconciliationMode]
              #     The mode of reconciliation between existing documents and the documents to
              #     be imported. Defaults to
              #     {::Google::Cloud::DiscoveryEngine::V1beta::ImportDocumentsRequest::ReconciliationMode::INCREMENTAL ReconciliationMode.INCREMENTAL}.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Indicates which fields in the provided imported documents to update. If
              #     not set, the default is to update all fields.
              #   @param auto_generate_ids [::Boolean]
              #     Whether to automatically generate IDs for the documents if absent.
              #
              #     If set to `true`,
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document#id Document.id}s are
              #     automatically generated based on the hash of the payload, where IDs may not
              #     be consistent during multiple imports. In which case
              #     {::Google::Cloud::DiscoveryEngine::V1beta::ImportDocumentsRequest::ReconciliationMode::FULL ReconciliationMode.FULL}
              #     is highly recommended to avoid duplicate contents. If unset or set to
              #     `false`, {::Google::Cloud::DiscoveryEngine::V1beta::Document#id Document.id}s
              #     have to be specified using
              #     {::Google::Cloud::DiscoveryEngine::V1beta::ImportDocumentsRequest#id_field id_field},
              #     otherwise, documents without IDs fail to be imported.
              #
              #     Supported data sources:
              #
              #     * {::Google::Cloud::DiscoveryEngine::V1beta::GcsSource GcsSource}.
              #     {::Google::Cloud::DiscoveryEngine::V1beta::GcsSource#data_schema GcsSource.data_schema}
              #     must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
              #     * {::Google::Cloud::DiscoveryEngine::V1beta::BigQuerySource BigQuerySource}.
              #     {::Google::Cloud::DiscoveryEngine::V1beta::BigQuerySource#data_schema BigQuerySource.data_schema}
              #     must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
              #     * {::Google::Cloud::DiscoveryEngine::V1beta::SpannerSource SpannerSource}.
              #     * {::Google::Cloud::DiscoveryEngine::V1beta::CloudSqlSource CloudSqlSource}.
              #     * {::Google::Cloud::DiscoveryEngine::V1beta::FirestoreSource FirestoreSource}.
              #     * {::Google::Cloud::DiscoveryEngine::V1beta::BigtableSource BigtableSource}.
              #   @param id_field [::String]
              #     The field indicates the ID field or column to be used as unique IDs of
              #     the documents.
              #
              #     For {::Google::Cloud::DiscoveryEngine::V1beta::GcsSource GcsSource} it is the
              #     key of the JSON field. For instance, `my_id` for JSON `{"my_id":
              #     "some_uuid"}`. For others, it may be the column name of the table where the
              #     unique ids are stored.
              #
              #     The values of the JSON field or the table column are used as the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document#id Document.id}s. The JSON
              #     field or the table column must be of string type, and the values must be
              #     set as valid strings conform to
              #     [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
              #     Otherwise, documents without valid IDs fail to be imported.
              #
              #     Only set this field when
              #     {::Google::Cloud::DiscoveryEngine::V1beta::ImportDocumentsRequest#auto_generate_ids auto_generate_ids}
              #     is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
              #
              #     If it is unset, a default value `_id` is used when importing from the
              #     allowed data sources.
              #
              #     Supported data sources:
              #
              #     * {::Google::Cloud::DiscoveryEngine::V1beta::GcsSource GcsSource}.
              #     {::Google::Cloud::DiscoveryEngine::V1beta::GcsSource#data_schema GcsSource.data_schema}
              #     must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
              #     * {::Google::Cloud::DiscoveryEngine::V1beta::BigQuerySource BigQuerySource}.
              #     {::Google::Cloud::DiscoveryEngine::V1beta::BigQuerySource#data_schema BigQuerySource.data_schema}
              #     must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
              #     * {::Google::Cloud::DiscoveryEngine::V1beta::SpannerSource SpannerSource}.
              #     * {::Google::Cloud::DiscoveryEngine::V1beta::CloudSqlSource CloudSqlSource}.
              #     * {::Google::Cloud::DiscoveryEngine::V1beta::FirestoreSource FirestoreSource}.
              #     * {::Google::Cloud::DiscoveryEngine::V1beta::BigtableSource BigtableSource}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::ImportDocumentsRequest.new
              #
              #   # Call the import_documents method.
              #   result = client.import_documents request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_documents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::ImportDocumentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_documents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_documents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_documents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.import_documents request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Permanently deletes all selected
              # {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s in a branch.
              #
              # This process is asynchronous. Depending on the number of
              # {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s to be deleted,
              # this operation can take hours to complete. Before the delete operation
              # completes, some {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s
              # might still be returned by
              # {::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client#get_document DocumentService.GetDocument}
              # or
              # {::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client#list_documents DocumentService.ListDocuments}.
              #
              # To get a list of the
              # {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s to be deleted,
              # set
              # {::Google::Cloud::DiscoveryEngine::V1beta::PurgeDocumentsRequest#force PurgeDocumentsRequest.force}
              # to false.
              #
              # @overload purge_documents(request, options = nil)
              #   Pass arguments to `purge_documents` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::PurgeDocumentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::PurgeDocumentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload purge_documents(gcs_source: nil, inline_source: nil, parent: nil, filter: nil, error_config: nil, force: nil)
              #   Pass arguments to `purge_documents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param gcs_source [::Google::Cloud::DiscoveryEngine::V1beta::GcsSource, ::Hash]
              #     Cloud Storage location for the input content.
              #     Supported `data_schema`:
              #     * `document_id`: One valid
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document#id Document.id} per line.
              #
              #     Note: The following parameters are mutually exclusive: `gcs_source`, `inline_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param inline_source [::Google::Cloud::DiscoveryEngine::V1beta::PurgeDocumentsRequest::InlineSource, ::Hash]
              #     Inline source for the input content for purge.
              #
              #     Note: The following parameters are mutually exclusive: `inline_source`, `gcs_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. The parent resource name, such as
              #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
              #   @param filter [::String]
              #     Required. Filter matching documents to purge. Only currently supported
              #     value is
              #     `*` (all items).
              #   @param error_config [::Google::Cloud::DiscoveryEngine::V1beta::PurgeErrorConfig, ::Hash]
              #     The desired location of errors incurred during the purge.
              #   @param force [::Boolean]
              #     Actually performs the purge. If `force` is set to false, return the
              #     expected purge count without deleting any documents.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::PurgeDocumentsRequest.new
              #
              #   # Call the purge_documents method.
              #   result = client.purge_documents request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def purge_documents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::PurgeDocumentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.purge_documents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.purge_documents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.purge_documents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.purge_documents request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets index freshness metadata for
              # {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s. Supported for
              # website search only.
              #
              # @overload batch_get_documents_metadata(request, options = nil)
              #   Pass arguments to `batch_get_documents_metadata` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1beta::BatchGetDocumentsMetadataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1beta::BatchGetDocumentsMetadataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_get_documents_metadata(parent: nil, matcher: nil)
              #   Pass arguments to `batch_get_documents_metadata` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent branch resource name, such as
              #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
              #   @param matcher [::Google::Cloud::DiscoveryEngine::V1beta::BatchGetDocumentsMetadataRequest::Matcher, ::Hash]
              #     Required. Matcher for the
              #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document}s.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DiscoveryEngine::V1beta::BatchGetDocumentsMetadataResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1beta::BatchGetDocumentsMetadataResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1beta::BatchGetDocumentsMetadataRequest.new
              #
              #   # Call the batch_get_documents_metadata method.
              #   result = client.batch_get_documents_metadata request
              #
              #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1beta::BatchGetDocumentsMetadataResponse.
              #   p result
              #
              def batch_get_documents_metadata request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1beta::BatchGetDocumentsMetadataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_get_documents_metadata.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_get_documents_metadata.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_get_documents_metadata.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.batch_get_documents_metadata request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DocumentService REST API.
              #
              # This class represents the configuration for DocumentService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_document to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_document.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::DiscoveryEngine::V1beta::DocumentService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_document.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "discoveryengine.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the DocumentService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_document
                  ##
                  # RPC-specific configuration for `list_documents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_documents
                  ##
                  # RPC-specific configuration for `create_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_document
                  ##
                  # RPC-specific configuration for `update_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_document
                  ##
                  # RPC-specific configuration for `delete_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_document
                  ##
                  # RPC-specific configuration for `import_documents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_documents
                  ##
                  # RPC-specific configuration for `purge_documents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :purge_documents
                  ##
                  # RPC-specific configuration for `batch_get_documents_metadata`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_get_documents_metadata

                  # @private
                  def initialize parent_rpcs = nil
                    get_document_config = parent_rpcs.get_document if parent_rpcs.respond_to? :get_document
                    @get_document = ::Gapic::Config::Method.new get_document_config
                    list_documents_config = parent_rpcs.list_documents if parent_rpcs.respond_to? :list_documents
                    @list_documents = ::Gapic::Config::Method.new list_documents_config
                    create_document_config = parent_rpcs.create_document if parent_rpcs.respond_to? :create_document
                    @create_document = ::Gapic::Config::Method.new create_document_config
                    update_document_config = parent_rpcs.update_document if parent_rpcs.respond_to? :update_document
                    @update_document = ::Gapic::Config::Method.new update_document_config
                    delete_document_config = parent_rpcs.delete_document if parent_rpcs.respond_to? :delete_document
                    @delete_document = ::Gapic::Config::Method.new delete_document_config
                    import_documents_config = parent_rpcs.import_documents if parent_rpcs.respond_to? :import_documents
                    @import_documents = ::Gapic::Config::Method.new import_documents_config
                    purge_documents_config = parent_rpcs.purge_documents if parent_rpcs.respond_to? :purge_documents
                    @purge_documents = ::Gapic::Config::Method.new purge_documents_config
                    batch_get_documents_metadata_config = parent_rpcs.batch_get_documents_metadata if parent_rpcs.respond_to? :batch_get_documents_metadata
                    @batch_get_documents_metadata = ::Gapic::Config::Method.new batch_get_documents_metadata_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
