# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/discovery_engine/v1/site_search_engine_service"

class ::Google::Cloud::DiscoveryEngine::V1::SiteSearchEngineService::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_site_search_engine_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::DiscoveryEngine::V1::SiteSearchEngineService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.site_search_engine_path project: "value0", location: "value1", data_store: "value2"
      assert_equal "projects/value0/locations/value1/dataStores/value2/siteSearchEngine", path

      path = client.site_search_engine_path project: "value0", location: "value1", collection: "value2", data_store: "value3"
      assert_equal "projects/value0/locations/value1/collections/value2/dataStores/value3/siteSearchEngine", path
    end
  end

  def test_sitemap_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::DiscoveryEngine::V1::SiteSearchEngineService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.sitemap_path project: "value0", location: "value1", data_store: "value2", sitemap: "value3"
      assert_equal "projects/value0/locations/value1/dataStores/value2/siteSearchEngine/sitemaps/value3", path

      path = client.sitemap_path project: "value0", location: "value1", collection: "value2", data_store: "value3", sitemap: "value4"
      assert_equal "projects/value0/locations/value1/collections/value2/dataStores/value3/siteSearchEngine/sitemaps/value4", path
    end
  end

  def test_target_site_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::DiscoveryEngine::V1::SiteSearchEngineService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.target_site_path project: "value0", location: "value1", data_store: "value2", target_site: "value3"
      assert_equal "projects/value0/locations/value1/dataStores/value2/siteSearchEngine/targetSites/value3", path

      path = client.target_site_path project: "value0", location: "value1", collection: "value2", data_store: "value3", target_site: "value4"
      assert_equal "projects/value0/locations/value1/collections/value2/dataStores/value3/siteSearchEngine/targetSites/value4", path
    end
  end
end
