# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/discoveryengine/v1/search_tuning_service_pb"
require "google/cloud/discovery_engine/v1/search_tuning_service"

class ::Google::Cloud::DiscoveryEngine::V1::SearchTuningService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_train_custom_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    gcs_training_input = {}
    data_store = "hello world"
    model_type = "hello world"
    error_config = {}
    model_id = "hello world"

    train_custom_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :train_custom_model, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::TrainCustomModelRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DiscoveryEngine::V1::TrainCustomModelRequest::GcsTrainingInput), request["gcs_training_input"]
      assert_equal :gcs_training_input, request.training_input
      assert_equal "hello world", request["data_store"]
      assert_equal "hello world", request["model_type"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DiscoveryEngine::V1::ImportErrorConfig), request["error_config"]
      assert_equal "hello world", request["model_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, train_custom_model_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1::SearchTuningService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.train_custom_model({ gcs_training_input: gcs_training_input, data_store: data_store, model_type: model_type, error_config: error_config, model_id: model_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.train_custom_model gcs_training_input: gcs_training_input, data_store: data_store, model_type: model_type, error_config: error_config, model_id: model_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.train_custom_model ::Google::Cloud::DiscoveryEngine::V1::TrainCustomModelRequest.new(gcs_training_input: gcs_training_input, data_store: data_store, model_type: model_type, error_config: error_config, model_id: model_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.train_custom_model({ gcs_training_input: gcs_training_input, data_store: data_store, model_type: model_type, error_config: error_config, model_id: model_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.train_custom_model(::Google::Cloud::DiscoveryEngine::V1::TrainCustomModelRequest.new(gcs_training_input: gcs_training_input, data_store: data_store, model_type: model_type, error_config: error_config, model_id: model_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, train_custom_model_client_stub.call_rpc_count
    end
  end

  def test_list_custom_models
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DiscoveryEngine::V1::ListCustomModelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    data_store = "hello world"

    list_custom_models_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_custom_models, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::ListCustomModelsRequest, request
      assert_equal "hello world", request["data_store"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_custom_models_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1::SearchTuningService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_custom_models({ data_store: data_store }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_custom_models data_store: data_store do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_custom_models ::Google::Cloud::DiscoveryEngine::V1::ListCustomModelsRequest.new(data_store: data_store) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_custom_models({ data_store: data_store }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_custom_models(::Google::Cloud::DiscoveryEngine::V1::ListCustomModelsRequest.new(data_store: data_store), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_custom_models_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DiscoveryEngine::V1::SearchTuningService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::SearchTuningService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DiscoveryEngine::V1::SearchTuningService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::SearchTuningService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DiscoveryEngine::V1::SearchTuningService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::SearchTuningService::Operations, client.operations_client
  end
end
