# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/discoveryengine/v1/identity_mapping_store_service_pb"
require "google/cloud/discovery_engine/v1/identity_mapping_store_service"

class ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_identity_mapping_store
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    cmek_config_name = "hello world"
    parent = "hello world"
    identity_mapping_store_id = "hello world"
    identity_mapping_store = {}

    create_identity_mapping_store_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_identity_mapping_store, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::CreateIdentityMappingStoreRequest, request
      assert_equal "hello world", request["cmek_config_name"]
      assert_equal :cmek_config_name, request.cmek_options
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["identity_mapping_store_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore), request["identity_mapping_store"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_identity_mapping_store_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_identity_mapping_store({ cmek_config_name: cmek_config_name, parent: parent, identity_mapping_store_id: identity_mapping_store_id, identity_mapping_store: identity_mapping_store }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_identity_mapping_store cmek_config_name: cmek_config_name, parent: parent, identity_mapping_store_id: identity_mapping_store_id, identity_mapping_store: identity_mapping_store do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_identity_mapping_store ::Google::Cloud::DiscoveryEngine::V1::CreateIdentityMappingStoreRequest.new(cmek_config_name: cmek_config_name, parent: parent, identity_mapping_store_id: identity_mapping_store_id, identity_mapping_store: identity_mapping_store) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_identity_mapping_store({ cmek_config_name: cmek_config_name, parent: parent, identity_mapping_store_id: identity_mapping_store_id, identity_mapping_store: identity_mapping_store }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_identity_mapping_store(::Google::Cloud::DiscoveryEngine::V1::CreateIdentityMappingStoreRequest.new(cmek_config_name: cmek_config_name, parent: parent, identity_mapping_store_id: identity_mapping_store_id, identity_mapping_store: identity_mapping_store), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_identity_mapping_store_client_stub.call_rpc_count
    end
  end

  def test_get_identity_mapping_store
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_identity_mapping_store_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_identity_mapping_store, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::GetIdentityMappingStoreRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_identity_mapping_store_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_identity_mapping_store({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_identity_mapping_store name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_identity_mapping_store ::Google::Cloud::DiscoveryEngine::V1::GetIdentityMappingStoreRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_identity_mapping_store({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_identity_mapping_store(::Google::Cloud::DiscoveryEngine::V1::GetIdentityMappingStoreRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_identity_mapping_store_client_stub.call_rpc_count
    end
  end

  def test_delete_identity_mapping_store
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_identity_mapping_store_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_identity_mapping_store, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::DeleteIdentityMappingStoreRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_identity_mapping_store_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_identity_mapping_store({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_identity_mapping_store name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_identity_mapping_store ::Google::Cloud::DiscoveryEngine::V1::DeleteIdentityMappingStoreRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_identity_mapping_store({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_identity_mapping_store(::Google::Cloud::DiscoveryEngine::V1::DeleteIdentityMappingStoreRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_identity_mapping_store_client_stub.call_rpc_count
    end
  end

  def test_import_identity_mappings
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    inline_source = {}
    identity_mapping_store = "hello world"

    import_identity_mappings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_identity_mappings, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::ImportIdentityMappingsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DiscoveryEngine::V1::ImportIdentityMappingsRequest::InlineSource), request["inline_source"]
      assert_equal :inline_source, request.source
      assert_equal "hello world", request["identity_mapping_store"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_identity_mappings_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_identity_mappings({ inline_source: inline_source, identity_mapping_store: identity_mapping_store }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_identity_mappings inline_source: inline_source, identity_mapping_store: identity_mapping_store do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_identity_mappings ::Google::Cloud::DiscoveryEngine::V1::ImportIdentityMappingsRequest.new(inline_source: inline_source, identity_mapping_store: identity_mapping_store) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_identity_mappings({ inline_source: inline_source, identity_mapping_store: identity_mapping_store }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_identity_mappings(::Google::Cloud::DiscoveryEngine::V1::ImportIdentityMappingsRequest.new(inline_source: inline_source, identity_mapping_store: identity_mapping_store), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_identity_mappings_client_stub.call_rpc_count
    end
  end

  def test_purge_identity_mappings
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    inline_source = {}
    identity_mapping_store = "hello world"
    filter = "hello world"
    force = true

    purge_identity_mappings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :purge_identity_mappings, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::PurgeIdentityMappingsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DiscoveryEngine::V1::PurgeIdentityMappingsRequest::InlineSource), request["inline_source"]
      assert_equal :inline_source, request.source
      assert_equal "hello world", request["identity_mapping_store"]
      assert_equal "hello world", request["filter"]
      assert_equal true, request["force"]
      assert request.has_force?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, purge_identity_mappings_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.purge_identity_mappings({ inline_source: inline_source, identity_mapping_store: identity_mapping_store, filter: filter, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.purge_identity_mappings inline_source: inline_source, identity_mapping_store: identity_mapping_store, filter: filter, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.purge_identity_mappings ::Google::Cloud::DiscoveryEngine::V1::PurgeIdentityMappingsRequest.new(inline_source: inline_source, identity_mapping_store: identity_mapping_store, filter: filter, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.purge_identity_mappings({ inline_source: inline_source, identity_mapping_store: identity_mapping_store, filter: filter, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.purge_identity_mappings(::Google::Cloud::DiscoveryEngine::V1::PurgeIdentityMappingsRequest.new(inline_source: inline_source, identity_mapping_store: identity_mapping_store, filter: filter, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, purge_identity_mappings_client_stub.call_rpc_count
    end
  end

  def test_list_identity_mappings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    identity_mapping_store = "hello world"
    page_size = 42
    page_token = "hello world"

    list_identity_mappings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_identity_mappings, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingsRequest, request
      assert_equal "hello world", request["identity_mapping_store"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_identity_mappings_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_identity_mappings({ identity_mapping_store: identity_mapping_store, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_identity_mappings identity_mapping_store: identity_mapping_store, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_identity_mappings ::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingsRequest.new(identity_mapping_store: identity_mapping_store, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_identity_mappings({ identity_mapping_store: identity_mapping_store, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_identity_mappings(::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingsRequest.new(identity_mapping_store: identity_mapping_store, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_identity_mappings_client_stub.call_rpc_count
    end
  end

  def test_list_identity_mapping_stores
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingStoresResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_identity_mapping_stores_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_identity_mapping_stores, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingStoresRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_identity_mapping_stores_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_identity_mapping_stores({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_identity_mapping_stores parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_identity_mapping_stores ::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingStoresRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_identity_mapping_stores({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_identity_mapping_stores(::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingStoresRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_identity_mapping_stores_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Operations, client.operations_client
  end
end
