# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/discoveryengine/v1/identity_mapping_store_service_pb"
require "google/cloud/discovery_engine/v1/identity_mapping_store_service/rest"


class ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_identity_mapping_store
    # Create test objects.
    client_result = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    cmek_config_name = "hello world"
    parent = "hello world"
    identity_mapping_store_id = "hello world"
    identity_mapping_store = {}

    create_identity_mapping_store_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::ServiceStub.stub :transcode_create_identity_mapping_store_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_identity_mapping_store_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_identity_mapping_store({ cmek_config_name: cmek_config_name, parent: parent, identity_mapping_store_id: identity_mapping_store_id, identity_mapping_store: identity_mapping_store }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_identity_mapping_store cmek_config_name: cmek_config_name, parent: parent, identity_mapping_store_id: identity_mapping_store_id, identity_mapping_store: identity_mapping_store do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_identity_mapping_store ::Google::Cloud::DiscoveryEngine::V1::CreateIdentityMappingStoreRequest.new(cmek_config_name: cmek_config_name, parent: parent, identity_mapping_store_id: identity_mapping_store_id, identity_mapping_store: identity_mapping_store) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_identity_mapping_store({ cmek_config_name: cmek_config_name, parent: parent, identity_mapping_store_id: identity_mapping_store_id, identity_mapping_store: identity_mapping_store }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_identity_mapping_store(::Google::Cloud::DiscoveryEngine::V1::CreateIdentityMappingStoreRequest.new(cmek_config_name: cmek_config_name, parent: parent, identity_mapping_store_id: identity_mapping_store_id, identity_mapping_store: identity_mapping_store), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_identity_mapping_store_client_stub.call_count
      end
    end
  end

  def test_get_identity_mapping_store
    # Create test objects.
    client_result = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_identity_mapping_store_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::ServiceStub.stub :transcode_get_identity_mapping_store_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_identity_mapping_store_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_identity_mapping_store({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_identity_mapping_store name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_identity_mapping_store ::Google::Cloud::DiscoveryEngine::V1::GetIdentityMappingStoreRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_identity_mapping_store({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_identity_mapping_store(::Google::Cloud::DiscoveryEngine::V1::GetIdentityMappingStoreRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_identity_mapping_store_client_stub.call_count
      end
    end
  end

  def test_delete_identity_mapping_store
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_identity_mapping_store_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::ServiceStub.stub :transcode_delete_identity_mapping_store_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_identity_mapping_store_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_identity_mapping_store({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_identity_mapping_store name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_identity_mapping_store ::Google::Cloud::DiscoveryEngine::V1::DeleteIdentityMappingStoreRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_identity_mapping_store({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_identity_mapping_store(::Google::Cloud::DiscoveryEngine::V1::DeleteIdentityMappingStoreRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_identity_mapping_store_client_stub.call_count
      end
    end
  end

  def test_import_identity_mappings
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    inline_source = {}
    identity_mapping_store = "hello world"

    import_identity_mappings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::ServiceStub.stub :transcode_import_identity_mappings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_identity_mappings_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_identity_mappings({ inline_source: inline_source, identity_mapping_store: identity_mapping_store }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_identity_mappings inline_source: inline_source, identity_mapping_store: identity_mapping_store do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_identity_mappings ::Google::Cloud::DiscoveryEngine::V1::ImportIdentityMappingsRequest.new(inline_source: inline_source, identity_mapping_store: identity_mapping_store) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_identity_mappings({ inline_source: inline_source, identity_mapping_store: identity_mapping_store }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_identity_mappings(::Google::Cloud::DiscoveryEngine::V1::ImportIdentityMappingsRequest.new(inline_source: inline_source, identity_mapping_store: identity_mapping_store), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_identity_mappings_client_stub.call_count
      end
    end
  end

  def test_purge_identity_mappings
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    inline_source = {}
    identity_mapping_store = "hello world"
    filter = "hello world"
    force = true

    purge_identity_mappings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::ServiceStub.stub :transcode_purge_identity_mappings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, purge_identity_mappings_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.purge_identity_mappings({ inline_source: inline_source, identity_mapping_store: identity_mapping_store, filter: filter, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.purge_identity_mappings inline_source: inline_source, identity_mapping_store: identity_mapping_store, filter: filter, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.purge_identity_mappings ::Google::Cloud::DiscoveryEngine::V1::PurgeIdentityMappingsRequest.new(inline_source: inline_source, identity_mapping_store: identity_mapping_store, filter: filter, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.purge_identity_mappings({ inline_source: inline_source, identity_mapping_store: identity_mapping_store, filter: filter, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.purge_identity_mappings(::Google::Cloud::DiscoveryEngine::V1::PurgeIdentityMappingsRequest.new(inline_source: inline_source, identity_mapping_store: identity_mapping_store, filter: filter, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, purge_identity_mappings_client_stub.call_count
      end
    end
  end

  def test_list_identity_mappings
    # Create test objects.
    client_result = ::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    identity_mapping_store = "hello world"
    page_size = 42
    page_token = "hello world"

    list_identity_mappings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::ServiceStub.stub :transcode_list_identity_mappings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_identity_mappings_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_identity_mappings({ identity_mapping_store: identity_mapping_store, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_identity_mappings identity_mapping_store: identity_mapping_store, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_identity_mappings ::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingsRequest.new(identity_mapping_store: identity_mapping_store, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_identity_mappings({ identity_mapping_store: identity_mapping_store, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_identity_mappings(::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingsRequest.new(identity_mapping_store: identity_mapping_store, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_identity_mappings_client_stub.call_count
      end
    end
  end

  def test_list_identity_mapping_stores
    # Create test objects.
    client_result = ::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingStoresResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_identity_mapping_stores_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::ServiceStub.stub :transcode_list_identity_mapping_stores_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_identity_mapping_stores_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_identity_mapping_stores({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_identity_mapping_stores parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_identity_mapping_stores ::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingStoresRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_identity_mapping_stores({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_identity_mapping_stores(::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingStoresRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_identity_mapping_stores_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Rest::Client::Configuration, config
  end
end
