# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::UserLicenseService::Client#list_user_licenses UserLicenseService.ListUserLicenses}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent [UserStore][] resource name, format:
        #     `projects/{project}/locations/{location}/userStores/{user_store_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, defaults to 10. The maximum value is 50; values
        #     above 50 will be coerced to 50.
        #
        #     If this field is negative, an INVALID_ARGUMENT error is returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListUserLicenses` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListUserLicenses`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter for the list request.
        #
        #     Supported fields:
        #
        #     * `license_assignment_state`
        #
        #     Examples:
        #
        #     * `license_assignment_state = ASSIGNED` to list assigned user licenses.
        #     * `license_assignment_state = NO_LICENSE` to list not licensed users.
        #     * `license_assignment_state = NO_LICENSE_ATTEMPTED_LOGIN` to list users
        #     who attempted login but no license assigned.
        #     * `license_assignment_state != NO_LICENSE_ATTEMPTED_LOGIN` to filter
        #     out users who attempted login but no license assigned.
        class ListUserLicensesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1::UserLicenseService::Client#list_user_licenses UserLicenseService.ListUserLicenses}.
        # @!attribute [rw] user_licenses
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::UserLicense>]
        #     All the customer's
        #     {::Google::Cloud::DiscoveryEngine::V1::UserLicense UserLicense}s.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page. If
        #     this field is omitted, there are no subsequent pages.
        class ListUserLicensesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::UserLicenseService::Client#batch_update_user_licenses UserLicenseService.BatchUpdateUserLicenses}
        # method.
        # @!attribute [rw] inline_source
        #   @return [::Google::Cloud::DiscoveryEngine::V1::BatchUpdateUserLicensesRequest::InlineSource]
        #     The inline source for the input content for document embeddings.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent [UserStore][] resource name, format:
        #     `projects/{project}/locations/{location}/userStores/{user_store_id}`.
        # @!attribute [rw] delete_unassigned_user_licenses
        #   @return [::Boolean]
        #     Optional. If true, if user licenses removed associated license config, the
        #     user license will be deleted. By default which is false, the user license
        #     will be updated to unassigned state.
        class BatchUpdateUserLicensesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The inline source for the input config for BatchUpdateUserLicenses
          # method.
          # @!attribute [rw] user_licenses
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::UserLicense>]
          #     Required. A list of user licenses to update. Each user license
          #     must have a valid
          #     {::Google::Cloud::DiscoveryEngine::V1::UserLicense#user_principal UserLicense.user_principal}.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. The list of fields to update.
          class InlineSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metadata related to the progress of the
        # {::Google::Cloud::DiscoveryEngine::V1::UserLicenseService::Client#batch_update_user_licenses UserLicenseService.BatchUpdateUserLicenses}
        # operation. This will be returned by the google.longrunning.Operation.metadata
        # field.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation create time.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation last update time. If the operation is done, this is also the
        #     finish time.
        # @!attribute [rw] success_count
        #   @return [::Integer]
        #     Count of user licenses successfully updated.
        # @!attribute [rw] failure_count
        #   @return [::Integer]
        #     Count of user licenses that failed to be updated.
        class BatchUpdateUserLicensesMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1::UserLicenseService::Client#batch_update_user_licenses UserLicenseService.BatchUpdateUserLicenses}
        # method.
        # @!attribute [rw] user_licenses
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::UserLicense>]
        #     UserLicenses successfully updated.
        # @!attribute [rw] error_samples
        #   @return [::Array<::Google::Rpc::Status>]
        #     A sample of errors encountered while processing the request.
        class BatchUpdateUserLicensesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
