# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # User License information assigned by the admin.
        # @!attribute [rw] user_principal
        #   @return [::String]
        #     Required. Immutable. The user principal of the User, could be email address
        #     or other prinical identifier. This field is immutable. Admin assign
        #     licenses based on the user principal.
        # @!attribute [rw] user_profile
        #   @return [::String]
        #     Optional. The user profile.
        #     We user user full name(First name + Last name) as user profile.
        # @!attribute [r] license_assignment_state
        #   @return [::Google::Cloud::DiscoveryEngine::V1::UserLicense::LicenseAssignmentState]
        #     Output only. License assignment state of the user.
        #     If the user is assigned with a license config, the user loggin will be
        #     assigned with the license;
        #     If the user's license assignment state is unassigned or unspecified, no
        #     license config will be associated to the user;
        # @!attribute [rw] license_config
        #   @return [::String]
        #     Optional. The full resource name of the Subscription(LicenseConfig)
        #     assigned to the user.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. User created timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. User update timestamp.
        # @!attribute [r] last_login_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. User last logged in time.
        #     If the user has not logged in yet, this field will be empty.
        class UserLicense
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # License assignment state enumeration.
          module LicenseAssignmentState
            # Default value.
            LICENSE_ASSIGNMENT_STATE_UNSPECIFIED = 0

            # License assigned to the user.
            ASSIGNED = 1

            # No license assigned to the user.
            # Deprecated, translated to NO_LICENSE.
            UNASSIGNED = 2

            # No license assigned to the user.
            NO_LICENSE = 3

            # User attempted to login but no license assigned to the user.
            # This state is only used for no user first time login attempt but cannot
            # get license assigned.
            # Users already logged in but cannot get license assigned will be assigned
            # NO_LICENSE state(License could be unassigned by admin).
            NO_LICENSE_ATTEMPTED_LOGIN = 4
          end
        end
      end
    end
  end
end
