# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # External session proto definition.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. Fully qualified name
        #     `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/*`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The display name of the session.
        #
        #     This field is used to identify the session in the UI.
        #     By default, the display name is the first turn query text in the session.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::DiscoveryEngine::V1::Session::State]
        #     The state of the session.
        # @!attribute [rw] user_pseudo_id
        #   @return [::String]
        #     A unique identifier for tracking users.
        # @!attribute [rw] turns
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::Session::Turn>]
        #     Turns.
        # @!attribute [rw] labels
        #   @return [::Array<::String>]
        #     Optional. The labels for the session.
        #     Can be set as filter in ListSessionsRequest.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the session started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the session finished.
        # @!attribute [rw] is_pinned
        #   @return [::Boolean]
        #     Optional. Whether the session is pinned, pinned session will be displayed
        #     on the top of the session list.
        class Session
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a turn, including a query from the user and a
          # answer from service.
          # @!attribute [rw] query
          #   @return [::Google::Cloud::DiscoveryEngine::V1::Query]
          #     Optional. The user query. May not be set if this turn is merely
          #     regenerating an answer to a different turn
          # @!attribute [rw] answer
          #   @return [::String]
          #     Optional. The resource name of the answer to the user query.
          #
          #     Only set if the answer generation (/answer API call) happened in this
          #     turn.
          # @!attribute [r] detailed_answer
          #   @return [::Google::Cloud::DiscoveryEngine::V1::Answer]
          #     Output only. In
          #     {::Google::Cloud::DiscoveryEngine::V1::ConversationalSearchService::Client#get_session ConversationalSearchService.GetSession}
          #     API, if
          #     {::Google::Cloud::DiscoveryEngine::V1::GetSessionRequest#include_answer_details GetSessionRequest.include_answer_details}
          #     is set to true, this field will be populated when getting answer query
          #     session.
          # @!attribute [r] detailed_assist_answer
          #   @return [::Google::Cloud::DiscoveryEngine::V1::AssistAnswer]
          #     Output only. In
          #     {::Google::Cloud::DiscoveryEngine::V1::ConversationalSearchService::Client#get_session ConversationalSearchService.GetSession}
          #     API, if
          #     {::Google::Cloud::DiscoveryEngine::V1::GetSessionRequest#include_answer_details GetSessionRequest.include_answer_details}
          #     is set to true, this field will be populated when getting assistant
          #     session.
          # @!attribute [rw] query_config
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Represents metadata related to the query config, for example
          #     LLM model and version used, model parameters (temperature, grounding
          #     parameters, etc.). The prefix "google." is reserved for Google-developed
          #     functionality.
          class Turn
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class QueryConfigEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Enumeration of the state of the session.
          module State
            # State is unspecified.
            STATE_UNSPECIFIED = 0

            # The session is currently open.
            IN_PROGRESS = 1
          end
        end

        # Defines a user inputed query.
        # @!attribute [rw] text
        #   @return [::String]
        #     Plain text.
        # @!attribute [r] query_id
        #   @return [::String]
        #     Output only. Unique Id for the query.
        class Query
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
