# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::SearchTuningService::Client#list_custom_models SearchTuningService.ListCustomModels}
        # method.
        # @!attribute [rw] data_store
        #   @return [::String]
        #     Required. The resource name of the parent Data Store, such as
        #     `projects/*/locations/global/collections/default_collection/dataStores/default_data_store`.
        #     This field is used to identify the data store where to fetch the models
        #     from.
        class ListCustomModelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1::SearchTuningService::Client#list_custom_models SearchTuningService.ListCustomModels}
        # method.
        # @!attribute [rw] models
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::CustomTuningModel>]
        #     List of custom tuning models.
        class ListCustomModelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::SearchTuningService::Client#train_custom_model SearchTuningService.TrainCustomModel}
        # method.
        # @!attribute [rw] gcs_training_input
        #   @return [::Google::Cloud::DiscoveryEngine::V1::TrainCustomModelRequest::GcsTrainingInput]
        #     Cloud Storage training input.
        # @!attribute [rw] data_store
        #   @return [::String]
        #     Required. The resource name of the Data Store, such as
        #     `projects/*/locations/global/collections/default_collection/dataStores/default_data_store`.
        #     This field is used to identify the data store where to train the models.
        # @!attribute [rw] model_type
        #   @return [::String]
        #     Model to be trained. Supported values are:
        #
        #      * **search-tuning**: Fine tuning the search system based on data provided.
        # @!attribute [rw] error_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1::ImportErrorConfig]
        #     The desired location of errors incurred during the data ingestion and
        #     training.
        # @!attribute [rw] model_id
        #   @return [::String]
        #     If not provided, a UUID will be generated.
        class TrainCustomModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Cloud Storage training data input.
          # @!attribute [rw] corpus_data_path
          #   @return [::String]
          #     The Cloud Storage corpus data which could be associated in train data.
          #     The data path format is `gs://<bucket_to_data>/<jsonl_file_name>`.
          #     A newline delimited jsonl/ndjson file.
          #
          #     For search-tuning model, each line should have the _id, title
          #     and text. Example:
          #     `{"_id": "doc1", title: "relevant doc", "text": "relevant text"}`
          # @!attribute [rw] query_data_path
          #   @return [::String]
          #     The gcs query data which could be associated in train data.
          #     The data path format is `gs://<bucket_to_data>/<jsonl_file_name>`.
          #     A newline delimited jsonl/ndjson file.
          #
          #     For search-tuning model, each line should have the _id
          #     and text. Example: \\{"_id": "query1",  "text": "example query"}
          # @!attribute [rw] train_data_path
          #   @return [::String]
          #     Cloud Storage training data path whose format should be
          #     `gs://<bucket_to_data>/<tsv_file_name>`. The file should be in tsv
          #     format. Each line should have the doc_id and query_id and score (number).
          #
          #     For search-tuning model, it should have the query-id corpus-id
          #     score as tsv file header. The score should be a number in `[0, inf+)`.
          #     The larger the number is, the more relevant the pair is. Example:
          #
          #     * `query-id\tcorpus-id\tscore`
          #     * `query1\tdoc1\t1`
          # @!attribute [rw] test_data_path
          #   @return [::String]
          #     Cloud Storage test data. Same format as train_data_path. If not provided,
          #     a random 80/20 train/test split will be performed on train_data_path.
          class GcsTrainingInput
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response of the
        # {::Google::Cloud::DiscoveryEngine::V1::TrainCustomModelRequest TrainCustomModelRequest}.
        # This message is returned by the google.longrunning.Operations.response field.
        # @!attribute [rw] error_samples
        #   @return [::Array<::Google::Rpc::Status>]
        #     A sample of errors encountered while processing the data.
        # @!attribute [rw] error_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1::ImportErrorConfig]
        #     Echoes the destination for the complete errors in the request if set.
        # @!attribute [rw] model_status
        #   @return [::String]
        #     The trained model status. Possible values are:
        #
        #      * **bad-data**: The training data quality is bad.
        #      * **no-improvement**: Tuning didn't improve performance. Won't deploy.
        #      * **in-progress**: Model training job creation is in progress.
        #      * **training**: Model is actively training.
        #      * **evaluating**: The model is evaluating trained metrics.
        #      * **indexing**: The model trained metrics are indexing.
        #      * **ready**: The model is ready for serving.
        # @!attribute [rw] metrics
        #   @return [::Google::Protobuf::Map{::String => ::Float}]
        #     The metrics of the trained model.
        # @!attribute [rw] model_name
        #   @return [::String]
        #     Fully qualified name of the CustomTuningModel.
        class TrainCustomModelResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Float]
          class MetricsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metadata related to the progress of the TrainCustomModel operation. This is
        # returned by the google.longrunning.Operation.metadata field.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation create time.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation last update time. If the operation is done, this is also the
        #     finish time.
        class TrainCustomModelMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
