# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # Safety rating corresponding to the generated content.
        # @!attribute [r] category
        #   @return [::Google::Cloud::DiscoveryEngine::V1::HarmCategory]
        #     Output only. Harm category.
        # @!attribute [r] probability
        #   @return [::Google::Cloud::DiscoveryEngine::V1::SafetyRating::HarmProbability]
        #     Output only. Harm probability levels in the content.
        # @!attribute [r] probability_score
        #   @return [::Float]
        #     Output only. Harm probability score.
        # @!attribute [r] severity
        #   @return [::Google::Cloud::DiscoveryEngine::V1::SafetyRating::HarmSeverity]
        #     Output only. Harm severity levels in the content.
        # @!attribute [r] severity_score
        #   @return [::Float]
        #     Output only. Harm severity score.
        # @!attribute [r] blocked
        #   @return [::Boolean]
        #     Output only. Indicates whether the content was filtered out because of this
        #     rating.
        class SafetyRating
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Harm probability levels in the content.
          module HarmProbability
            # Harm probability unspecified.
            HARM_PROBABILITY_UNSPECIFIED = 0

            # Negligible level of harm.
            NEGLIGIBLE = 1

            # Low level of harm.
            LOW = 2

            # Medium level of harm.
            MEDIUM = 3

            # High level of harm.
            HIGH = 4
          end

          # Harm severity levels.
          module HarmSeverity
            # Harm severity unspecified.
            HARM_SEVERITY_UNSPECIFIED = 0

            # Negligible level of harm severity.
            HARM_SEVERITY_NEGLIGIBLE = 1

            # Low level of harm severity.
            HARM_SEVERITY_LOW = 2

            # Medium level of harm severity.
            HARM_SEVERITY_MEDIUM = 3

            # High level of harm severity.
            HARM_SEVERITY_HIGH = 4
          end
        end

        # Harm categories that will block the content.
        module HarmCategory
          # The harm category is unspecified.
          HARM_CATEGORY_UNSPECIFIED = 0

          # The harm category is hate speech.
          HARM_CATEGORY_HATE_SPEECH = 1

          # The harm category is dangerous content.
          HARM_CATEGORY_DANGEROUS_CONTENT = 2

          # The harm category is harassment.
          HARM_CATEGORY_HARASSMENT = 3

          # The harm category is sexually explicit content.
          HARM_CATEGORY_SEXUALLY_EXPLICIT = 4

          # The harm category is civic integrity.
          HARM_CATEGORY_CIVIC_INTEGRITY = 5
        end
      end
    end
  end
end
