# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # Request message for Recommend method.
        # @!attribute [rw] serving_config
        #   @return [::String]
        #     Required. Full resource name of a
        #     {::Google::Cloud::DiscoveryEngine::V1::ServingConfig ServingConfig}:
        #     `projects/*/locations/global/collections/*/engines/*/servingConfigs/*`, or
        #     `projects/*/locations/global/collections/*/dataStores/*/servingConfigs/*`
        #
        #     One default serving config is created along with your recommendation engine
        #     creation. The engine ID is used as the ID of the default serving
        #     config. For example, for Engine
        #     `projects/*/locations/global/collections/*/engines/my-engine`, you can use
        #     `projects/*/locations/global/collections/*/engines/my-engine/servingConfigs/my-engine`
        #     for your
        #     {::Google::Cloud::DiscoveryEngine::V1::RecommendationService::Client#recommend RecommendationService.Recommend}
        #     requests.
        # @!attribute [rw] user_event
        #   @return [::Google::Cloud::DiscoveryEngine::V1::UserEvent]
        #     Required. Context about the user, what they are looking at and what action
        #     they took to trigger the Recommend request. Note that this user event
        #     detail won't be ingested to userEvent logs. Thus, a separate userEvent
        #     write request is required for event logging.
        #
        #     Don't set
        #     {::Google::Cloud::DiscoveryEngine::V1::UserEvent#user_pseudo_id UserEvent.user_pseudo_id}
        #     or
        #     {::Google::Cloud::DiscoveryEngine::V1::UserInfo#user_id UserEvent.user_info.user_id}
        #     to the same fixed ID for different users. If you are trying to receive
        #     non-personalized recommendations (not recommended; this can negatively
        #     impact model performance), instead set
        #     {::Google::Cloud::DiscoveryEngine::V1::UserEvent#user_pseudo_id UserEvent.user_pseudo_id}
        #     to a random unique ID and leave
        #     {::Google::Cloud::DiscoveryEngine::V1::UserInfo#user_id UserEvent.user_info.user_id}
        #     unset.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of results to return. Set this property
        #     to the number of recommendation results needed. If zero, the service
        #     chooses a reasonable default. The maximum allowed value is 100. Values
        #     above 100 are set to 100.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter for restricting recommendation results with a length limit of 5,000
        #     characters. Currently, only filter expressions on the `filter_tags`
        #     attribute is supported.
        #
        #
        #     Examples:
        #
        #      * `(filter_tags: ANY("Red", "Blue") OR filter_tags: ANY("Hot", "Cold"))`
        #      * `(filter_tags: ANY("Red", "Blue")) AND NOT (filter_tags: ANY("Green"))`
        #
        #     If `attributeFilteringSyntax` is set to true under the `params` field, then
        #     attribute-based expressions are expected instead of the above described
        #     tag-based syntax. Examples:
        #
        #      * (language: ANY("en", "es")) AND NOT (categories: ANY("Movie"))
        #      * (available: true) AND
        #        (language: ANY("en", "es")) OR (categories: ANY("Movie"))
        #
        #     If your filter blocks all results, the API returns generic
        #     (unfiltered) popular Documents. If you only want results strictly matching
        #     the filters, set `strictFiltering` to `true` in
        #     {::Google::Cloud::DiscoveryEngine::V1::RecommendRequest#params RecommendRequest.params}
        #     to receive empty results instead.
        #
        #     Note that the API never returns
        #     {::Google::Cloud::DiscoveryEngine::V1::Document Document}s with `storageStatus`
        #     as `EXPIRED` or `DELETED` regardless of filter choices.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Use validate only mode for this recommendation query. If set to `true`, a
        #     fake model is used that returns arbitrary Document IDs.
        #     Note that the validate only mode should only be used for testing the API,
        #     or if the model is not ready.
        # @!attribute [rw] params
        #   @return [::Google::Protobuf::Map{::String => ::Google::Protobuf::Value}]
        #     Additional domain specific parameters for the recommendations.
        #
        #     Allowed values:
        #
        #     * `returnDocument`: Boolean. If set to `true`, the associated Document
        #        object is returned in
        #        {::Google::Cloud::DiscoveryEngine::V1::RecommendResponse::RecommendationResult#document RecommendResponse.RecommendationResult.document}.
        #     * `returnScore`: Boolean. If set to true, the recommendation score
        #        corresponding to each returned Document is set in
        #        {::Google::Cloud::DiscoveryEngine::V1::RecommendResponse::RecommendationResult#metadata RecommendResponse.RecommendationResult.metadata}.
        #        The given score indicates the probability of a Document conversion given
        #        the user's context and history.
        #     * `strictFiltering`: Boolean. True by default. If set to `false`, the
        #     service
        #        returns generic (unfiltered) popular Documents instead of empty if
        #        your filter blocks all recommendation results.
        #     * `diversityLevel`: String. Default empty. If set to be non-empty, then
        #        it needs to be one of:
        #         *  `no-diversity`
        #         *  `low-diversity`
        #         *  `medium-diversity`
        #         *  `high-diversity`
        #         *  `auto-diversity`
        #        This gives request-level control and adjusts recommendation results
        #        based on Document category.
        #     * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
        #        the `filter` field is interpreted according to the new,
        #        attribute-based syntax.
        # @!attribute [rw] user_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The user labels applied to a resource must meet the following requirements:
        #
        #     * Each resource can have multiple labels, up to a maximum of 64.
        #     * Each label must be a key-value pair.
        #     * Keys have a minimum length of 1 character and a maximum length of 63
        #       characters and cannot be empty. Values can be empty and have a maximum
        #       length of 63 characters.
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #       underscores, and dashes. All characters must use UTF-8 encoding, and
        #       international characters are allowed.
        #     * The key portion of a label must be unique. However, you can use the same
        #       key with multiple resources.
        #     * Keys must start with a lowercase letter or international character.
        #
        #     See [Requirements for
        #     labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
        #     for more details.
        class RecommendRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Protobuf::Value]
          class ParamsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class UserLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for Recommend method.
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::RecommendResponse::RecommendationResult>]
        #     A list of recommended Documents. The order represents the ranking (from the
        #     most relevant Document to the least).
        # @!attribute [rw] attribution_token
        #   @return [::String]
        #     A unique attribution token. This should be included in the
        #     {::Google::Cloud::DiscoveryEngine::V1::UserEvent UserEvent} logs resulting from
        #     this recommendation, which enables accurate attribution of recommendation
        #     model performance.
        # @!attribute [rw] missing_ids
        #   @return [::Array<::String>]
        #     IDs of documents in the request that were missing from the default Branch
        #     associated with the requested ServingConfig.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     True if
        #     {::Google::Cloud::DiscoveryEngine::V1::RecommendRequest#validate_only RecommendRequest.validate_only}
        #     was set.
        class RecommendResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # RecommendationResult represents a generic recommendation result with
          # associated metadata.
          # @!attribute [rw] id
          #   @return [::String]
          #     Resource ID of the recommended Document.
          # @!attribute [rw] document
          #   @return [::Google::Cloud::DiscoveryEngine::V1::Document]
          #     Set if `returnDocument` is set to true in
          #     {::Google::Cloud::DiscoveryEngine::V1::RecommendRequest#params RecommendRequest.params}.
          # @!attribute [rw] metadata
          #   @return [::Google::Protobuf::Map{::String => ::Google::Protobuf::Value}]
          #     Additional Document metadata or annotations.
          #
          #     Possible values:
          #
          #     * `score`: Recommendation score in double value. Is set if
          #       `returnScore` is set to true in
          #       {::Google::Cloud::DiscoveryEngine::V1::RecommendRequest#params RecommendRequest.params}.
          class RecommendationResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Protobuf::Value]
            class MetadataEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
