# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#create_identity_mapping_store IdentityMappingStoreService.CreateIdentityMappingStore}
        # @!attribute [rw] cmek_config_name
        #   @return [::String]
        #     Resource name of the CmekConfig to use for protecting this Identity
        #     Mapping Store.
        #
        #     Note: The following fields are mutually exclusive: `cmek_config_name`, `disable_cmek`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] disable_cmek
        #   @return [::Boolean]
        #     Identity Mapping Store without CMEK protections. If a default CmekConfig
        #     is set for the project, setting this field will override the default
        #     CmekConfig as well.
        #
        #     Note: The following fields are mutually exclusive: `disable_cmek`, `cmek_config_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent collection resource name, such as
        #     `projects/{project}/locations/{location}`.
        # @!attribute [rw] identity_mapping_store_id
        #   @return [::String]
        #     Required. The ID of the Identity Mapping Store to create.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 63 characters.
        # @!attribute [rw] identity_mapping_store
        #   @return [::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore]
        #     Required. The Identity Mapping Store to create.
        class CreateIdentityMappingStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#get_identity_mapping_store IdentityMappingStoreService.GetIdentityMappingStore}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Identity Mapping Store to get.
        #     Format:
        #     `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
        class GetIdentityMappingStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#delete_identity_mapping_store IdentityMappingStoreService.DeleteIdentityMappingStore}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Identity Mapping Store to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
        class DeleteIdentityMappingStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#import_identity_mappings IdentityMappingStoreService.ImportIdentityMappings}
        # @!attribute [rw] inline_source
        #   @return [::Google::Cloud::DiscoveryEngine::V1::ImportIdentityMappingsRequest::InlineSource]
        #     The inline source to import identity mapping entries from.
        # @!attribute [rw] identity_mapping_store
        #   @return [::String]
        #     Required. The name of the Identity Mapping Store to import Identity Mapping
        #     Entries to. Format:
        #     `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
        class ImportIdentityMappingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The inline source to import identity mapping entries from.
          # @!attribute [rw] identity_mapping_entries
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::IdentityMappingEntry>]
          #     A maximum of 10000 entries can be imported at one time
          class InlineSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#import_identity_mappings IdentityMappingStoreService.ImportIdentityMappings}
        # @!attribute [rw] error_samples
        #   @return [::Array<::Google::Rpc::Status>]
        #     A sample of errors encountered while processing the request.
        class ImportIdentityMappingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#purge_identity_mappings IdentityMappingStoreService.PurgeIdentityMappings}
        # @!attribute [rw] inline_source
        #   @return [::Google::Cloud::DiscoveryEngine::V1::PurgeIdentityMappingsRequest::InlineSource]
        #     The inline source to purge identity mapping entries from.
        # @!attribute [rw] identity_mapping_store
        #   @return [::String]
        #     Required. The name of the Identity Mapping Store to purge Identity Mapping
        #     Entries from. Format:
        #     `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter matching identity mappings to purge.
        #     The eligible field for filtering is:
        #     * `update_time`: in ISO 8601 "zulu" format.
        #     * `external_id`
        #
        #     Examples:
        #
        #     * Deleting all identity mappings updated in a time range:
        #       `update_time > "2012-04-23T18:25:43.511Z" AND update_time <
        #       "2012-04-23T18:30:43.511Z"`
        #     * Deleting all identity mappings for a given external_id:
        #     `external_id = "id1"`
        #     * Deleting all identity mappings inside an identity mapping store:
        #       `*`
        #
        #     The filtering fields are assumed to have an implicit AND.
        #     Should not be used with source. An error will be thrown, if both are
        #     provided.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Actually performs the purge. If `force` is set to false, return the
        #     expected purge count without deleting any identity mappings. This field is
        #     only supported for purge with filter. For input source this field is
        #     ignored and data will be purged regardless of the value of this field.
        class PurgeIdentityMappingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The inline source to purge identity mapping entries from.
          # @!attribute [rw] identity_mapping_entries
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::IdentityMappingEntry>]
          #     A maximum of 10000 entries can be purged at one time
          class InlineSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#list_identity_mappings IdentityMappingStoreService.ListIdentityMappings}
        # @!attribute [rw] identity_mapping_store
        #   @return [::String]
        #     Required. The name of the Identity Mapping Store to list Identity Mapping
        #     Entries in. Format:
        #     `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of IdentityMappings to return. If unspecified, defaults
        #     to 2000. The maximum allowed value is 10000. Values above 10000 will be
        #     coerced to 10000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListIdentityMappings` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListIdentityMappings` must match the call that provided the page
        #     token.
        class ListIdentityMappingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#list_identity_mappings IdentityMappingStoreService.ListIdentityMappings}
        # @!attribute [rw] identity_mapping_entries
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::IdentityMappingEntry>]
        #     The Identity Mapping Entries.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page. If this
        #     field is omitted, there are no subsequent pages.
        class ListIdentityMappingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#list_identity_mapping_stores IdentityMappingStoreService.ListIdentityMappingStores}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the Identity Mapping Stores to list.
        #     Format:
        #     `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of IdentityMappingStores to return. If unspecified, defaults
        #     to 100. The maximum allowed value is 1000. Values above 1000 will be
        #     coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListIdentityMappingStores` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListIdentityMappingStores` must match the call that provided the page
        #     token.
        class ListIdentityMappingStoresRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#list_identity_mapping_stores IdentityMappingStoreService.ListIdentityMappingStores}
        # @!attribute [rw] identity_mapping_stores
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore>]
        #     The Identity Mapping Stores.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page. If this
        #     field is omitted, there are no subsequent pages.
        class ListIdentityMappingStoresResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # IdentityMappingEntry LongRunningOperation metadata for
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#import_identity_mappings IdentityMappingStoreService.ImportIdentityMappings}
        # and
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#purge_identity_mappings IdentityMappingStoreService.PurgeIdentityMappings}
        # @!attribute [rw] success_count
        #   @return [::Integer]
        #     The number of IdentityMappingEntries that were successfully processed.
        # @!attribute [rw] failure_count
        #   @return [::Integer]
        #     The number of IdentityMappingEntries that failed to be processed.
        # @!attribute [rw] total_count
        #   @return [::Integer]
        #     The total number of IdentityMappingEntries that were processed.
        class IdentityMappingEntryOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata related to the progress of the
        # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client#delete_identity_mapping_store IdentityMappingStoreService.DeleteIdentityMappingStore}
        # operation. This will be returned by the google.longrunning.Operation.metadata
        # field.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation create time.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation last update time. If the operation is done, this is also the
        #     finish time.
        class DeleteIdentityMappingStoreMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
