# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # Identity Mapping Store which contains Identity Mapping Entries.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The full resource name of the identity mapping store.
        #     Format:
        #     `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
        #     This field must be a UTF-8 encoded string with a length limit of 1024
        #     characters.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     Input only. The KMS key to be used to protect this Identity Mapping Store
        #     at creation time.
        #
        #     Must be set for requests that need to comply with CMEK Org Policy
        #     protections.
        #
        #     If this field is set and processed successfully, the Identity Mapping Store
        #     will be protected by the KMS key, as indicated in the cmek_config field.
        # @!attribute [r] cmek_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1::CmekConfig]
        #     Output only. CMEK-related information for the Identity Mapping Store.
        class IdentityMappingStore
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Identity Mapping Entry that maps an external identity to an internal
        # identity.
        # @!attribute [rw] user_id
        #   @return [::String]
        #     User identifier.
        #     For Google Workspace user account, user_id should be the google workspace
        #     user email.
        #     For non-google identity provider, user_id is the mapped user identifier
        #     configured during the workforcepool config.
        #
        #     Note: The following fields are mutually exclusive: `user_id`, `group_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] group_id
        #   @return [::String]
        #     Group identifier.
        #     For Google Workspace user account, group_id should be the google
        #     workspace group email.
        #     For non-google identity provider, group_id is the mapped group identifier
        #     configured during the workforcepool config.
        #
        #     Note: The following fields are mutually exclusive: `group_id`, `user_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] external_identity
        #   @return [::String]
        #     Required. Identity outside the customer identity provider.
        #     The length limit of external identity will be of 100 characters.
        class IdentityMappingEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
