# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # Document captures all raw metadata information of items to be recommended or
        # searched.
        # @!attribute [rw] struct_data
        #   @return [::Google::Protobuf::Struct]
        #     The structured JSON data for the document. It should conform to the
        #     registered {::Google::Cloud::DiscoveryEngine::V1::Schema Schema} or an
        #     `INVALID_ARGUMENT` error is thrown.
        #
        #     Note: The following fields are mutually exclusive: `struct_data`, `json_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] json_data
        #   @return [::String]
        #     The JSON string representation of the document. It should conform to the
        #     registered {::Google::Cloud::DiscoveryEngine::V1::Schema Schema} or an
        #     `INVALID_ARGUMENT` error is thrown.
        #
        #     Note: The following fields are mutually exclusive: `json_data`, `struct_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The full resource name of the document.
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
        #
        #     This field must be a UTF-8 encoded string with a length limit of 1024
        #     characters.
        # @!attribute [rw] id
        #   @return [::String]
        #     Immutable. The identifier of the document.
        #
        #     Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
        #     standard with a length limit of 128 characters.
        # @!attribute [rw] schema_id
        #   @return [::String]
        #     The identifier of the schema located in the same data store.
        # @!attribute [rw] content
        #   @return [::Google::Cloud::DiscoveryEngine::V1::Document::Content]
        #     The unstructured data linked to this document. Content can only be set
        #     and must be set if this document is under a `CONTENT_REQUIRED` data store.
        # @!attribute [rw] parent_document_id
        #   @return [::String]
        #     The identifier of the parent document. Currently supports at most two level
        #     document hierarchy.
        #
        #     Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
        #     standard with a length limit of 63 characters.
        # @!attribute [r] derived_struct_data
        #   @return [::Google::Protobuf::Struct]
        #     Output only. This field is OUTPUT_ONLY.
        #     It contains derived data that are not in the original input document.
        # @!attribute [rw] acl_info
        #   @return [::Google::Cloud::DiscoveryEngine::V1::Document::AclInfo]
        #     Access control information for the document.
        # @!attribute [r] index_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last time the document was indexed. If this field is set,
        #     the document could be returned in search results.
        #
        #     This field is OUTPUT_ONLY. If this field is not populated, it means the
        #     document has never been indexed.
        # @!attribute [r] index_status
        #   @return [::Google::Cloud::DiscoveryEngine::V1::Document::IndexStatus]
        #     Output only. The index status of the document.
        #
        #     * If document is indexed successfully, the index_time field is populated.
        #     * Otherwise, if document is not indexed due to errors, the error_samples
        #       field is populated.
        #     * Otherwise, if document's index is in progress, the pending_message field
        #       is populated.
        class Document
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Unstructured data linked to this document.
          # @!attribute [rw] raw_bytes
          #   @return [::String]
          #     The content represented as a stream of bytes. The maximum length is
          #     1,000,000 bytes (1 MB / ~0.95 MiB).
          #
          #     Note: As with all `bytes` fields, this field is represented as pure
          #     binary in Protocol Buffers and base64-encoded string in JSON. For
          #     example, `abc123!?$*&()'-=@~` should be represented as
          #     `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
          #     https://developers.google.com/protocol-buffers/docs/proto3#json.
          #
          #     Note: The following fields are mutually exclusive: `raw_bytes`, `uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] uri
          #   @return [::String]
          #     The URI of the content. Only Cloud Storage URIs (e.g.
          #     `gs://bucket-name/path/to/file`) are supported. The maximum file size
          #     is 2.5 MB for text-based formats, 200 MB for other formats.
          #
          #     Note: The following fields are mutually exclusive: `uri`, `raw_bytes`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] mime_type
          #   @return [::String]
          #     The MIME type of the content. Supported types:
          #
          #     * `application/pdf` (PDF, only native PDFs are supported for now)
          #     * `text/html` (HTML)
          #     * `text/plain` (TXT)
          #     * `application/xml` or `text/xml` (XML)
          #     * `application/json` (JSON)
          #     * `application/vnd.openxmlformats-officedocument.wordprocessingml.document` (DOCX)
          #     * `application/vnd.openxmlformats-officedocument.presentationml.presentation` (PPTX)
          #     * `application/vnd.openxmlformats-officedocument.spreadsheetml.sheet`
          #     (XLSX)
          #     * `application/vnd.ms-excel.sheet.macroenabled.12` (XLSM)
          #
          #     The following types are supported only if layout parser is enabled in the
          #     data store:
          #
          #     * `image/bmp` (BMP)
          #     * `image/gif` (GIF)
          #     * `image/jpeg` (JPEG)
          #     * `image/png` (PNG)
          #     * `image/tiff` (TIFF)
          #
          #     See https://www.iana.org/assignments/media-types/media-types.xhtml.
          class Content
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # ACL Information of the Document.
          # @!attribute [rw] readers
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::Document::AclInfo::AccessRestriction>]
          #     Readers of the document.
          class AclInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # AclRestriction to model complex inheritance restrictions.
            #
            # Example: Modeling a "Both Permit" inheritance, where to access a
            # child document, user needs to have access to parent document.
            #
            # Document Hierarchy - Space_S --> Page_P.
            #
            # Readers:
            #   Space_S: group_1, user_1
            #   Page_P: group_2, group_3, user_2
            #
            # Space_S ACL Restriction -
            # {
            #   "acl_info": {
            #     "readers": [
            #       {
            #         "principals": [
            #           {
            #             "group_id": "group_1"
            #           },
            #           {
            #             "user_id": "user_1"
            #           }
            #         ]
            #       }
            #     ]
            #   }
            # }
            #
            # Page_P ACL Restriction.
            # {
            #   "acl_info": {
            #     "readers": [
            #       {
            #         "principals": [
            #           {
            #             "group_id": "group_2"
            #           },
            #           {
            #             "group_id": "group_3"
            #           },
            #           {
            #             "user_id": "user_2"
            #           }
            #         ],
            #       },
            #       {
            #         "principals": [
            #           {
            #             "group_id": "group_1"
            #           },
            #           {
            #             "user_id": "user_1"
            #           }
            #         ],
            #       }
            #     ]
            #   }
            # }
            # @!attribute [rw] principals
            #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::Principal>]
            #     List of principals.
            # @!attribute [rw] idp_wide
            #   @return [::Boolean]
            #     All users within the Identity Provider.
            class AccessRestriction
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Index status of the document.
          # @!attribute [rw] index_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time when the document was indexed.
          #     If this field is populated, it means the document has been indexed.
          # @!attribute [rw] error_samples
          #   @return [::Array<::Google::Rpc::Status>]
          #     A sample of errors encountered while indexing the document.
          #     If this field is populated, the document is not indexed due to errors.
          # @!attribute [rw] pending_message
          #   @return [::String]
          #     Immutable. The message indicates the document index is in progress.
          #     If this field is populated, the document index is pending.
          class IndexStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
