# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # Request for
        # {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client#create_data_store DataStoreService.CreateDataStore}
        # method.
        # @!attribute [rw] cmek_config_name
        #   @return [::String]
        #     Resource name of the CmekConfig to use for protecting this DataStore.
        #
        #     Note: The following fields are mutually exclusive: `cmek_config_name`, `disable_cmek`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] disable_cmek
        #   @return [::Boolean]
        #     DataStore without CMEK protections. If a default CmekConfig is set for
        #     the project, setting this field will override the default CmekConfig as
        #     well.
        #
        #     Note: The following fields are mutually exclusive: `disable_cmek`, `cmek_config_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name, such as
        #     `projects/{project}/locations/{location}/collections/{collection}`.
        # @!attribute [rw] data_store
        #   @return [::Google::Cloud::DiscoveryEngine::V1::DataStore]
        #     Required. The {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} to
        #     create.
        # @!attribute [rw] data_store_id
        #   @return [::String]
        #     Required. The ID to use for the
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, which will become
        #     the final component of the
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}'s resource name.
        #
        #     This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
        #     standard with a length limit of 63 characters. Otherwise, an
        #     INVALID_ARGUMENT error is returned.
        # @!attribute [rw] create_advanced_site_search
        #   @return [::Boolean]
        #     A boolean flag indicating whether user want to directly create an advanced
        #     data store for site search.
        #     If the data store is not configured as site
        #     search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will
        #     be ignored.
        # @!attribute [rw] skip_default_schema_creation
        #   @return [::Boolean]
        #     A boolean flag indicating whether to skip the default schema creation for
        #     the data store. Only enable this flag if you are certain that the default
        #     schema is incompatible with your use case.
        #
        #     If set to true, you must manually create a schema for the data store before
        #     any documents can be ingested.
        #
        #     This flag cannot be specified if `data_store.starting_schema` is specified.
        class CreateDataStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client#get_data_store DataStoreService.GetDataStore}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, such as
        #     `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
        #
        #     If the caller does not have permission to access the
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, regardless of
        #     whether or not it exists, a PERMISSION_DENIED error is returned.
        #
        #     If the requested {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}
        #     does not exist, a NOT_FOUND error is returned.
        class GetDataStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata related to the progress of the
        # {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client#create_data_store DataStoreService.CreateDataStore}
        # operation. This will be returned by the google.longrunning.Operation.metadata
        # field.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation create time.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation last update time. If the operation is done, this is also the
        #     finish time.
        class CreateDataStoreMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client#list_data_stores DataStoreService.ListDataStores}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent branch resource name, such as
        #     `projects/{project}/locations/{location}/collections/{collection_id}`.
        #
        #     If the caller does not have permission to list
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}s under this
        #     location, regardless of whether or not this data store exists, a
        #     PERMISSION_DENIED error is returned.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}s
        #     to return. If unspecified, defaults to 10. The maximum allowed value is 50.
        #     Values above 50 will be coerced to 50.
        #
        #     If this field is negative, an INVALID_ARGUMENT is returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token
        #     {::Google::Cloud::DiscoveryEngine::V1::ListDataStoresResponse#next_page_token ListDataStoresResponse.next_page_token},
        #     received from a previous
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client#list_data_stores DataStoreService.ListDataStores}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client#list_data_stores DataStoreService.ListDataStores}
        #     must match the call that provided the page token. Otherwise, an
        #     INVALID_ARGUMENT error is returned.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter by solution type .
        #     For example: `filter = 'solution_type:SOLUTION_TYPE_SEARCH'`
        class ListDataStoresRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client#list_data_stores DataStoreService.ListDataStores}
        # method.
        # @!attribute [rw] data_stores
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::DataStore>]
        #     All the customer's {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}s.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::DiscoveryEngine::V1::ListDataStoresRequest#page_token ListDataStoresRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListDataStoresResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client#delete_data_store DataStoreService.DeleteDataStore}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, such as
        #     `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
        #
        #     If the caller does not have permission to delete the
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, regardless of
        #     whether or not it exists, a PERMISSION_DENIED error is returned.
        #
        #     If the {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} to delete
        #     does not exist, a NOT_FOUND error is returned.
        class DeleteDataStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client#update_data_store DataStoreService.UpdateDataStore}
        # method.
        # @!attribute [rw] data_store
        #   @return [::Google::Cloud::DiscoveryEngine::V1::DataStore]
        #     Required. The {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} to
        #     update.
        #
        #     If the caller does not have permission to update the
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, regardless of
        #     whether or not it exists, a PERMISSION_DENIED error is returned.
        #
        #     If the {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} to update
        #     does not exist, a NOT_FOUND error is returned.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Indicates which fields in the provided
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} to update.
        #
        #     If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
        #     is returned.
        class UpdateDataStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata related to the progress of the
        # {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client#delete_data_store DataStoreService.DeleteDataStore}
        # operation. This will be returned by the google.longrunning.Operation.metadata
        # field.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation create time.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation last update time. If the operation is done, this is also the
        #     finish time.
        class DeleteDataStoreMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
