# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # DataStore captures global settings and configs at the DataStore level.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. Identifier. The full resource name of the data store.
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
        #
        #     This field must be a UTF-8 encoded string with a length limit of 1024
        #     characters.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The data store display name.
        #
        #     This field must be a UTF-8 encoded string with a length limit of 128
        #     characters. Otherwise, an INVALID_ARGUMENT error is returned.
        # @!attribute [rw] industry_vertical
        #   @return [::Google::Cloud::DiscoveryEngine::V1::IndustryVertical]
        #     Immutable. The industry vertical that the data store registers.
        # @!attribute [rw] solution_types
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::SolutionType>]
        #     The solutions that the data store enrolls. Available solutions for each
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore#industry_vertical industry_vertical}:
        #
        #     * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
        #     * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
        #       solutions cannot be enrolled.
        # @!attribute [r] default_schema_id
        #   @return [::String]
        #     Output only. The id of the default
        #     {::Google::Cloud::DiscoveryEngine::V1::Schema Schema} associated to this data
        #     store.
        # @!attribute [rw] content_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1::DataStore::ContentConfig]
        #     Immutable. The content config of the data store. If this field is unset,
        #     the server behavior defaults to
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore::ContentConfig::NO_CONTENT ContentConfig.NO_CONTENT}.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp the
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} was created at.
        # @!attribute [rw] advanced_site_search_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1::AdvancedSiteSearchConfig]
        #     Optional. Configuration for advanced site search.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     Input only. The KMS key to be used to protect this DataStore at creation
        #     time.
        #
        #     Must be set for requests that need to comply with CMEK Org Policy
        #     protections.
        #
        #     If this field is set and processed successfully, the DataStore will be
        #     protected by the KMS key, as indicated in the cmek_config field.
        # @!attribute [r] cmek_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1::CmekConfig]
        #     Output only. CMEK-related information for the DataStore.
        # @!attribute [r] billing_estimation
        #   @return [::Google::Cloud::DiscoveryEngine::V1::DataStore::BillingEstimation]
        #     Output only. Data size estimation for billing.
        # @!attribute [rw] acl_enabled
        #   @return [::Boolean]
        #     Immutable. Whether data in the
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} has ACL information.
        #     If set to `true`, the source data must have ACL. ACL will be ingested when
        #     data is ingested by
        #     {::Google::Cloud::DiscoveryEngine::V1::DocumentService::Client#import_documents DocumentService.ImportDocuments}
        #     methods.
        #
        #     When ACL is enabled for the
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore},
        #     {::Google::Cloud::DiscoveryEngine::V1::Document Document} can't be accessed by
        #     calling
        #     {::Google::Cloud::DiscoveryEngine::V1::DocumentService::Client#get_document DocumentService.GetDocument}
        #     or
        #     {::Google::Cloud::DiscoveryEngine::V1::DocumentService::Client#list_documents DocumentService.ListDocuments}.
        #
        #     Currently ACL is only supported in `GENERIC` industry vertical with
        #     non-`PUBLIC_WEBSITE` content config.
        # @!attribute [rw] workspace_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1::WorkspaceConfig]
        #     Config to store data store type configuration for workspace data. This
        #     must be set when
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore#content_config DataStore.content_config}
        #     is set as
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore::ContentConfig::GOOGLE_WORKSPACE DataStore.ContentConfig.GOOGLE_WORKSPACE}.
        # @!attribute [rw] document_processing_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1::DocumentProcessingConfig]
        #     Configuration for Document understanding and enrichment.
        # @!attribute [rw] starting_schema
        #   @return [::Google::Cloud::DiscoveryEngine::V1::Schema]
        #     The start schema to use for this
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} when provisioning
        #     it. If unset, a default vertical specialized schema will be used.
        #
        #     This field is only used by
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client#create_data_store CreateDataStore}
        #     API, and will be ignored if used in other APIs. This field will be omitted
        #     from all API responses including
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client#create_data_store CreateDataStore}
        #     API. To retrieve a schema of a
        #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, use
        #     {::Google::Cloud::DiscoveryEngine::V1::SchemaService::Client#get_schema SchemaService.GetSchema}
        #     API instead.
        #
        #     The provided schema will be validated against certain rules on schema.
        #     Learn more from [this
        #     doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
        # @!attribute [rw] healthcare_fhir_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1::HealthcareFhirConfig]
        #     Optional. Configuration for `HEALTHCARE_FHIR` vertical.
        # @!attribute [rw] identity_mapping_store
        #   @return [::String]
        #     Immutable. The fully qualified resource name of the associated
        #     {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore IdentityMappingStore}.
        #     This field can only be set for acl_enabled DataStores with `THIRD_PARTY` or
        #     `GSUITE` IdP. Format:
        #     `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
        class DataStore
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Estimation of data size per data store.
          # @!attribute [rw] structured_data_size
          #   @return [::Integer]
          #     Data size for structured data in terms of bytes.
          # @!attribute [rw] unstructured_data_size
          #   @return [::Integer]
          #     Data size for unstructured data in terms of bytes.
          # @!attribute [rw] website_data_size
          #   @return [::Integer]
          #     Data size for websites in terms of bytes.
          # @!attribute [rw] structured_data_update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Last updated timestamp for structured data.
          # @!attribute [rw] unstructured_data_update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Last updated timestamp for unstructured data.
          # @!attribute [rw] website_data_update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Last updated timestamp for websites.
          class BillingEstimation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Content config of the data store.
          module ContentConfig
            # Default value.
            CONTENT_CONFIG_UNSPECIFIED = 0

            # Only contains documents without any
            # {::Google::Cloud::DiscoveryEngine::V1::Document#content Document.content}.
            NO_CONTENT = 1

            # Only contains documents with
            # {::Google::Cloud::DiscoveryEngine::V1::Document#content Document.content}.
            CONTENT_REQUIRED = 2

            # The data store is used for public website search.
            PUBLIC_WEBSITE = 3

            # The data store is used for workspace search. Details of workspace
            # data store are specified in the
            # {::Google::Cloud::DiscoveryEngine::V1::WorkspaceConfig WorkspaceConfig}.
            GOOGLE_WORKSPACE = 4
          end
        end

        # Configuration data for advance site search.
        # @!attribute [rw] disable_initial_index
        #   @return [::Boolean]
        #     If set true, initial indexing is disabled for the DataStore.
        # @!attribute [rw] disable_automatic_refresh
        #   @return [::Boolean]
        #     If set true, automatic refresh is disabled for the DataStore.
        class AdvancedSiteSearchConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Config to store data store type configuration for workspace data
        # @!attribute [rw] type
        #   @return [::Google::Cloud::DiscoveryEngine::V1::WorkspaceConfig::Type]
        #     The Google Workspace data source.
        # @!attribute [rw] dasher_customer_id
        #   @return [::String]
        #     Obfuscated Dasher customer ID.
        # @!attribute [rw] super_admin_service_account
        #   @return [::String]
        #     Optional. The super admin service account for the workspace that will be
        #     used for access token generation. For now we only use it for Native Google
        #     Drive connector data ingestion.
        # @!attribute [rw] super_admin_email_address
        #   @return [::String]
        #     Optional. The super admin email address for the workspace that will be used
        #     for access token generation. For now we only use it for Native Google Drive
        #     connector data ingestion.
        class WorkspaceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the type of Workspace App supported by this DataStore
          module Type
            # Defaults to an unspecified Workspace type.
            TYPE_UNSPECIFIED = 0

            # Workspace Data Store contains Drive data
            GOOGLE_DRIVE = 1

            # Workspace Data Store contains Mail data
            GOOGLE_MAIL = 2

            # Workspace Data Store contains Sites data
            GOOGLE_SITES = 3

            # Workspace Data Store contains Calendar data
            GOOGLE_CALENDAR = 4

            # Workspace Data Store contains Chat data
            GOOGLE_CHAT = 5

            # Workspace Data Store contains Groups data
            GOOGLE_GROUPS = 6

            # Workspace Data Store contains Keep data
            GOOGLE_KEEP = 7

            # Workspace Data Store contains People data
            GOOGLE_PEOPLE = 8
          end
        end
      end
    end
  end
end
