# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # External conversation proto definition.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. Fully qualified name
        #     `projects/{project}/locations/global/collections/{collection}/dataStore/*/conversations/*`
        #     or
        #     `projects/{project}/locations/global/collections/{collection}/engines/*/conversations/*`.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::DiscoveryEngine::V1::Conversation::State]
        #     The state of the Conversation.
        # @!attribute [rw] user_pseudo_id
        #   @return [::String]
        #     A unique identifier for tracking users.
        # @!attribute [rw] messages
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::ConversationMessage>]
        #     Conversation messages.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the conversation started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the conversation finished.
        class Conversation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumeration of the state of the conversation.
          module State
            # Unknown.
            STATE_UNSPECIFIED = 0

            # Conversation is currently open.
            IN_PROGRESS = 1

            # Conversation has been completed.
            COMPLETED = 2
          end
        end

        # Defines a reply message to user.
        # @!attribute [rw] summary
        #   @return [::Google::Cloud::DiscoveryEngine::V1::SearchResponse::Summary]
        #     Summary based on search results.
        class Reply
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines context of the conversation
        # @!attribute [rw] context_documents
        #   @return [::Array<::String>]
        #     The current list of documents the user is seeing.
        #     It contains the document resource references.
        # @!attribute [rw] active_document
        #   @return [::String]
        #     The current active document the user opened.
        #     It contains the document resource reference.
        class ConversationContext
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines text input.
        # @!attribute [rw] input
        #   @return [::String]
        #     Text input.
        # @!attribute [rw] context
        #   @return [::Google::Cloud::DiscoveryEngine::V1::ConversationContext]
        #     Conversation context of the input.
        class TextInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines a conversation message.
        # @!attribute [rw] user_input
        #   @return [::Google::Cloud::DiscoveryEngine::V1::TextInput]
        #     User text input.
        #
        #     Note: The following fields are mutually exclusive: `user_input`, `reply`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] reply
        #   @return [::Google::Cloud::DiscoveryEngine::V1::Reply]
        #     Search reply.
        #
        #     Note: The following fields are mutually exclusive: `reply`, `user_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Message creation timestamp.
        class ConversationMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
