# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # Suggestion deny list entry identifying the phrase to block from suggestions
        # and the applied operation for the phrase.
        # @!attribute [rw] block_phrase
        #   @return [::String]
        #     Required. Phrase to block from suggestions served. Can be maximum 125
        #     characters.
        # @!attribute [rw] match_operator
        #   @return [::Google::Cloud::DiscoveryEngine::V1::SuggestionDenyListEntry::MatchOperator]
        #     Required. The match operator to apply for this phrase. Whether to block the
        #     exact phrase, or block any suggestions containing this phrase.
        class SuggestionDenyListEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Operator for matching with the generated suggestions.
          module MatchOperator
            # Default value. Should not be used
            MATCH_OPERATOR_UNSPECIFIED = 0

            # If the suggestion is an exact match to the block_phrase, then block it.
            EXACT_MATCH = 1

            # If the suggestion contains the block_phrase, then block it.
            CONTAINS = 2
          end
        end

        # Autocomplete suggestions that are imported from Customer.
        # @!attribute [rw] global_score
        #   @return [::Float]
        #     Global score of this suggestion. Control how this suggestion would be
        #     scored / ranked.
        #
        #     Note: The following fields are mutually exclusive: `global_score`, `frequency`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] frequency
        #   @return [::Integer]
        #     Frequency of this suggestion. Will be used to rank suggestions when score
        #     is not available.
        #
        #     Note: The following fields are mutually exclusive: `frequency`, `global_score`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] suggestion
        #   @return [::String]
        #     Required. The suggestion text.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     BCP-47 language code of this suggestion.
        # @!attribute [rw] group_id
        #   @return [::String]
        #     If two suggestions have the same groupId, they will not be
        #     returned together. Instead the one ranked higher will be returned. This can
        #     be used to deduplicate semantically identical suggestions.
        # @!attribute [rw] group_score
        #   @return [::Float]
        #     The score of this suggestion within its group.
        # @!attribute [rw] alternative_phrases
        #   @return [::Array<::String>]
        #     Alternative matching phrases for this suggestion.
        class CompletionSuggestion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
