# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # Request message for UpdateCmekConfig method.
        # rpc.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::DiscoveryEngine::V1::CmekConfig]
        #     Required. The CmekConfig resource.
        # @!attribute [rw] set_default
        #   @return [::Boolean]
        #     Set the following CmekConfig as the default to be used for child
        #     resources if one is not specified.
        class UpdateCmekConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetCmekConfigRequest method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of
        #     {::Google::Cloud::DiscoveryEngine::V1::CmekConfig CmekConfig}, such as
        #     `projects/*/locations/*/cmekConfig` or
        #     `projects/*/locations/*/cmekConfigs/*`.
        #
        #     If the caller does not have permission to access the
        #     {::Google::Cloud::DiscoveryEngine::V1::CmekConfig CmekConfig}, regardless of
        #     whether or not it exists, a PERMISSION_DENIED error is returned.
        class GetCmekConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for single-regional CMEKs.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     Required. Single-regional kms key resource name which will be used to
        #     encrypt resources
        #     `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
        class SingleRegionKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configurations used to enable CMEK data encryption with Cloud KMS keys.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CmekConfig of the form
        #     `projects/{project}/locations/{location}/cmekConfig` or
        #     `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     KMS key resource name which will be used to encrypt resources
        #     `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
        # @!attribute [rw] kms_key_version
        #   @return [::String]
        #     KMS key version resource name which will be used to encrypt resources
        #     `<kms_key>/cryptoKeyVersions/{keyVersion}`.
        # @!attribute [r] state
        #   @return [::Google::Cloud::DiscoveryEngine::V1::CmekConfig::State]
        #     Output only. The states of the CmekConfig.
        # @!attribute [r] is_default
        #   @return [::Boolean]
        #     Output only. The default CmekConfig for the Customer.
        # @!attribute [r] last_rotation_timestamp_micros
        #   @return [::Integer]
        #     Output only. The timestamp of the last key rotation.
        # @!attribute [rw] single_region_keys
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::SingleRegionKey>]
        #     Optional. Single-regional CMEKs that are required for some VAIS features.
        # @!attribute [r] notebooklm_state
        #   @return [::Google::Cloud::DiscoveryEngine::V1::CmekConfig::NotebookLMState]
        #     Output only. Whether the NotebookLM Corpus is ready to be used.
        class CmekConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # States of the CmekConfig.
          module State
            # The CmekConfig state is unknown.
            STATE_UNSPECIFIED = 0

            # The CmekConfig is creating.
            CREATING = 1

            # The CmekConfig can be used with DataStores.
            ACTIVE = 2

            # The CmekConfig is unavailable, most likely due to the KMS Key being
            # revoked.
            KEY_ISSUE = 3

            # The CmekConfig is deleting.
            DELETING = 4

            # The CmekConfig deletion process failed.
            DELETE_FAILED = 7

            # The CmekConfig is not usable, most likely due to some internal issue.
            UNUSABLE = 5

            # The KMS key version is being rotated.
            ACTIVE_ROTATING = 6

            # The KMS key is soft deleted. Some cleanup policy will eventually be
            # applied.
            DELETED = 8
          end

          # States of NotebookLM.
          module NotebookLMState
            # The NotebookLM state is unknown.
            NOTEBOOK_LM_STATE_UNSPECIFIED = 0

            # The NotebookLM is not ready.
            NOTEBOOK_LM_NOT_READY = 1

            # The NotebookLM is ready to be used.
            NOTEBOOK_LM_READY = 2

            # The NotebookLM is not enabled.
            NOTEBOOK_LM_NOT_ENABLED = 3
          end
        end

        # Metadata related to the progress of the
        # {::Google::Cloud::DiscoveryEngine::V1::CmekConfigService::Client#update_cmek_config CmekConfigService.UpdateCmekConfig}
        # operation. This will be returned by the google.longrunning.Operation.metadata
        # field.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation create time.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation last update time. If the operation is done, this is also the
        #     finish time.
        class UpdateCmekConfigMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::CmekConfigService::Client#list_cmek_configs CmekConfigService.ListCmekConfigs}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent location resource name, such as
        #     `projects/{project}/locations/{location}`.
        #
        #     If the caller does not have permission to list
        #     {::Google::Cloud::DiscoveryEngine::V1::CmekConfig CmekConfig}s under this
        #     location, regardless of whether or not a CmekConfig exists, a
        #     PERMISSION_DENIED error is returned.
        class ListCmekConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DiscoveryEngine::V1::CmekConfigService::Client#list_cmek_configs CmekConfigService.ListCmekConfigs}
        # method.
        # @!attribute [rw] cmek_configs
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::CmekConfig>]
        #     All the customer's
        #     {::Google::Cloud::DiscoveryEngine::V1::CmekConfig CmekConfig}s.
        class ListCmekConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DiscoveryEngine::V1::CmekConfigService::Client#delete_cmek_config CmekConfigService.DeleteCmekConfig}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::DiscoveryEngine::V1::CmekConfig CmekConfig} to delete, such as
        #     `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
        class DeleteCmekConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata related to the progress of the
        # {::Google::Cloud::DiscoveryEngine::V1::CmekConfigService::Client#delete_cmek_config CmekConfigService.DeleteCmekConfig}
        # operation. This will be returned by the google.longrunning.Operation.metadata
        # field.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation create time.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation last update time. If the operation is done, this is also the
        #     finish time.
        class DeleteCmekConfigMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
