# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        # AssistAnswer resource, main part of
        # [AssistResponse][google.cloud.discoveryengine.v1.AssistResponse].
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. Resource name of the `AssistAnswer`.
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/sessions/{session}/assistAnswers/{assist_answer}`
        #
        #     This field must be a UTF-8 encoded string with a length limit of 1024
        #     characters.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::DiscoveryEngine::V1::AssistAnswer::State]
        #     State of the answer generation.
        # @!attribute [rw] replies
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::AssistAnswer::Reply>]
        #     Replies of the assistant.
        # @!attribute [rw] assist_skipped_reasons
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::AssistAnswer::AssistSkippedReason>]
        #     Reasons for not answering the assist call.
        class AssistAnswer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # One part of the multi-part response of the assist call.
          # @!attribute [rw] grounded_content
          #   @return [::Google::Cloud::DiscoveryEngine::V1::AssistantGroundedContent]
          #     Possibly grounded response text or media from the assistant.
          class Reply
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State of the answer generation.
          module State
            # Unknown.
            STATE_UNSPECIFIED = 0

            # Assist operation is currently in progress.
            IN_PROGRESS = 1

            # Assist operation has failed.
            FAILED = 2

            # Assist operation has succeeded.
            SUCCEEDED = 3

            # Assist operation has been skipped.
            SKIPPED = 4
          end

          # Possible reasons for not answering an assist call.
          module AssistSkippedReason
            # Default value. Skip reason is not specified.
            ASSIST_SKIPPED_REASON_UNSPECIFIED = 0

            # The assistant ignored the query, because it did not appear to be
            # answer-seeking.
            NON_ASSIST_SEEKING_QUERY_IGNORED = 1

            # The assistant ignored the query or refused to answer because of a
            # customer policy violation (e.g., the query or the answer contained a
            # banned phrase).
            CUSTOMER_POLICY_VIOLATION = 2
          end
        end

        # Multi-modal content.
        # @!attribute [rw] text
        #   @return [::String]
        #     Inline text.
        #
        #     Note: The following fields are mutually exclusive: `text`, `inline_data`, `file`, `executable_code`, `code_execution_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] inline_data
        #   @return [::Google::Cloud::DiscoveryEngine::V1::AssistantContent::Blob]
        #     Inline binary data.
        #
        #     Note: The following fields are mutually exclusive: `inline_data`, `text`, `file`, `executable_code`, `code_execution_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] file
        #   @return [::Google::Cloud::DiscoveryEngine::V1::AssistantContent::File]
        #     A file, e.g., an audio summary.
        #
        #     Note: The following fields are mutually exclusive: `file`, `text`, `inline_data`, `executable_code`, `code_execution_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] executable_code
        #   @return [::Google::Cloud::DiscoveryEngine::V1::AssistantContent::ExecutableCode]
        #     Code generated by the model that is meant to be executed.
        #
        #     Note: The following fields are mutually exclusive: `executable_code`, `text`, `inline_data`, `file`, `code_execution_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] code_execution_result
        #   @return [::Google::Cloud::DiscoveryEngine::V1::AssistantContent::CodeExecutionResult]
        #     Result of executing an ExecutableCode.
        #
        #     Note: The following fields are mutually exclusive: `code_execution_result`, `text`, `inline_data`, `file`, `executable_code`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] role
        #   @return [::String]
        #     The producer of the content. Can be "model" or "user".
        # @!attribute [rw] thought
        #   @return [::Boolean]
        #     Optional. Indicates if the part is thought from the model.
        class AssistantContent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Inline blob.
          # @!attribute [rw] mime_type
          #   @return [::String]
          #     Required. The media type (MIME type) of the generated data.
          # @!attribute [rw] data
          #   @return [::String]
          #     Required. Raw bytes.
          class Blob
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A file, e.g., an audio summary.
          # @!attribute [rw] mime_type
          #   @return [::String]
          #     Required. The media type (MIME type) of the file.
          # @!attribute [rw] file_id
          #   @return [::String]
          #     Required. The file ID.
          class File
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Code generated by the model that is meant to be executed by the model.
          # @!attribute [rw] code
          #   @return [::String]
          #     Required. The code content. Currently only supports Python.
          class ExecutableCode
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Result of executing ExecutableCode.
          # @!attribute [rw] outcome
          #   @return [::Google::Cloud::DiscoveryEngine::V1::AssistantContent::CodeExecutionResult::Outcome]
          #     Required. Outcome of the code execution.
          # @!attribute [rw] output
          #   @return [::String]
          #     Optional. Contains stdout when code execution is successful, stderr or
          #     other description otherwise.
          class CodeExecutionResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enumeration of possible outcomes of the code execution.
            module Outcome
              # Unspecified status. This value should not be used.
              OUTCOME_UNSPECIFIED = 0

              # Code execution completed successfully.
              OUTCOME_OK = 1

              # Code execution finished but with a failure. `stderr` should contain the
              # reason.
              OUTCOME_FAILED = 2

              # Code execution ran for too long, and was cancelled. There may or may
              # not be a partial output present.
              OUTCOME_DEADLINE_EXCEEDED = 3
            end
          end
        end

        # A piece of content and possibly its grounding information.
        #
        # Not all content needs grounding. Phrases like "Of course, I will gladly
        # search it for you." do not need grounding.
        # @!attribute [rw] text_grounding_metadata
        #   @return [::Google::Cloud::DiscoveryEngine::V1::AssistantGroundedContent::TextGroundingMetadata]
        #     Metadata for grounding based on text sources.
        # @!attribute [rw] content
        #   @return [::Google::Cloud::DiscoveryEngine::V1::AssistantContent]
        #     The content.
        class AssistantGroundedContent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Grounding details for text sources.
          # @!attribute [rw] segments
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::AssistantGroundedContent::TextGroundingMetadata::Segment>]
          #     Grounding information for parts of the text.
          # @!attribute [rw] references
          #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1::AssistantGroundedContent::TextGroundingMetadata::Reference>]
          #     References for the grounded text.
          class TextGroundingMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Grounding information for a segment of the text.
            # @!attribute [rw] start_index
            #   @return [::Integer]
            #     Zero-based index indicating the start of the segment, measured in bytes
            #     of a UTF-8 string (i.e. characters encoded on multiple bytes have a
            #     length of more than one).
            # @!attribute [rw] end_index
            #   @return [::Integer]
            #     End of the segment, exclusive.
            # @!attribute [rw] reference_indices
            #   @return [::Array<::Integer>]
            #     References for the segment.
            # @!attribute [rw] grounding_score
            #   @return [::Float]
            #     Score for the segment.
            # @!attribute [rw] text
            #   @return [::String]
            #     The text segment itself.
            class Segment
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Referenced content and related document metadata.
            # @!attribute [rw] content
            #   @return [::String]
            #     Referenced text content.
            # @!attribute [rw] document_metadata
            #   @return [::Google::Cloud::DiscoveryEngine::V1::AssistantGroundedContent::TextGroundingMetadata::Reference::DocumentMetadata]
            #     Document metadata.
            class Reference
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Document metadata.
              # @!attribute [rw] document
              #   @return [::String]
              #     Document resource name.
              # @!attribute [rw] uri
              #   @return [::String]
              #     URI for the document. It may contain a URL that redirects to the
              #     actual website.
              # @!attribute [rw] title
              #   @return [::String]
              #     Title.
              # @!attribute [rw] page_identifier
              #   @return [::String]
              #     Page identifier.
              # @!attribute [rw] domain
              #   @return [::String]
              #     Domain name from the document URI. Note that the `uri` field may
              #     contain a URL that redirects to the actual website, in which case
              #     this will contain the domain name of the target site.
              class DocumentMetadata
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end
        end
      end
    end
  end
end
