# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/discoveryengine/v1/control_service.proto for package 'Google.Cloud.DiscoveryEngine.V1'
# Original file comments:
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/discoveryengine/v1/control_service_pb'

module Google
  module Cloud
    module DiscoveryEngine
      module V1
        module ControlService
          # Service for performing CRUD operations on Controls.
          # Controls allow for custom logic to be implemented in the serving path.
          # Controls need to be attached to a Serving Config to be considered during a
          # request.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.discoveryengine.v1.ControlService'

            # Creates a Control.
            #
            # By default 1000 controls are allowed for a data store.
            # A request can be submitted to adjust this limit.
            # If the [Control][google.cloud.discoveryengine.v1.Control] to create already
            # exists, an ALREADY_EXISTS error is returned.
            rpc :CreateControl, ::Google::Cloud::DiscoveryEngine::V1::CreateControlRequest, ::Google::Cloud::DiscoveryEngine::V1::Control
            # Deletes a Control.
            #
            # If the [Control][google.cloud.discoveryengine.v1.Control] to delete does
            # not exist, a NOT_FOUND error is returned.
            rpc :DeleteControl, ::Google::Cloud::DiscoveryEngine::V1::DeleteControlRequest, ::Google::Protobuf::Empty
            # Updates a Control.
            #
            # [Control][google.cloud.discoveryengine.v1.Control] action type cannot be
            # changed. If the [Control][google.cloud.discoveryengine.v1.Control] to
            # update does not exist, a NOT_FOUND error is returned.
            rpc :UpdateControl, ::Google::Cloud::DiscoveryEngine::V1::UpdateControlRequest, ::Google::Cloud::DiscoveryEngine::V1::Control
            # Gets a Control.
            rpc :GetControl, ::Google::Cloud::DiscoveryEngine::V1::GetControlRequest, ::Google::Cloud::DiscoveryEngine::V1::Control
            # Lists all Controls by their parent
            # [DataStore][google.cloud.discoveryengine.v1.DataStore].
            rpc :ListControls, ::Google::Cloud::DiscoveryEngine::V1::ListControlsRequest, ::Google::Cloud::DiscoveryEngine::V1::ListControlsResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
