# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/discoveryengine/v1/user_event_service_pb"
require "google/cloud/discovery_engine/v1/user_event_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module DiscoveryEngine
      module V1
        module UserEventService
          module Rest
            ##
            # REST client for the UserEventService service.
            #
            # Service for ingesting end user actions on a website to Discovery Engine API.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "discoveryengine.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :user_event_service_stub

              ##
              # Configure the UserEventService Client class.
              #
              # See {::Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all UserEventService clients
              #   ::Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "DiscoveryEngine", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 30.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.import_user_events.timeout = 300.0
                  default_config.rpcs.import_user_events.retry_policy = {
                    initial_delay: 1.0, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the UserEventService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @user_event_service_stub.universe_domain
              end

              ##
              # Create a new UserEventService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the UserEventService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @user_event_service_stub = ::Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @user_event_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @user_event_service_stub.endpoint
                  config.universe_domain = @user_event_service_stub.universe_domain
                  config.logger = @user_event_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @user_event_service_stub.logger
              end

              # Service calls

              ##
              # Writes a single user event.
              #
              # @overload write_user_event(request, options = nil)
              #   Pass arguments to `write_user_event` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1::WriteUserEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1::WriteUserEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload write_user_event(parent: nil, user_event: nil, write_async: nil)
              #   Pass arguments to `write_user_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name.
              #     If the write user event action is applied in
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} level, the format
              #     is:
              #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.
              #     If the write user event action is applied in
              #     [Location][google.cloud.location.Location] level, for example, the event
              #     with {::Google::Cloud::DiscoveryEngine::V1::Document Document} across multiple
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, the format is:
              #     `projects/{project}/locations/{location}`.
              #   @param user_event [::Google::Cloud::DiscoveryEngine::V1::UserEvent, ::Hash]
              #     Required. User event to write.
              #   @param write_async [::Boolean]
              #     If set to true, the user event is written asynchronously after
              #     validation, and the API responds without waiting for the write.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DiscoveryEngine::V1::UserEvent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1::UserEvent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1::WriteUserEventRequest.new
              #
              #   # Call the write_user_event method.
              #   result = client.write_user_event request
              #
              #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1::UserEvent.
              #   p result
              #
              def write_user_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::WriteUserEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.write_user_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.write_user_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.write_user_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @user_event_service_stub.write_user_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Writes a single user event from the browser. This uses a GET request to
              # due to browser restriction of POST-ing to a third-party domain.
              #
              # This method is used only by the Discovery Engine API JavaScript pixel and
              # Google Tag Manager. Users should not call this method directly.
              #
              # @overload collect_user_event(request, options = nil)
              #   Pass arguments to `collect_user_event` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1::CollectUserEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1::CollectUserEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload collect_user_event(parent: nil, user_event: nil, uri: nil, ets: nil)
              #   Pass arguments to `collect_user_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name.
              #     If the collect user event action is applied in
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} level, the format
              #     is:
              #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.
              #     If the collect user event action is applied in
              #     [Location][google.cloud.location.Location] level, for example, the event
              #     with {::Google::Cloud::DiscoveryEngine::V1::Document Document} across multiple
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, the format is:
              #     `projects/{project}/locations/{location}`.
              #   @param user_event [::String]
              #     Required. URL encoded UserEvent proto with a length limit of 2,000,000
              #     characters.
              #   @param uri [::String]
              #     The URL including cgi-parameters but excluding the hash fragment with a
              #     length limit of 5,000 characters. This is often more useful than the
              #     referer URL, because many browsers only send the domain for third-party
              #     requests.
              #   @param ets [::Integer]
              #     The event timestamp in milliseconds. This prevents browser caching of
              #     otherwise identical get requests. The name is abbreviated to reduce the
              #     payload bytes.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Api::HttpBody]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1::CollectUserEventRequest.new
              #
              #   # Call the collect_user_event method.
              #   result = client.collect_user_event request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def collect_user_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::CollectUserEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.collect_user_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.collect_user_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.collect_user_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @user_event_service_stub.collect_user_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes permanently all user events specified by the filter provided.
              # Depending on the number of events specified by the filter, this operation
              # could take hours or days to complete. To test a filter, use the list
              # command first.
              #
              # @overload purge_user_events(request, options = nil)
              #   Pass arguments to `purge_user_events` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1::PurgeUserEventsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1::PurgeUserEventsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload purge_user_events(parent: nil, filter: nil, force: nil)
              #   Pass arguments to `purge_user_events` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the catalog under which the events are
              #     created. The format is
              #     `projects/{project}/locations/global/collections/{collection}/dataStores/{dataStore}`.
              #   @param filter [::String]
              #     Required. The filter string to specify the events to be deleted with a
              #     length limit of 5,000 characters. The eligible fields for filtering are:
              #
              #     * `eventType`: Double quoted
              #     {::Google::Cloud::DiscoveryEngine::V1::UserEvent#event_type UserEvent.event_type}
              #     string.
              #     * `eventTime`: in ISO 8601 "zulu" format.
              #     * `userPseudoId`: Double quoted string. Specifying this will delete all
              #       events associated with a visitor.
              #     * `userId`: Double quoted string. Specifying this will delete all events
              #       associated with a user.
              #
              #     Note: This API only supports purging a max range of 30 days.
              #
              #     Examples:
              #
              #     * Deleting all events in a time range:
              #       `eventTime > "2012-04-23T18:25:43.511Z"
              #       eventTime < "2012-04-23T18:30:43.511Z"`
              #     * Deleting specific eventType in a time range:
              #       `eventTime > "2012-04-23T18:25:43.511Z"
              #       eventTime < "2012-04-23T18:30:43.511Z" eventType = "search"`
              #     * Deleting all events for a specific visitor in a time range:
              #       `eventTime > "2012-04-23T18:25:43.511Z"
              #       eventTime < "2012-04-23T18:30:43.511Z" userPseudoId = "visitor1024"`
              #     * Deleting the past 30 days of events inside a DataStore:
              #       `*`
              #
              #     The filtering fields are assumed to have an implicit AND.
              #   @param force [::Boolean]
              #     The `force` field is currently not supported. Purge user event requests
              #     will permanently delete all purgeable events. Once the development is
              #     complete:
              #     If `force` is set to false, the method will return the expected
              #     purge count without deleting any user events. This field will default to
              #     false if not included in the request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1::PurgeUserEventsRequest.new
              #
              #   # Call the purge_user_events method.
              #   result = client.purge_user_events request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def purge_user_events request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::PurgeUserEventsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.purge_user_events.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.purge_user_events.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.purge_user_events.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @user_event_service_stub.purge_user_events request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Bulk import of user events. Request processing might be
              # synchronous. Events that already exist are skipped.
              # Use this method for backfilling historical user events.
              #
              # Operation.response is of type ImportResponse. Note that it is
              # possible for a subset of the items to be successfully inserted.
              # Operation.metadata is of type ImportMetadata.
              #
              # @overload import_user_events(request, options = nil)
              #   Pass arguments to `import_user_events` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1::ImportUserEventsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1::ImportUserEventsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_user_events(inline_source: nil, gcs_source: nil, bigquery_source: nil, parent: nil, error_config: nil)
              #   Pass arguments to `import_user_events` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param inline_source [::Google::Cloud::DiscoveryEngine::V1::ImportUserEventsRequest::InlineSource, ::Hash]
              #     The Inline source for the input content for UserEvents.
              #
              #     Note: The following parameters are mutually exclusive: `inline_source`, `gcs_source`, `bigquery_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param gcs_source [::Google::Cloud::DiscoveryEngine::V1::GcsSource, ::Hash]
              #     Cloud Storage location for the input content.
              #
              #     Note: The following parameters are mutually exclusive: `gcs_source`, `inline_source`, `bigquery_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param bigquery_source [::Google::Cloud::DiscoveryEngine::V1::BigQuerySource, ::Hash]
              #     BigQuery input source.
              #
              #     Note: The following parameters are mutually exclusive: `bigquery_source`, `inline_source`, `gcs_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. Parent DataStore resource name, of the form
              #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
              #   @param error_config [::Google::Cloud::DiscoveryEngine::V1::ImportErrorConfig, ::Hash]
              #     The desired location of errors incurred during the Import. Cannot be set
              #     for inline user event imports.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1::ImportUserEventsRequest.new
              #
              #   # Call the import_user_events method.
              #   result = client.import_user_events request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_user_events request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::ImportUserEventsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_user_events.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_user_events.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_user_events.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @user_event_service_stub.import_user_events request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the UserEventService REST API.
              #
              # This class represents the configuration for UserEventService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # write_user_event to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.write_user_event.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::DiscoveryEngine::V1::UserEventService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.write_user_event.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "discoveryengine.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the UserEventService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `write_user_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :write_user_event
                  ##
                  # RPC-specific configuration for `collect_user_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :collect_user_event
                  ##
                  # RPC-specific configuration for `purge_user_events`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :purge_user_events
                  ##
                  # RPC-specific configuration for `import_user_events`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_user_events

                  # @private
                  def initialize parent_rpcs = nil
                    write_user_event_config = parent_rpcs.write_user_event if parent_rpcs.respond_to? :write_user_event
                    @write_user_event = ::Gapic::Config::Method.new write_user_event_config
                    collect_user_event_config = parent_rpcs.collect_user_event if parent_rpcs.respond_to? :collect_user_event
                    @collect_user_event = ::Gapic::Config::Method.new collect_user_event_config
                    purge_user_events_config = parent_rpcs.purge_user_events if parent_rpcs.respond_to? :purge_user_events
                    @purge_user_events = ::Gapic::Config::Method.new purge_user_events_config
                    import_user_events_config = parent_rpcs.import_user_events if parent_rpcs.respond_to? :import_user_events
                    @import_user_events = ::Gapic::Config::Method.new import_user_events_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
