# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/discoveryengine/v1/identity_mapping_store_service_pb"
require "google/cloud/location"

module Google
  module Cloud
    module DiscoveryEngine
      module V1
        module IdentityMappingStoreService
          ##
          # Client for the IdentityMappingStoreService service.
          #
          # Service for managing Identity Mapping Stores.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "discoveryengine.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :identity_mapping_store_service_stub

            ##
            # Configure the IdentityMappingStoreService Client class.
            #
            # See {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all IdentityMappingStoreService clients
            #   ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "DiscoveryEngine", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the IdentityMappingStoreService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @identity_mapping_store_service_stub.universe_domain
            end

            ##
            # Create a new IdentityMappingStoreService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the IdentityMappingStoreService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/discoveryengine/v1/identity_mapping_store_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @identity_mapping_store_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @identity_mapping_store_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @identity_mapping_store_service_stub.endpoint
                config.universe_domain = @identity_mapping_store_service_stub.universe_domain
                config.logger = @identity_mapping_store_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @identity_mapping_store_service_stub.logger
            end

            # Service calls

            ##
            # Creates a new Identity Mapping Store.
            #
            # @overload create_identity_mapping_store(request, options = nil)
            #   Pass arguments to `create_identity_mapping_store` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1::CreateIdentityMappingStoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1::CreateIdentityMappingStoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_identity_mapping_store(cmek_config_name: nil, disable_cmek: nil, parent: nil, identity_mapping_store_id: nil, identity_mapping_store: nil)
            #   Pass arguments to `create_identity_mapping_store` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param cmek_config_name [::String]
            #     Resource name of the CmekConfig to use for protecting this Identity
            #     Mapping Store.
            #
            #     Note: The following parameters are mutually exclusive: `cmek_config_name`, `disable_cmek`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param disable_cmek [::Boolean]
            #     Identity Mapping Store without CMEK protections. If a default CmekConfig
            #     is set for the project, setting this field will override the default
            #     CmekConfig as well.
            #
            #     Note: The following parameters are mutually exclusive: `disable_cmek`, `cmek_config_name`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param parent [::String]
            #     Required. The parent collection resource name, such as
            #     `projects/{project}/locations/{location}`.
            #   @param identity_mapping_store_id [::String]
            #     Required. The ID of the Identity Mapping Store to create.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 63 characters.
            #   @param identity_mapping_store [::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore, ::Hash]
            #     Required. The Identity Mapping Store to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1::CreateIdentityMappingStoreRequest.new
            #
            #   # Call the create_identity_mapping_store method.
            #   result = client.create_identity_mapping_store request
            #
            #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore.
            #   p result
            #
            def create_identity_mapping_store request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::CreateIdentityMappingStoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_identity_mapping_store.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_identity_mapping_store.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_identity_mapping_store.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_mapping_store_service_stub.call_rpc :create_identity_mapping_store, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the Identity Mapping Store.
            #
            # @overload get_identity_mapping_store(request, options = nil)
            #   Pass arguments to `get_identity_mapping_store` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1::GetIdentityMappingStoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1::GetIdentityMappingStoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_identity_mapping_store(name: nil)
            #   Pass arguments to `get_identity_mapping_store` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Identity Mapping Store to get.
            #     Format:
            #     `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1::GetIdentityMappingStoreRequest.new
            #
            #   # Call the get_identity_mapping_store method.
            #   result = client.get_identity_mapping_store request
            #
            #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore.
            #   p result
            #
            def get_identity_mapping_store request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::GetIdentityMappingStoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_identity_mapping_store.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_identity_mapping_store.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_identity_mapping_store.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_mapping_store_service_stub.call_rpc :get_identity_mapping_store, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the Identity Mapping Store.
            #
            # @overload delete_identity_mapping_store(request, options = nil)
            #   Pass arguments to `delete_identity_mapping_store` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1::DeleteIdentityMappingStoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1::DeleteIdentityMappingStoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_identity_mapping_store(name: nil)
            #   Pass arguments to `delete_identity_mapping_store` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Identity Mapping Store to delete.
            #     Format:
            #     `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1::DeleteIdentityMappingStoreRequest.new
            #
            #   # Call the delete_identity_mapping_store method.
            #   result = client.delete_identity_mapping_store request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_identity_mapping_store request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::DeleteIdentityMappingStoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_identity_mapping_store.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_identity_mapping_store.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_identity_mapping_store.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_mapping_store_service_stub.call_rpc :delete_identity_mapping_store, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Imports a list of Identity Mapping Entries to an Identity Mapping Store.
            #
            # @overload import_identity_mappings(request, options = nil)
            #   Pass arguments to `import_identity_mappings` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1::ImportIdentityMappingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1::ImportIdentityMappingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload import_identity_mappings(inline_source: nil, identity_mapping_store: nil)
            #   Pass arguments to `import_identity_mappings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param inline_source [::Google::Cloud::DiscoveryEngine::V1::ImportIdentityMappingsRequest::InlineSource, ::Hash]
            #     The inline source to import identity mapping entries from.
            #   @param identity_mapping_store [::String]
            #     Required. The name of the Identity Mapping Store to import Identity Mapping
            #     Entries to. Format:
            #     `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1::ImportIdentityMappingsRequest.new
            #
            #   # Call the import_identity_mappings method.
            #   result = client.import_identity_mappings request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def import_identity_mappings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::ImportIdentityMappingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.import_identity_mappings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.identity_mapping_store
                header_params["identity_mapping_store"] = request.identity_mapping_store
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.import_identity_mappings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.import_identity_mappings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_mapping_store_service_stub.call_rpc :import_identity_mappings, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Purges specified or all Identity Mapping Entries from an Identity Mapping
            # Store.
            #
            # @overload purge_identity_mappings(request, options = nil)
            #   Pass arguments to `purge_identity_mappings` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1::PurgeIdentityMappingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1::PurgeIdentityMappingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload purge_identity_mappings(inline_source: nil, identity_mapping_store: nil, filter: nil, force: nil)
            #   Pass arguments to `purge_identity_mappings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param inline_source [::Google::Cloud::DiscoveryEngine::V1::PurgeIdentityMappingsRequest::InlineSource, ::Hash]
            #     The inline source to purge identity mapping entries from.
            #   @param identity_mapping_store [::String]
            #     Required. The name of the Identity Mapping Store to purge Identity Mapping
            #     Entries from. Format:
            #     `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
            #   @param filter [::String]
            #     Filter matching identity mappings to purge.
            #     The eligible field for filtering is:
            #     * `update_time`: in ISO 8601 "zulu" format.
            #     * `external_id`
            #
            #     Examples:
            #
            #     * Deleting all identity mappings updated in a time range:
            #       `update_time > "2012-04-23T18:25:43.511Z" AND update_time <
            #       "2012-04-23T18:30:43.511Z"`
            #     * Deleting all identity mappings for a given external_id:
            #     `external_id = "id1"`
            #     * Deleting all identity mappings inside an identity mapping store:
            #       `*`
            #
            #     The filtering fields are assumed to have an implicit AND.
            #     Should not be used with source. An error will be thrown, if both are
            #     provided.
            #   @param force [::Boolean]
            #     Actually performs the purge. If `force` is set to false, return the
            #     expected purge count without deleting any identity mappings. This field is
            #     only supported for purge with filter. For input source this field is
            #     ignored and data will be purged regardless of the value of this field.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1::PurgeIdentityMappingsRequest.new
            #
            #   # Call the purge_identity_mappings method.
            #   result = client.purge_identity_mappings request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def purge_identity_mappings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::PurgeIdentityMappingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.purge_identity_mappings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.identity_mapping_store
                header_params["identity_mapping_store"] = request.identity_mapping_store
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.purge_identity_mappings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.purge_identity_mappings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_mapping_store_service_stub.call_rpc :purge_identity_mappings, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Identity Mappings in an Identity Mapping Store.
            #
            # @overload list_identity_mappings(request, options = nil)
            #   Pass arguments to `list_identity_mappings` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_identity_mappings(identity_mapping_store: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_identity_mappings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param identity_mapping_store [::String]
            #     Required. The name of the Identity Mapping Store to list Identity Mapping
            #     Entries in. Format:
            #     `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
            #   @param page_size [::Integer]
            #     Maximum number of IdentityMappings to return. If unspecified, defaults
            #     to 2000. The maximum allowed value is 10000. Values above 10000 will be
            #     coerced to 10000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListIdentityMappings` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListIdentityMappings` must match the call that provided the page
            #     token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1::IdentityMappingEntry>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1::IdentityMappingEntry>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingsRequest.new
            #
            #   # Call the list_identity_mappings method.
            #   result = client.list_identity_mappings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingEntry.
            #     p item
            #   end
            #
            def list_identity_mappings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_identity_mappings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.identity_mapping_store
                header_params["identity_mapping_store"] = request.identity_mapping_store
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_identity_mappings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_identity_mappings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_mapping_store_service_stub.call_rpc :list_identity_mappings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @identity_mapping_store_service_stub, :list_identity_mappings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all Identity Mapping Stores.
            #
            # @overload list_identity_mapping_stores(request, options = nil)
            #   Pass arguments to `list_identity_mapping_stores` via a request object, either of type
            #   {::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingStoresRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingStoresRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_identity_mapping_stores(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_identity_mapping_stores` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent of the Identity Mapping Stores to list.
            #     Format:
            #     `projects/{project}/locations/{location}`.
            #   @param page_size [::Integer]
            #     Maximum number of IdentityMappingStores to return. If unspecified, defaults
            #     to 100. The maximum allowed value is 1000. Values above 1000 will be
            #     coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListIdentityMappingStores` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListIdentityMappingStores` must match the call that provided the page
            #     token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/discovery_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingStoresRequest.new
            #
            #   # Call the list_identity_mapping_stores method.
            #   result = client.list_identity_mapping_stores request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStore.
            #     p item
            #   end
            #
            def list_identity_mapping_stores request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::ListIdentityMappingStoresRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_identity_mapping_stores.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_identity_mapping_stores.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_identity_mapping_stores.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_mapping_store_service_stub.call_rpc :list_identity_mapping_stores, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @identity_mapping_store_service_stub, :list_identity_mapping_stores, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the IdentityMappingStoreService API.
            #
            # This class represents the configuration for IdentityMappingStoreService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_identity_mapping_store to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_identity_mapping_store.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_identity_mapping_store.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "discoveryengine.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the IdentityMappingStoreService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_identity_mapping_store`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_identity_mapping_store
                ##
                # RPC-specific configuration for `get_identity_mapping_store`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_identity_mapping_store
                ##
                # RPC-specific configuration for `delete_identity_mapping_store`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_identity_mapping_store
                ##
                # RPC-specific configuration for `import_identity_mappings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :import_identity_mappings
                ##
                # RPC-specific configuration for `purge_identity_mappings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :purge_identity_mappings
                ##
                # RPC-specific configuration for `list_identity_mappings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_identity_mappings
                ##
                # RPC-specific configuration for `list_identity_mapping_stores`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_identity_mapping_stores

                # @private
                def initialize parent_rpcs = nil
                  create_identity_mapping_store_config = parent_rpcs.create_identity_mapping_store if parent_rpcs.respond_to? :create_identity_mapping_store
                  @create_identity_mapping_store = ::Gapic::Config::Method.new create_identity_mapping_store_config
                  get_identity_mapping_store_config = parent_rpcs.get_identity_mapping_store if parent_rpcs.respond_to? :get_identity_mapping_store
                  @get_identity_mapping_store = ::Gapic::Config::Method.new get_identity_mapping_store_config
                  delete_identity_mapping_store_config = parent_rpcs.delete_identity_mapping_store if parent_rpcs.respond_to? :delete_identity_mapping_store
                  @delete_identity_mapping_store = ::Gapic::Config::Method.new delete_identity_mapping_store_config
                  import_identity_mappings_config = parent_rpcs.import_identity_mappings if parent_rpcs.respond_to? :import_identity_mappings
                  @import_identity_mappings = ::Gapic::Config::Method.new import_identity_mappings_config
                  purge_identity_mappings_config = parent_rpcs.purge_identity_mappings if parent_rpcs.respond_to? :purge_identity_mappings
                  @purge_identity_mappings = ::Gapic::Config::Method.new purge_identity_mappings_config
                  list_identity_mappings_config = parent_rpcs.list_identity_mappings if parent_rpcs.respond_to? :list_identity_mappings
                  @list_identity_mappings = ::Gapic::Config::Method.new list_identity_mappings_config
                  list_identity_mapping_stores_config = parent_rpcs.list_identity_mapping_stores if parent_rpcs.respond_to? :list_identity_mapping_stores
                  @list_identity_mapping_stores = ::Gapic::Config::Method.new list_identity_mapping_stores_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
