# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/discoveryengine/v1/data_store_service_pb"
require "google/cloud/discovery_engine/v1/data_store_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module DiscoveryEngine
      module V1
        module DataStoreService
          module Rest
            ##
            # REST client for the DataStoreService service.
            #
            # Service for managing {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}
            # configuration.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "discoveryengine.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :data_store_service_stub

              ##
              # Configure the DataStoreService Client class.
              #
              # See {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all DataStoreService clients
              #   ::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "DiscoveryEngine", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DataStoreService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @data_store_service_stub.universe_domain
              end

              ##
              # Create a new DataStoreService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DataStoreService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @data_store_service_stub = ::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @data_store_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @data_store_service_stub.endpoint
                  config.universe_domain = @data_store_service_stub.universe_domain
                  config.logger = @data_store_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @data_store_service_stub.logger
              end

              # Service calls

              ##
              # Creates a {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}.
              #
              # DataStore is for storing
              # {::Google::Cloud::DiscoveryEngine::V1::Document Documents}. To serve these
              # documents for Search, or Recommendation use case, an
              # {::Google::Cloud::DiscoveryEngine::V1::Engine Engine} needs to be created
              # separately.
              #
              # @overload create_data_store(request, options = nil)
              #   Pass arguments to `create_data_store` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1::CreateDataStoreRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1::CreateDataStoreRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_data_store(cmek_config_name: nil, disable_cmek: nil, parent: nil, data_store: nil, data_store_id: nil, create_advanced_site_search: nil, skip_default_schema_creation: nil)
              #   Pass arguments to `create_data_store` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param cmek_config_name [::String]
              #     Resource name of the CmekConfig to use for protecting this DataStore.
              #
              #     Note: The following parameters are mutually exclusive: `cmek_config_name`, `disable_cmek`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param disable_cmek [::Boolean]
              #     DataStore without CMEK protections. If a default CmekConfig is set for
              #     the project, setting this field will override the default CmekConfig as
              #     well.
              #
              #     Note: The following parameters are mutually exclusive: `disable_cmek`, `cmek_config_name`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. The parent resource name, such as
              #     `projects/{project}/locations/{location}/collections/{collection}`.
              #   @param data_store [::Google::Cloud::DiscoveryEngine::V1::DataStore, ::Hash]
              #     Required. The {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} to
              #     create.
              #   @param data_store_id [::String]
              #     Required. The ID to use for the
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, which will become
              #     the final component of the
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}'s resource name.
              #
              #     This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
              #     standard with a length limit of 63 characters. Otherwise, an
              #     INVALID_ARGUMENT error is returned.
              #   @param create_advanced_site_search [::Boolean]
              #     A boolean flag indicating whether user want to directly create an advanced
              #     data store for site search.
              #     If the data store is not configured as site
              #     search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will
              #     be ignored.
              #   @param skip_default_schema_creation [::Boolean]
              #     A boolean flag indicating whether to skip the default schema creation for
              #     the data store. Only enable this flag if you are certain that the default
              #     schema is incompatible with your use case.
              #
              #     If set to true, you must manually create a schema for the data store before
              #     any documents can be ingested.
              #
              #     This flag cannot be specified if `data_store.starting_schema` is specified.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1::CreateDataStoreRequest.new
              #
              #   # Call the create_data_store method.
              #   result = client.create_data_store request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_data_store request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::CreateDataStoreRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_data_store.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_data_store.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_data_store.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_store_service_stub.create_data_store request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}.
              #
              # @overload get_data_store(request, options = nil)
              #   Pass arguments to `get_data_store` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1::GetDataStoreRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1::GetDataStoreRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_data_store(name: nil)
              #   Pass arguments to `get_data_store` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Full resource name of
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, such as
              #     `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
              #
              #     If the caller does not have permission to access the
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, regardless of
              #     whether or not it exists, a PERMISSION_DENIED error is returned.
              #
              #     If the requested {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}
              #     does not exist, a NOT_FOUND error is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DiscoveryEngine::V1::DataStore]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1::DataStore]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1::GetDataStoreRequest.new
              #
              #   # Call the get_data_store method.
              #   result = client.get_data_store request
              #
              #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1::DataStore.
              #   p result
              #
              def get_data_store request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::GetDataStoreRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_data_store.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_data_store.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_data_store.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_store_service_stub.get_data_store request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}s
              # associated with the project.
              #
              # @overload list_data_stores(request, options = nil)
              #   Pass arguments to `list_data_stores` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1::ListDataStoresRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1::ListDataStoresRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_data_stores(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_data_stores` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent branch resource name, such as
              #     `projects/{project}/locations/{location}/collections/{collection_id}`.
              #
              #     If the caller does not have permission to list
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}s under this
              #     location, regardless of whether or not this data store exists, a
              #     PERMISSION_DENIED error is returned.
              #   @param page_size [::Integer]
              #     Maximum number of {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}s
              #     to return. If unspecified, defaults to 10. The maximum allowed value is 50.
              #     Values above 50 will be coerced to 50.
              #
              #     If this field is negative, an INVALID_ARGUMENT is returned.
              #   @param page_token [::String]
              #     A page token
              #     {::Google::Cloud::DiscoveryEngine::V1::ListDataStoresResponse#next_page_token ListDataStoresResponse.next_page_token},
              #     received from a previous
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client#list_data_stores DataStoreService.ListDataStores}
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client#list_data_stores DataStoreService.ListDataStores}
              #     must match the call that provided the page token. Otherwise, an
              #     INVALID_ARGUMENT error is returned.
              #   @param filter [::String]
              #     Filter by solution type .
              #     For example: `filter = 'solution_type:SOLUTION_TYPE_SEARCH'`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1::DataStore>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DiscoveryEngine::V1::DataStore>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1::ListDataStoresRequest.new
              #
              #   # Call the list_data_stores method.
              #   result = client.list_data_stores request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DiscoveryEngine::V1::DataStore.
              #     p item
              #   end
              #
              def list_data_stores request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::ListDataStoresRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_data_stores.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_data_stores.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_data_stores.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_store_service_stub.list_data_stores request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @data_store_service_stub, :list_data_stores, "data_stores", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}.
              #
              # @overload delete_data_store(request, options = nil)
              #   Pass arguments to `delete_data_store` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1::DeleteDataStoreRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1::DeleteDataStoreRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_data_store(name: nil)
              #   Pass arguments to `delete_data_store` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Full resource name of
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, such as
              #     `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
              #
              #     If the caller does not have permission to delete the
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, regardless of
              #     whether or not it exists, a PERMISSION_DENIED error is returned.
              #
              #     If the {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} to delete
              #     does not exist, a NOT_FOUND error is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1::DeleteDataStoreRequest.new
              #
              #   # Call the delete_data_store method.
              #   result = client.delete_data_store request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_data_store request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::DeleteDataStoreRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_data_store.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_data_store.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_data_store.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_store_service_stub.delete_data_store request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}
              #
              # @overload update_data_store(request, options = nil)
              #   Pass arguments to `update_data_store` via a request object, either of type
              #   {::Google::Cloud::DiscoveryEngine::V1::UpdateDataStoreRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DiscoveryEngine::V1::UpdateDataStoreRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_data_store(data_store: nil, update_mask: nil)
              #   Pass arguments to `update_data_store` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param data_store [::Google::Cloud::DiscoveryEngine::V1::DataStore, ::Hash]
              #     Required. The {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} to
              #     update.
              #
              #     If the caller does not have permission to update the
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore}, regardless of
              #     whether or not it exists, a PERMISSION_DENIED error is returned.
              #
              #     If the {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} to update
              #     does not exist, a NOT_FOUND error is returned.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Indicates which fields in the provided
              #     {::Google::Cloud::DiscoveryEngine::V1::DataStore DataStore} to update.
              #
              #     If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
              #     is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DiscoveryEngine::V1::DataStore]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DiscoveryEngine::V1::DataStore]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/discovery_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DiscoveryEngine::V1::UpdateDataStoreRequest.new
              #
              #   # Call the update_data_store method.
              #   result = client.update_data_store request
              #
              #   # The returned object is of type Google::Cloud::DiscoveryEngine::V1::DataStore.
              #   p result
              #
              def update_data_store request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DiscoveryEngine::V1::UpdateDataStoreRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_data_store.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DiscoveryEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_data_store.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_data_store.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_store_service_stub.update_data_store request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DataStoreService REST API.
              #
              # This class represents the configuration for DataStoreService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_data_store to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_data_store.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::DiscoveryEngine::V1::DataStoreService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_data_store.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "discoveryengine.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the DataStoreService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_data_store`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_data_store
                  ##
                  # RPC-specific configuration for `get_data_store`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_data_store
                  ##
                  # RPC-specific configuration for `list_data_stores`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_data_stores
                  ##
                  # RPC-specific configuration for `delete_data_store`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_data_store
                  ##
                  # RPC-specific configuration for `update_data_store`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_data_store

                  # @private
                  def initialize parent_rpcs = nil
                    create_data_store_config = parent_rpcs.create_data_store if parent_rpcs.respond_to? :create_data_store
                    @create_data_store = ::Gapic::Config::Method.new create_data_store_config
                    get_data_store_config = parent_rpcs.get_data_store if parent_rpcs.respond_to? :get_data_store
                    @get_data_store = ::Gapic::Config::Method.new get_data_store_config
                    list_data_stores_config = parent_rpcs.list_data_stores if parent_rpcs.respond_to? :list_data_stores
                    @list_data_stores = ::Gapic::Config::Method.new list_data_stores_config
                    delete_data_store_config = parent_rpcs.delete_data_store if parent_rpcs.respond_to? :delete_data_store
                    @delete_data_store = ::Gapic::Config::Method.new delete_data_store_config
                    update_data_store_config = parent_rpcs.update_data_store if parent_rpcs.respond_to? :update_data_store
                    @update_data_store = ::Gapic::Config::Method.new update_data_store_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
