# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1
        module DataStoreService
          # Path helper methods for the DataStoreService API.
          module Paths
            ##
            # Create a fully-qualified CmekConfig resource string.
            #
            # @overload cmek_config_path(project:, location:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/cmekConfig`
            #
            #   @param project [String]
            #   @param location [String]
            #
            # @overload cmek_config_path(project:, location:, cmek_config:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param cmek_config [String]
            #
            # @return [::String]
            def cmek_config_path **args
              resources = {
                "location:project" => (proc do |project:, location:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/cmekConfig"
                end),
                "cmek_config:location:project" => (proc do |project:, location:, cmek_config:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/cmekConfigs/#{cmek_config}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Collection resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/collections/{collection}`
            #
            # @param project [String]
            # @param location [String]
            # @param collection [String]
            #
            # @return [::String]
            def collection_path project:, location:, collection:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/collections/#{collection}"
            end

            ##
            # Create a fully-qualified CryptoKeyVersions resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`
            #
            # @param project [String]
            # @param location [String]
            # @param key_ring [String]
            # @param crypto_key [String]
            # @param crypto_key_version [String]
            #
            # @return [::String]
            def crypto_key_versions_path project:, location:, key_ring:, crypto_key:, crypto_key_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"
              raise ::ArgumentError, "crypto_key cannot contain /" if crypto_key.to_s.include? "/"

              "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}/cryptoKeyVersions/#{crypto_key_version}"
            end

            ##
            # Create a fully-qualified CryptoKeys resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`
            #
            # @param project [String]
            # @param location [String]
            # @param key_ring [String]
            # @param crypto_key [String]
            #
            # @return [::String]
            def crypto_keys_path project:, location:, key_ring:, crypto_key:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"

              "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}"
            end

            ##
            # Create a fully-qualified DataStore resource string.
            #
            # @overload data_store_path(project:, location:, data_store:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/dataStores/{data_store}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param data_store [String]
            #
            # @overload data_store_path(project:, location:, collection:, data_store:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param collection [String]
            #   @param data_store [String]
            #
            # @return [::String]
            def data_store_path **args
              resources = {
                "data_store:location:project" => (proc do |project:, location:, data_store:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/dataStores/#{data_store}"
                end),
                "collection:data_store:location:project" => (proc do |project:, location:, collection:, data_store:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/collections/#{collection}/dataStores/#{data_store}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified DocumentProcessingConfig resource string.
            #
            # @overload document_processing_config_path(project:, location:, data_store:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/dataStores/{data_store}/documentProcessingConfig`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param data_store [String]
            #
            # @overload document_processing_config_path(project:, location:, collection:, data_store:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/documentProcessingConfig`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param collection [String]
            #   @param data_store [String]
            #
            # @return [::String]
            def document_processing_config_path **args
              resources = {
                "data_store:location:project" => (proc do |project:, location:, data_store:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/dataStores/#{data_store}/documentProcessingConfig"
                end),
                "collection:data_store:location:project" => (proc do |project:, location:, collection:, data_store:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/collections/#{collection}/dataStores/#{data_store}/documentProcessingConfig"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified IdentityMappingStore resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`
            #
            # @param project [String]
            # @param location [String]
            # @param identity_mapping_store [String]
            #
            # @return [::String]
            def identity_mapping_store_path project:, location:, identity_mapping_store:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/identityMappingStores/#{identity_mapping_store}"
            end

            ##
            # Create a fully-qualified Schema resource string.
            #
            # @overload schema_path(project:, location:, data_store:, schema:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/dataStores/{data_store}/schemas/{schema}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param data_store [String]
            #   @param schema [String]
            #
            # @overload schema_path(project:, location:, collection:, data_store:, schema:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/schemas/{schema}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param collection [String]
            #   @param data_store [String]
            #   @param schema [String]
            #
            # @return [::String]
            def schema_path **args
              resources = {
                "data_store:location:project:schema" => (proc do |project:, location:, data_store:, schema:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "data_store cannot contain /" if data_store.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/dataStores/#{data_store}/schemas/#{schema}"
                end),
                "collection:data_store:location:project:schema" => (proc do |project:, location:, collection:, data_store:, schema:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"
                  raise ::ArgumentError, "data_store cannot contain /" if data_store.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/collections/#{collection}/dataStores/#{data_store}/schemas/#{schema}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
