# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "google/cloud/dialogflow"
require "gapic/common"
require "gapic/grpc"
require "gapic/rest"

class Google::Cloud::Dialogflow::ClientConstructionMinitest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_agents_grpc
    skip unless Google::Cloud::Dialogflow.agents_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.agents transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Agents::Client, client
    end
  end

  def test_agents_rest
    skip unless Google::Cloud::Dialogflow.agents_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.agents transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Agents::Rest::Client, client
    end
  end

  def test_generators_grpc
    skip unless Google::Cloud::Dialogflow.generators_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.generators transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Generators::Client, client
    end
  end

  def test_generators_rest
    skip unless Google::Cloud::Dialogflow.generators_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.generators transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Generators::Rest::Client, client
    end
  end

  def test_contexts_grpc
    skip unless Google::Cloud::Dialogflow.contexts_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.contexts transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Contexts::Client, client
    end
  end

  def test_contexts_rest
    skip unless Google::Cloud::Dialogflow.contexts_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.contexts transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Contexts::Rest::Client, client
    end
  end

  def test_intents_grpc
    skip unless Google::Cloud::Dialogflow.intents_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.intents transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Intents::Client, client
    end
  end

  def test_intents_rest
    skip unless Google::Cloud::Dialogflow.intents_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.intents transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Intents::Rest::Client, client
    end
  end

  def test_entity_types_grpc
    skip unless Google::Cloud::Dialogflow.entity_types_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.entity_types transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::EntityTypes::Client, client
    end
  end

  def test_entity_types_rest
    skip unless Google::Cloud::Dialogflow.entity_types_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.entity_types transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::EntityTypes::Rest::Client, client
    end
  end

  def test_session_entity_types_grpc
    skip unless Google::Cloud::Dialogflow.session_entity_types_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.session_entity_types transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::SessionEntityTypes::Client, client
    end
  end

  def test_session_entity_types_rest
    skip unless Google::Cloud::Dialogflow.session_entity_types_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.session_entity_types transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::SessionEntityTypes::Rest::Client, client
    end
  end

  def test_sessions_grpc
    skip unless Google::Cloud::Dialogflow.sessions_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.sessions transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Sessions::Client, client
    end
  end

  def test_sessions_rest
    skip unless Google::Cloud::Dialogflow.sessions_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.sessions transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Sessions::Rest::Client, client
    end
  end

  def test_participants_grpc
    skip unless Google::Cloud::Dialogflow.participants_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.participants transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Participants::Client, client
    end
  end

  def test_participants_rest
    skip unless Google::Cloud::Dialogflow.participants_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.participants transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Participants::Rest::Client, client
    end
  end

  def test_answer_records_grpc
    skip unless Google::Cloud::Dialogflow.answer_records_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.answer_records transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::AnswerRecords::Client, client
    end
  end

  def test_answer_records_rest
    skip unless Google::Cloud::Dialogflow.answer_records_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.answer_records transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::AnswerRecords::Rest::Client, client
    end
  end

  def test_conversation_profiles_grpc
    skip unless Google::Cloud::Dialogflow.conversation_profiles_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.conversation_profiles transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::ConversationProfiles::Client, client
    end
  end

  def test_conversation_profiles_rest
    skip unless Google::Cloud::Dialogflow.conversation_profiles_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.conversation_profiles transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::ConversationProfiles::Rest::Client, client
    end
  end

  def test_conversations_grpc
    skip unless Google::Cloud::Dialogflow.conversations_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.conversations transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Conversations::Client, client
    end
  end

  def test_conversations_rest
    skip unless Google::Cloud::Dialogflow.conversations_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.conversations transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Conversations::Rest::Client, client
    end
  end

  def test_conversation_datasets_grpc
    skip unless Google::Cloud::Dialogflow.conversation_datasets_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.conversation_datasets transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::ConversationDatasets::Client, client
    end
  end

  def test_conversation_datasets_rest
    skip unless Google::Cloud::Dialogflow.conversation_datasets_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.conversation_datasets transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::ConversationDatasets::Rest::Client, client
    end
  end

  def test_conversation_models_grpc
    skip unless Google::Cloud::Dialogflow.conversation_models_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.conversation_models transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::ConversationModels::Client, client
    end
  end

  def test_conversation_models_rest
    skip unless Google::Cloud::Dialogflow.conversation_models_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.conversation_models transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::ConversationModels::Rest::Client, client
    end
  end

  def test_documents_grpc
    skip unless Google::Cloud::Dialogflow.documents_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.documents transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Documents::Client, client
    end
  end

  def test_documents_rest
    skip unless Google::Cloud::Dialogflow.documents_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.documents transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Documents::Rest::Client, client
    end
  end

  def test_encryption_spec_service_grpc
    skip unless Google::Cloud::Dialogflow.encryption_spec_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.encryption_spec_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::EncryptionSpecService::Client, client
    end
  end

  def test_encryption_spec_service_rest
    skip unless Google::Cloud::Dialogflow.encryption_spec_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.encryption_spec_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::EncryptionSpecService::Rest::Client, client
    end
  end

  def test_fulfillments_grpc
    skip unless Google::Cloud::Dialogflow.fulfillments_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.fulfillments transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Fulfillments::Client, client
    end
  end

  def test_fulfillments_rest
    skip unless Google::Cloud::Dialogflow.fulfillments_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.fulfillments transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Fulfillments::Rest::Client, client
    end
  end

  def test_environments_grpc
    skip unless Google::Cloud::Dialogflow.environments_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.environments transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Environments::Client, client
    end
  end

  def test_environments_rest
    skip unless Google::Cloud::Dialogflow.environments_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.environments transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Environments::Rest::Client, client
    end
  end

  def test_generator_evaluations_grpc
    skip unless Google::Cloud::Dialogflow.generator_evaluations_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.generator_evaluations transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::GeneratorEvaluations::Client, client
    end
  end

  def test_generator_evaluations_rest
    skip unless Google::Cloud::Dialogflow.generator_evaluations_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.generator_evaluations transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::GeneratorEvaluations::Rest::Client, client
    end
  end

  def test_knowledge_bases_grpc
    skip unless Google::Cloud::Dialogflow.knowledge_bases_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.knowledge_bases transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::KnowledgeBases::Client, client
    end
  end

  def test_knowledge_bases_rest
    skip unless Google::Cloud::Dialogflow.knowledge_bases_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.knowledge_bases transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::KnowledgeBases::Rest::Client, client
    end
  end

  def test_sip_trunks_grpc
    skip unless Google::Cloud::Dialogflow.sip_trunks_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.sip_trunks transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::SipTrunks::Client, client
    end
  end

  def test_sip_trunks_rest
    skip unless Google::Cloud::Dialogflow.sip_trunks_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.sip_trunks transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::SipTrunks::Rest::Client, client
    end
  end

  def test_tools_grpc
    skip unless Google::Cloud::Dialogflow.tools_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.tools transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Tools::Client, client
    end
  end

  def test_tools_rest
    skip unless Google::Cloud::Dialogflow.tools_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.tools transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Tools::Rest::Client, client
    end
  end

  def test_versions_grpc
    skip unless Google::Cloud::Dialogflow.versions_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Dialogflow.versions transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Versions::Client, client
    end
  end

  def test_versions_rest
    skip unless Google::Cloud::Dialogflow.versions_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Dialogflow.versions transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Dialogflow::V2::Versions::Rest::Client, client
    end
  end
end
