# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/dialogflow/v2/participant_pb"
require "google/cloud/dialogflow/v2/participants/rest"


class ::Google::Cloud::Dialogflow::V2::Participants::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_participant
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::V2::Participant.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    participant = {}

    create_participant_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::V2::Participants::Rest::ServiceStub.stub :transcode_create_participant_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_participant_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_participant({ parent: parent, participant: participant }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_participant parent: parent, participant: participant do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_participant ::Google::Cloud::Dialogflow::V2::CreateParticipantRequest.new(parent: parent, participant: participant) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_participant({ parent: parent, participant: participant }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_participant(::Google::Cloud::Dialogflow::V2::CreateParticipantRequest.new(parent: parent, participant: participant), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_participant_client_stub.call_count
      end
    end
  end

  def test_get_participant
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::V2::Participant.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_participant_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::V2::Participants::Rest::ServiceStub.stub :transcode_get_participant_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_participant_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_participant({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_participant name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_participant ::Google::Cloud::Dialogflow::V2::GetParticipantRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_participant({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_participant(::Google::Cloud::Dialogflow::V2::GetParticipantRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_participant_client_stub.call_count
      end
    end
  end

  def test_list_participants
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::V2::ListParticipantsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_participants_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::V2::Participants::Rest::ServiceStub.stub :transcode_list_participants_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_participants_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_participants({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_participants parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_participants ::Google::Cloud::Dialogflow::V2::ListParticipantsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_participants({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_participants(::Google::Cloud::Dialogflow::V2::ListParticipantsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_participants_client_stub.call_count
      end
    end
  end

  def test_update_participant
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::V2::Participant.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    participant = {}
    update_mask = {}

    update_participant_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::V2::Participants::Rest::ServiceStub.stub :transcode_update_participant_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_participant_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_participant({ participant: participant, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_participant participant: participant, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_participant ::Google::Cloud::Dialogflow::V2::UpdateParticipantRequest.new(participant: participant, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_participant({ participant: participant, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_participant(::Google::Cloud::Dialogflow::V2::UpdateParticipantRequest.new(participant: participant, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_participant_client_stub.call_count
      end
    end
  end

  def test_analyze_content
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::V2::AnalyzeContentResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    participant = "hello world"
    text_input = {}
    reply_audio_config = {}
    query_params = {}
    assist_query_params = {}
    cx_parameters = {}
    request_id = "hello world"

    analyze_content_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::V2::Participants::Rest::ServiceStub.stub :transcode_analyze_content_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, analyze_content_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.analyze_content({ participant: participant, text_input: text_input, reply_audio_config: reply_audio_config, query_params: query_params, assist_query_params: assist_query_params, cx_parameters: cx_parameters, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.analyze_content participant: participant, text_input: text_input, reply_audio_config: reply_audio_config, query_params: query_params, assist_query_params: assist_query_params, cx_parameters: cx_parameters, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.analyze_content ::Google::Cloud::Dialogflow::V2::AnalyzeContentRequest.new(participant: participant, text_input: text_input, reply_audio_config: reply_audio_config, query_params: query_params, assist_query_params: assist_query_params, cx_parameters: cx_parameters, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.analyze_content({ participant: participant, text_input: text_input, reply_audio_config: reply_audio_config, query_params: query_params, assist_query_params: assist_query_params, cx_parameters: cx_parameters, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.analyze_content(::Google::Cloud::Dialogflow::V2::AnalyzeContentRequest.new(participant: participant, text_input: text_input, reply_audio_config: reply_audio_config, query_params: query_params, assist_query_params: assist_query_params, cx_parameters: cx_parameters, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, analyze_content_client_stub.call_count
      end
    end
  end

  def test_suggest_articles
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::V2::SuggestArticlesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    latest_message = "hello world"
    context_size = 42
    assist_query_params = {}

    suggest_articles_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::V2::Participants::Rest::ServiceStub.stub :transcode_suggest_articles_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, suggest_articles_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.suggest_articles({ parent: parent, latest_message: latest_message, context_size: context_size, assist_query_params: assist_query_params }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.suggest_articles parent: parent, latest_message: latest_message, context_size: context_size, assist_query_params: assist_query_params do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.suggest_articles ::Google::Cloud::Dialogflow::V2::SuggestArticlesRequest.new(parent: parent, latest_message: latest_message, context_size: context_size, assist_query_params: assist_query_params) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.suggest_articles({ parent: parent, latest_message: latest_message, context_size: context_size, assist_query_params: assist_query_params }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.suggest_articles(::Google::Cloud::Dialogflow::V2::SuggestArticlesRequest.new(parent: parent, latest_message: latest_message, context_size: context_size, assist_query_params: assist_query_params), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, suggest_articles_client_stub.call_count
      end
    end
  end

  def test_suggest_faq_answers
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::V2::SuggestFaqAnswersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    latest_message = "hello world"
    context_size = 42
    assist_query_params = {}

    suggest_faq_answers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::V2::Participants::Rest::ServiceStub.stub :transcode_suggest_faq_answers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, suggest_faq_answers_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.suggest_faq_answers({ parent: parent, latest_message: latest_message, context_size: context_size, assist_query_params: assist_query_params }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.suggest_faq_answers parent: parent, latest_message: latest_message, context_size: context_size, assist_query_params: assist_query_params do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.suggest_faq_answers ::Google::Cloud::Dialogflow::V2::SuggestFaqAnswersRequest.new(parent: parent, latest_message: latest_message, context_size: context_size, assist_query_params: assist_query_params) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.suggest_faq_answers({ parent: parent, latest_message: latest_message, context_size: context_size, assist_query_params: assist_query_params }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.suggest_faq_answers(::Google::Cloud::Dialogflow::V2::SuggestFaqAnswersRequest.new(parent: parent, latest_message: latest_message, context_size: context_size, assist_query_params: assist_query_params), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, suggest_faq_answers_client_stub.call_count
      end
    end
  end

  def test_suggest_smart_replies
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::V2::SuggestSmartRepliesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    current_text_input = {}
    latest_message = "hello world"
    context_size = 42

    suggest_smart_replies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::V2::Participants::Rest::ServiceStub.stub :transcode_suggest_smart_replies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, suggest_smart_replies_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.suggest_smart_replies({ parent: parent, current_text_input: current_text_input, latest_message: latest_message, context_size: context_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.suggest_smart_replies parent: parent, current_text_input: current_text_input, latest_message: latest_message, context_size: context_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.suggest_smart_replies ::Google::Cloud::Dialogflow::V2::SuggestSmartRepliesRequest.new(parent: parent, current_text_input: current_text_input, latest_message: latest_message, context_size: context_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.suggest_smart_replies({ parent: parent, current_text_input: current_text_input, latest_message: latest_message, context_size: context_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.suggest_smart_replies(::Google::Cloud::Dialogflow::V2::SuggestSmartRepliesRequest.new(parent: parent, current_text_input: current_text_input, latest_message: latest_message, context_size: context_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, suggest_smart_replies_client_stub.call_count
      end
    end
  end

  def test_suggest_knowledge_assist
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    latest_message = "hello world"
    context_size = 42
    previous_suggested_query = "hello world"

    suggest_knowledge_assist_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::V2::Participants::Rest::ServiceStub.stub :transcode_suggest_knowledge_assist_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, suggest_knowledge_assist_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.suggest_knowledge_assist({ parent: parent, latest_message: latest_message, context_size: context_size, previous_suggested_query: previous_suggested_query }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.suggest_knowledge_assist parent: parent, latest_message: latest_message, context_size: context_size, previous_suggested_query: previous_suggested_query do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.suggest_knowledge_assist ::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistRequest.new(parent: parent, latest_message: latest_message, context_size: context_size, previous_suggested_query: previous_suggested_query) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.suggest_knowledge_assist({ parent: parent, latest_message: latest_message, context_size: context_size, previous_suggested_query: previous_suggested_query }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.suggest_knowledge_assist(::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistRequest.new(parent: parent, latest_message: latest_message, context_size: context_size, previous_suggested_query: previous_suggested_query), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, suggest_knowledge_assist_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client::Configuration, config
  end
end
