# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dialogflow/v2/environments"

class ::Google::Cloud::Dialogflow::V2::Environments::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_agent_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dialogflow::V2::Environments::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.agent_path project: "value0"
      assert_equal "projects/value0/agent", path

      path = client.agent_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1/agent", path
    end
  end

  def test_environment_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dialogflow::V2::Environments::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.environment_path project: "value0", environment: "value1"
      assert_equal "projects/value0/agent/environments/value1", path

      path = client.environment_path project: "value0", location: "value1", environment: "value2"
      assert_equal "projects/value0/locations/value1/agent/environments/value2", path
    end
  end

  def test_fulfillment_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dialogflow::V2::Environments::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.fulfillment_path project: "value0"
      assert_equal "projects/value0/agent/fulfillment", path

      path = client.fulfillment_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1/agent/fulfillment", path
    end
  end

  def test_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dialogflow::V2::Environments::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.version_path project: "value0", version: "value1"
      assert_equal "projects/value0/agent/versions/value1", path

      path = client.version_path project: "value0", location: "value1", version: "value2"
      assert_equal "projects/value0/locations/value1/agent/versions/value2", path
    end
  end
end
