# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dialogflow/v2/conversation_model_pb"
require "google/cloud/dialogflow/v2/conversation_models"

class ::Google::Cloud::Dialogflow::V2::ConversationModels::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_conversation_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    conversation_model = {}

    create_conversation_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_conversation_model, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::CreateConversationModelRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dialogflow::V2::ConversationModel), request["conversation_model"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_conversation_model_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationModels::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_conversation_model({ parent: parent, conversation_model: conversation_model }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_conversation_model parent: parent, conversation_model: conversation_model do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_conversation_model ::Google::Cloud::Dialogflow::V2::CreateConversationModelRequest.new(parent: parent, conversation_model: conversation_model) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_conversation_model({ parent: parent, conversation_model: conversation_model }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_conversation_model(::Google::Cloud::Dialogflow::V2::CreateConversationModelRequest.new(parent: parent, conversation_model: conversation_model), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_conversation_model_client_stub.call_rpc_count
    end
  end

  def test_get_conversation_model
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::V2::ConversationModel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_conversation_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_conversation_model, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::GetConversationModelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_conversation_model_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationModels::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_conversation_model({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_conversation_model name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_conversation_model ::Google::Cloud::Dialogflow::V2::GetConversationModelRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_conversation_model({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_conversation_model(::Google::Cloud::Dialogflow::V2::GetConversationModelRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_conversation_model_client_stub.call_rpc_count
    end
  end

  def test_list_conversation_models
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::V2::ListConversationModelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_conversation_models_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_conversation_models, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::ListConversationModelsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_conversation_models_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationModels::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_conversation_models({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_conversation_models parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_conversation_models ::Google::Cloud::Dialogflow::V2::ListConversationModelsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_conversation_models({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_conversation_models(::Google::Cloud::Dialogflow::V2::ListConversationModelsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_conversation_models_client_stub.call_rpc_count
    end
  end

  def test_delete_conversation_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_conversation_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_conversation_model, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::DeleteConversationModelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_conversation_model_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationModels::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_conversation_model({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_conversation_model name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_conversation_model ::Google::Cloud::Dialogflow::V2::DeleteConversationModelRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_conversation_model({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_conversation_model(::Google::Cloud::Dialogflow::V2::DeleteConversationModelRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_conversation_model_client_stub.call_rpc_count
    end
  end

  def test_deploy_conversation_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    deploy_conversation_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :deploy_conversation_model, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::DeployConversationModelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, deploy_conversation_model_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationModels::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.deploy_conversation_model({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.deploy_conversation_model name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.deploy_conversation_model ::Google::Cloud::Dialogflow::V2::DeployConversationModelRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.deploy_conversation_model({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.deploy_conversation_model(::Google::Cloud::Dialogflow::V2::DeployConversationModelRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, deploy_conversation_model_client_stub.call_rpc_count
    end
  end

  def test_undeploy_conversation_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    undeploy_conversation_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undeploy_conversation_model, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::UndeployConversationModelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undeploy_conversation_model_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationModels::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undeploy_conversation_model({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undeploy_conversation_model name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undeploy_conversation_model ::Google::Cloud::Dialogflow::V2::UndeployConversationModelRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undeploy_conversation_model({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undeploy_conversation_model(::Google::Cloud::Dialogflow::V2::UndeployConversationModelRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undeploy_conversation_model_client_stub.call_rpc_count
    end
  end

  def test_get_conversation_model_evaluation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::V2::ConversationModelEvaluation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_conversation_model_evaluation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_conversation_model_evaluation, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::GetConversationModelEvaluationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_conversation_model_evaluation_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationModels::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_conversation_model_evaluation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_conversation_model_evaluation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_conversation_model_evaluation ::Google::Cloud::Dialogflow::V2::GetConversationModelEvaluationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_conversation_model_evaluation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_conversation_model_evaluation(::Google::Cloud::Dialogflow::V2::GetConversationModelEvaluationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_conversation_model_evaluation_client_stub.call_rpc_count
    end
  end

  def test_list_conversation_model_evaluations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::V2::ListConversationModelEvaluationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_conversation_model_evaluations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_conversation_model_evaluations, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::ListConversationModelEvaluationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_conversation_model_evaluations_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationModels::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_conversation_model_evaluations({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_conversation_model_evaluations parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_conversation_model_evaluations ::Google::Cloud::Dialogflow::V2::ListConversationModelEvaluationsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_conversation_model_evaluations({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_conversation_model_evaluations(::Google::Cloud::Dialogflow::V2::ListConversationModelEvaluationsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_conversation_model_evaluations_client_stub.call_rpc_count
    end
  end

  def test_create_conversation_model_evaluation
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    conversation_model_evaluation = {}

    create_conversation_model_evaluation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_conversation_model_evaluation, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::CreateConversationModelEvaluationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dialogflow::V2::ConversationModelEvaluation), request["conversation_model_evaluation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_conversation_model_evaluation_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationModels::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_conversation_model_evaluation({ parent: parent, conversation_model_evaluation: conversation_model_evaluation }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_conversation_model_evaluation parent: parent, conversation_model_evaluation: conversation_model_evaluation do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_conversation_model_evaluation ::Google::Cloud::Dialogflow::V2::CreateConversationModelEvaluationRequest.new(parent: parent, conversation_model_evaluation: conversation_model_evaluation) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_conversation_model_evaluation({ parent: parent, conversation_model_evaluation: conversation_model_evaluation }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_conversation_model_evaluation(::Google::Cloud::Dialogflow::V2::CreateConversationModelEvaluationRequest.new(parent: parent, conversation_model_evaluation: conversation_model_evaluation), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_conversation_model_evaluation_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::V2::ConversationModels::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dialogflow::V2::ConversationModels::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::V2::ConversationModels::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Dialogflow::V2::ConversationModels::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::V2::ConversationModels::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Dialogflow::V2::ConversationModels::Operations, client.operations_client
  end
end
