# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dialogflow/v2/conversation_dataset_pb"
require "google/cloud/dialogflow/v2/conversation_datasets"

class ::Google::Cloud::Dialogflow::V2::ConversationDatasets::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_conversation_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    conversation_dataset = {}

    create_conversation_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_conversation_dataset, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::CreateConversationDatasetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dialogflow::V2::ConversationDataset), request["conversation_dataset"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_conversation_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationDatasets::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_conversation_dataset({ parent: parent, conversation_dataset: conversation_dataset }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_conversation_dataset parent: parent, conversation_dataset: conversation_dataset do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_conversation_dataset ::Google::Cloud::Dialogflow::V2::CreateConversationDatasetRequest.new(parent: parent, conversation_dataset: conversation_dataset) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_conversation_dataset({ parent: parent, conversation_dataset: conversation_dataset }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_conversation_dataset(::Google::Cloud::Dialogflow::V2::CreateConversationDatasetRequest.new(parent: parent, conversation_dataset: conversation_dataset), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_conversation_dataset_client_stub.call_rpc_count
    end
  end

  def test_get_conversation_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::V2::ConversationDataset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_conversation_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_conversation_dataset, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::GetConversationDatasetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_conversation_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationDatasets::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_conversation_dataset({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_conversation_dataset name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_conversation_dataset ::Google::Cloud::Dialogflow::V2::GetConversationDatasetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_conversation_dataset({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_conversation_dataset(::Google::Cloud::Dialogflow::V2::GetConversationDatasetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_conversation_dataset_client_stub.call_rpc_count
    end
  end

  def test_list_conversation_datasets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::V2::ListConversationDatasetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_conversation_datasets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_conversation_datasets, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::ListConversationDatasetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_conversation_datasets_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationDatasets::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_conversation_datasets({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_conversation_datasets parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_conversation_datasets ::Google::Cloud::Dialogflow::V2::ListConversationDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_conversation_datasets({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_conversation_datasets(::Google::Cloud::Dialogflow::V2::ListConversationDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_conversation_datasets_client_stub.call_rpc_count
    end
  end

  def test_delete_conversation_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_conversation_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_conversation_dataset, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::DeleteConversationDatasetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_conversation_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationDatasets::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_conversation_dataset({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_conversation_dataset name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_conversation_dataset ::Google::Cloud::Dialogflow::V2::DeleteConversationDatasetRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_conversation_dataset({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_conversation_dataset(::Google::Cloud::Dialogflow::V2::DeleteConversationDatasetRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_conversation_dataset_client_stub.call_rpc_count
    end
  end

  def test_import_conversation_data
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    input_config = {}

    import_conversation_data_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_conversation_data, name
      assert_kind_of ::Google::Cloud::Dialogflow::V2::ImportConversationDataRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dialogflow::V2::InputConfig), request["input_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_conversation_data_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::V2::ConversationDatasets::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_conversation_data({ name: name, input_config: input_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_conversation_data name: name, input_config: input_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_conversation_data ::Google::Cloud::Dialogflow::V2::ImportConversationDataRequest.new(name: name, input_config: input_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_conversation_data({ name: name, input_config: input_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_conversation_data(::Google::Cloud::Dialogflow::V2::ImportConversationDataRequest.new(name: name, input_config: input_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_conversation_data_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::V2::ConversationDatasets::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dialogflow::V2::ConversationDatasets::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::V2::ConversationDatasets::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Dialogflow::V2::ConversationDatasets::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::V2::ConversationDatasets::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Dialogflow::V2::ConversationDatasets::Operations, client.operations_client
  end
end
